/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.platform.database.SybasePlatform;
import org.eclipse.persistence.queries.ValueReadQuery;

public class SQLAnywherePlatform
extends SybasePlatform {
    protected Hashtable buildFieldTypes() {
        Hashtable fieldTypeMapping = super.buildFieldTypes();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("BIT", false));
        return fieldTypeMapping;
    }

    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery selectQuery = new ValueReadQuery();
        StringWriter writer = new StringWriter();
        writer.write("SELECT @@IDENTITY");
        selectQuery.setSQLString(writer.toString());
        return selectQuery;
    }

    public static ExpressionOperator createCurrentDateOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(123, "CURRENT DATE");
    }

    public static ExpressionOperator createCurrentTimeOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(128, "CURRENT TIME");
    }

    public static ExpressionOperator createLocate2Operator() {
        return ExpressionOperator.simpleThreeArgumentFunction(113, "LOCATE");
    }

    public static ExpressionOperator createConcatOperator() {
        return ExpressionOperator.simpleLogicalNoParens(31, "||");
    }

    public static ExpressionOperator createLocateOperator() {
        return ExpressionOperator.simpleTwoArgumentFunction(112, "LOCATE");
    }

    protected String getCreateTempTableSqlPrefix() {
        return "DECLARE LOCAL TEMPORARY TABLE ";
    }

    public String getInputProcedureToken() {
        return "IN";
    }

    public String getInOutputProcedureToken() {
        return "";
    }

    public String getCreationOutputProcedureToken() {
        return "OUT";
    }

    public String getOutputProcedureToken() {
        return "";
    }

    public int getJDBCType(Class javaType) {
        return javaType == ClassConstants.BLOB ? -4 : (javaType == ClassConstants.CLOB ? -1 : super.getJDBCType(javaType));
    }

    public int getMaxFieldNameSize() {
        return 128;
    }

    public String getProcedureArgumentString() {
        return "";
    }

    public String getStoredProcedureParameterPrefix() {
        return "";
    }

    public String getStoredProcedureTerminationToken() {
        return ";";
    }

    public String getProcedureAsString() {
        return "";
    }

    public String getProcedureBeginString() {
        return "BEGIN";
    }

    public String getProcedureEndString() {
        return "END";
    }

    public String getBatchBeginString() {
        return "BEGIN ";
    }

    public String getBatchEndString() {
        return "END;";
    }

    public String getBatchDelimiterString() {
        return "; ";
    }

    public String getProcedureCallHeader() {
        return "CALL ";
    }

    public DatabaseTable getTempTableForTable(DatabaseTable table) {
        return new DatabaseTable("$" + table.getName(), table.getTableQualifier(), table.shouldUseDelimiters(), this.getStartDelimiter(), this.getEndDelimiter());
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(SQLAnywherePlatform.createConcatOperator());
        this.addOperator(SQLAnywherePlatform.createLocateOperator());
        this.addOperator(SQLAnywherePlatform.createLocate2Operator());
        this.addOperator(ExpressionOperator.charLength());
        this.addOperator(ExpressionOperator.mod());
    }

    public boolean isSQLAnywhere() {
        return true;
    }

    public boolean isSybase() {
        return false;
    }

    public boolean requiresProcedureBrackets() {
        return true;
    }

    public boolean requiresProcedureCallBrackets() {
        return true;
    }

    public boolean requiresTypeNameToRegisterOutputParameter() {
        return false;
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" DEFAULT AUTOINCREMENT");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void printFieldNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NULL");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public boolean shouldPrintInputTokenAtStart() {
        return true;
    }

    public boolean shouldPrintInOutputTokenBeforeType() {
        return false;
    }

    public boolean shouldPrintOutputTokenAtStart() {
        return true;
    }

    public boolean shouldPrintOutputTokenBeforeType() {
        return false;
    }

    public boolean shouldPrintStoredProcedureArgumentNameInCall() {
        return false;
    }

    public boolean shouldPrintStoredProcedureVariablesAfterBeginString() {
        return true;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public boolean supportsLocalTempTables() {
        return true;
    }

    public boolean supportsStoredFunctions() {
        return true;
    }

    public boolean shouldBindLiterals() {
        return false;
    }
}

