/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ValueReadQuery;

public class CursoredStream
extends Cursor {
    protected int marker;

    public CursoredStream() {
    }

    public CursoredStream(DatabaseCall call, CursoredStreamPolicy policy) {
        super(call, policy);
        try {
            this.setLimits();
        }
        catch (RuntimeException exception) {
            try {
                this.close();
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
            throw exception;
        }
    }

    public boolean atEnd() throws DatabaseException {
        if (this.getPosition() + 1 <= this.getObjectCollection().size()) {
            return false;
        }
        if (this.isClosed()) {
            return true;
        }
        int oldSize = this.getObjectCollection().size();
        this.retrieveNextPage();
        return this.getObjectCollection().size() == oldSize;
    }

    public int available() throws DatabaseException {
        return this.getObjectCollection().size() - this.getPosition();
    }

    public Expression buildCountDistinctExpression(List includeFields, ExpressionBuilder builder) {
        ExpressionOperator countOperator = new ExpressionOperator();
        countOperator.setType(3);
        Vector<String> databaseStrings = new Vector<String>();
        databaseStrings.addElement("COUNT(DISTINCT ");
        databaseStrings.addElement(")");
        countOperator.printsAs(databaseStrings);
        countOperator.bePrefix();
        countOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        Expression firstFieldExpression = builder.getField(((DatabaseField)includeFields.get(0)).getQualifiedName());
        return countOperator.expressionForArguments(firstFieldExpression, new Vector(0));
    }

    protected Vector copy(int startIndex, int endIndex) throws QueryException {
        while (this.getObjectCollection().size() < endIndex) {
            if (this.retrieveNextObject() != null) continue;
            throw QueryException.readBeyondStream(this.getQuery());
        }
        return Helper.copyVector(this.getObjectCollection(), startIndex, endIndex);
    }

    protected int getCursorSize() throws DatabaseException, QueryException {
        ValueReadQuery query;
        if (!((CursoredStreamPolicy)this.getPolicy()).hasSizeQuery()) {
            if (this.getQuery().isCallQuery()) {
                throw QueryException.additionalSizeQueryNotSpecified(this.getQuery());
            }
            if (!this.getQuery().isExpressionQuery()) {
                throw QueryException.sizeOnlySupportedOnExpressionQueries(this.getQuery());
            }
            SQLSelectStatement selectStatement = new SQLSelectStatement();
            IdentityHashMap clonedExpressions = new IdentityHashMap();
            selectStatement.setWhereClause(((ExpressionQueryMechanism)this.getQuery().getQueryMechanism()).buildBaseSelectionCriteria(false, clonedExpressions));
            if (this.getQuery().getDescriptor().hasInheritance() && this.getQuery().getDescriptor().getInheritancePolicy().getWithAllSubclassesExpression() != null) {
                Expression branchIndicator = this.getQuery().getDescriptor().getInheritancePolicy().getWithAllSubclassesExpression();
                if (branchIndicator != null && selectStatement.getWhereClause() != null) {
                    selectStatement.setWhereClause(selectStatement.getWhereClause().and(branchIndicator));
                } else if (branchIndicator != null) {
                    selectStatement.setWhereClause((Expression)branchIndicator.clone());
                }
            }
            selectStatement.setTables((Vector)this.getQuery().getDescriptor().getTables().clone());
            if (((ReadAllQuery)this.getQuery()).shouldDistinctBeUsed() && this.getQuery().getCall().getFields().size() == 1) {
                selectStatement.addField(this.buildCountDistinctExpression(this.getQuery().getCall().getFields(), ((ReadAllQuery)this.getQuery()).getExpressionBuilder()));
            } else {
                selectStatement.computeDistinct();
                if (selectStatement.shouldDistinctBeUsed() && this.getQuery().getDescriptor().getPrimaryKeyFields().size() == 1) {
                    selectStatement.addField(this.buildCountDistinctExpression(this.getQuery().getDescriptor().getPrimaryKeyFields(), ((ReadAllQuery)this.getQuery()).getExpressionBuilder()));
                } else {
                    selectStatement.addField(((ReadAllQuery)this.getQuery()).getExpressionBuilder().count());
                }
                selectStatement.dontUseDistinct();
            }
            selectStatement.normalize(this.getSession(), this.getQuery().getDescriptor(), clonedExpressions);
            query = new ValueReadQuery();
            query.setSQLStatement(selectStatement);
        } else {
            query = ((CursoredStreamPolicy)this.getPolicy()).getSizeQuery();
        }
        Number value = (Number)this.getSession().executeQuery((DatabaseQuery)query, this.getQuery().getTranslationRow());
        if (value == null) {
            throw QueryException.incorrectSizeQueryForCursorStream(this.getQuery());
        }
        return value.intValue();
    }

    protected int getInitialReadSize() {
        return ((CursoredStreamPolicy)this.getPolicy()).getInitialReadSize();
    }

    protected int getMarker() {
        return this.marker;
    }

    public int getPageSize() {
        return ((CursoredStreamPolicy)this.getPolicy()).getPageSize();
    }

    public int getPosition() {
        return this.position;
    }

    public boolean hasMoreElements() {
        return !this.atEnd();
    }

    public void mark(int readAheadLimit) {
        this.setMarker(this.getPosition());
    }

    public boolean markSupported() {
        return true;
    }

    public Object nextElement() {
        return this.read();
    }

    public Vector nextElements(int numberOfElements) {
        Vector<Object> nextElements = new Vector<Object>(numberOfElements);
        while (nextElements.size() < numberOfElements) {
            if (this.atEnd()) {
                return nextElements;
            }
            nextElements.add(this.nextElement());
        }
        return nextElements;
    }

    public Object peek() throws DatabaseException {
        Object object = this.read();
        this.setPosition(this.getPosition() - 1);
        return object;
    }

    public Object read() throws DatabaseException, QueryException {
        if (this.getObjectCollection().size() == this.getPosition()) {
            this.retrieveNextPage();
        }
        if (this.atEnd()) {
            throw QueryException.readBeyondStream(this.getQuery());
        }
        Object object = this.getObjectCollection().elementAt(this.getPosition());
        this.setPosition(this.getPosition() + 1);
        return object;
    }

    public Vector read(int number) throws DatabaseException {
        Vector result = this.copy(this.getPosition(), this.getPosition() + number);
        this.setPosition(this.getPosition() + result.size());
        return result;
    }

    public void releasePrevious() {
        if (this.getPosition() == 0) {
            return;
        }
        this.setObjectCollection(Helper.copyVector(this.getObjectCollection(), this.getPosition(), this.getObjectCollection().size()));
        this.setPosition(0);
    }

    public void reset() {
        this.setPosition(this.getMarker());
    }

    protected Object retrieveNextObject() throws DatabaseException {
        Object next = super.retrieveNextObject();
        if (next != null) {
            this.getObjectCollection().addElement(next);
        }
        return next;
    }

    protected Object retrieveNextPage() throws DatabaseException {
        Object last = null;
        for (int index = 0; index < this.getPageSize(); ++index) {
            last = this.retrieveNextObject();
            if (last != null) continue;
            return null;
        }
        return last;
    }

    protected void setLimits() {
        this.setPosition(0);
        this.setMarker(0);
        for (int index = 0; index < this.getInitialReadSize(); ++index) {
            this.retrieveNextObject();
        }
    }

    protected void setMarker(int value) {
        this.marker = value;
    }
}

