/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.ConcurrentFixedCache;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.AbstractIdentityMap;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.SQLResultSetMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
implements Serializable,
Cloneable {
    protected String name = "";
    protected Login datasourceLogin;
    protected Map descriptors;
    protected Vector orderedDescriptors;
    protected Vector defaultReadOnlyClasses;
    protected Map aliasDescriptors;
    protected boolean hasIsolatedClasses = false;
    protected boolean hasNonIsolatedUOWClasses;
    protected boolean hasGenericHistorySupport = false;
    protected boolean hasProxyIndirection = false;
    protected Map sqlResultSetMappings;
    protected transient ConcurrentFixedCache jpqlParseCache;
    protected boolean defaultTemporalMutable = false;
    protected transient boolean hasMappingsPostCalculateChangesOnDeleted = false;
    protected Class defaultIdentityMapClass = AbstractIdentityMap.getDefaultIdentityMapClass();
    protected int defaultIdentityMapSize = 100;
    protected boolean defaultIsIsolated = false;
    protected transient List<DatabaseQuery> queries = null;
    protected Map<Object, RelationalDescriptor> mappedSuperclassDescriptors;
    protected Map<String, List<String>> metamodelIdClassMap;

    public Project() {
        this.descriptors = new HashMap();
        this.defaultReadOnlyClasses = NonSynchronizedVector.newInstance();
        this.orderedDescriptors = NonSynchronizedVector.newInstance();
        this.jpqlParseCache = new ConcurrentFixedCache(200);
        this.queries = new ArrayList<DatabaseQuery>();
        this.mappedSuperclassDescriptors = new HashMap<Object, RelationalDescriptor>(2);
        this.metamodelIdClassMap = new HashMap<String, List<String>>();
    }

    public Project(Login login) {
        this();
        this.datasourceLogin = login;
    }

    public Project(DatabaseLogin login) {
        this();
        this.datasourceLogin = login;
    }

    public boolean getDefaultTemporalMutable() {
        return this.defaultTemporalMutable;
    }

    public void setDefaultTemporalMutable(boolean defaultTemporalMutable) {
        this.defaultTemporalMutable = defaultTemporalMutable;
    }

    public ConcurrentFixedCache getJPQLParseCache() {
        return this.jpqlParseCache;
    }

    public void setJPQLParseCacheMaxSize(int maxSize) {
        this.setJPQLParseCache(new ConcurrentFixedCache(maxSize));
    }

    public int getJPQLParseCacheMaxSize() {
        return this.getJPQLParseCache().getMaxSize();
    }

    protected void setJPQLParseCache(ConcurrentFixedCache jpqlParseCache) {
        this.jpqlParseCache = jpqlParseCache;
    }

    public List<DatabaseQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<DatabaseQuery> queries) {
        this.queries = queries;
    }

    public void addDefaultReadOnlyClass(Class readOnlyClass) {
        this.getDefaultReadOnlyClasses().addElement(readOnlyClass);
    }

    public void addDescriptor(ClassDescriptor descriptor) {
        this.getOrderedDescriptors().add(descriptor);
        String alias = descriptor.getAlias();
        if (alias != null) {
            this.addAlias(alias, descriptor);
        }
        if (this.descriptors != null && !this.descriptors.isEmpty()) {
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
        }
    }

    public void addDescriptor(ClassDescriptor descriptor, DatabaseSessionImpl session) {
        this.getOrderedDescriptors().add(descriptor);
        String alias = descriptor.getAlias();
        if (alias != null) {
            this.addAlias(alias, descriptor);
        }
        if (this.descriptors != null && !this.descriptors.isEmpty()) {
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
        }
        session.initializeDescriptorIfSessionAlive(descriptor);
    }

    public void addDescriptors(Collection descriptors, DatabaseSessionImpl session) {
        for (ClassDescriptor descriptor : descriptors) {
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
            String alias = descriptor.getAlias();
            if (alias == null) continue;
            this.addAlias(alias, descriptor);
        }
        if (session.isConnected()) {
            session.initializeDescriptors(descriptors);
            session.getCommitManager().initializeCommitOrder();
        }
        this.getOrderedDescriptors().addAll(descriptors);
    }

    public void addDescriptors(Project project, DatabaseSessionImpl session) {
        for (ClassDescriptor descriptor : project.getDescriptors().values()) {
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
            String alias = descriptor.getAlias();
            if (alias == null) continue;
            this.addAlias(alias, descriptor);
        }
        if (session.isConnected()) {
            session.initializeDescriptors(project.getDescriptors());
            session.getCommitManager().initializeCommitOrder();
        }
        this.getOrderedDescriptors().addAll(project.getOrderedDescriptors());
    }

    public void addSQLResultSetMapping(SQLResultSetMapping sqlResultSetMapping) {
        if (sqlResultSetMapping == null || sqlResultSetMapping.getName() == null) {
            return;
        }
        if (this.sqlResultSetMappings == null) {
            this.sqlResultSetMappings = new HashMap();
        }
        this.sqlResultSetMappings.put(sqlResultSetMapping.getName(), sqlResultSetMapping);
    }

    public void conformAllDescriptors() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.setShouldAlwaysConformResultsInUnitOfWork(true);
        }
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        for (ClassDescriptor descriptor : this.orderedDescriptors) {
            descriptor.convertClassNamesToClasses(classLoader);
        }
        this.descriptors = new HashMap();
        if (this.sqlResultSetMappings != null) {
            Iterator mappingIt = this.sqlResultSetMappings.keySet().iterator();
            while (mappingIt.hasNext()) {
                SQLResultSetMapping mapping = (SQLResultSetMapping)this.sqlResultSetMappings.get(mappingIt.next());
                mapping.convertClassNamesToClasses(classLoader);
            }
        }
    }

    public void assumeExistenceForDoesExist() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.getQueryManager().assumeExistenceForDoesExist();
        }
    }

    public void checkCacheForDoesExist() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.getQueryManager().checkCacheForDoesExist();
        }
    }

    public void checkDatabaseForDoesExist() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.getQueryManager().checkDatabaseForDoesExist();
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DatabaseSession createDatabaseSession() {
        return new DatabaseSessionImpl(this);
    }

    public Server createServerSession() {
        return new ServerSession(this);
    }

    public Server createServerSession(int min, int max) {
        return new ServerSession(this, min, max);
    }

    public Server createServerSession(int initial, int min, int max) {
        return new ServerSession(this, initial, min, max);
    }

    public Server createServerSession(ConnectionPolicy defaultConnectionPolicy) {
        return new ServerSession(this, defaultConnectionPolicy);
    }

    public Vector getDefaultReadOnlyClasses() {
        return this.defaultReadOnlyClasses;
    }

    public Class getDefaultIdentityMapClass() {
        return this.defaultIdentityMapClass;
    }

    public int getDefaultIdentityMapSize() {
        return this.defaultIdentityMapSize;
    }

    public boolean getDefaultIsIsolated() {
        return this.defaultIsIsolated;
    }

    public ClassDescriptor getClassDescriptor(Class theClass) {
        return this.getDescriptor(theClass);
    }

    public ClassDescriptor getDescriptor(Class theClass) {
        if (theClass == null) {
            return null;
        }
        return (ClassDescriptor)this.getDescriptors().get(theClass);
    }

    public Map getDescriptors() {
        if (this.descriptors.isEmpty() && !this.orderedDescriptors.isEmpty()) {
            for (ClassDescriptor descriptor : this.orderedDescriptors) {
                this.descriptors.put(descriptor.getJavaClass(), descriptor);
            }
        }
        return this.descriptors;
    }

    public Vector getOrderedDescriptors() {
        return this.orderedDescriptors;
    }

    public void setOrderedDescriptors(Vector orderedDescriptors) {
        this.orderedDescriptors = orderedDescriptors;
        Enumeration e = orderedDescriptors.elements();
        while (e.hasMoreElements()) {
            ClassDescriptor descriptor = (ClassDescriptor)e.nextElement();
            String alias = descriptor.getAlias();
            if (alias == null) continue;
            this.addAlias(alias, descriptor);
        }
    }

    public DatabaseLogin getLogin() {
        return (DatabaseLogin)this.datasourceLogin;
    }

    public Login getDatasourceLogin() {
        return this.datasourceLogin;
    }

    public String getName() {
        return this.name;
    }

    public SQLResultSetMapping getSQLResultSetMapping(String sqlResultSetMapping) {
        if (sqlResultSetMapping == null || this.sqlResultSetMappings == null) {
            return null;
        }
        return (SQLResultSetMapping)this.sqlResultSetMappings.get(sqlResultSetMapping);
    }

    public boolean hasGenericHistorySupport() {
        return this.hasGenericHistorySupport;
    }

    public void setDefaultReadOnlyClasses(Collection newValue) {
        this.defaultReadOnlyClasses = new Vector(newValue);
    }

    public void setDefaultIdentityMapClass(Class defaultIdentityMapClass) {
        this.defaultIdentityMapClass = defaultIdentityMapClass;
    }

    public void setDefaultIdentityMapSize(int defaultIdentityMapSize) {
        this.defaultIdentityMapSize = defaultIdentityMapSize;
    }

    public void setDefaultIsIsolated(boolean defaultIsIsolated) {
        this.defaultIsIsolated = defaultIsIsolated;
    }

    public void setDescriptors(Map descriptors) {
        this.descriptors = descriptors;
        for (ClassDescriptor descriptor : descriptors.values()) {
            String alias = descriptor.getAlias();
            if (alias == null) continue;
            this.addAlias(alias, descriptor);
        }
    }

    public void setDeferModificationsUntilCommit(int deferralLevel) {
        for (ClassDescriptor descriptor : this.descriptors.values()) {
            if (descriptor.getCMPPolicy() == null) continue;
            descriptor.getCMPPolicy().setDeferModificationsUntilCommit(deferralLevel);
        }
    }

    public void setHasGenericHistorySupport(boolean hasGenericHistorySupport) {
        this.hasGenericHistorySupport = hasGenericHistorySupport;
    }

    public boolean hasIsolatedClasses() {
        return this.hasIsolatedClasses;
    }

    public void setHasIsolatedClasses(boolean hasIsolatedClasses) {
        this.hasIsolatedClasses = hasIsolatedClasses;
    }

    public boolean hasNonIsolatedUOWClasses() {
        return this.hasNonIsolatedUOWClasses;
    }

    public void setHasNonIsolatedUOWClasses(boolean hasNonIsolatedUOWClasses) {
        this.hasNonIsolatedUOWClasses = hasNonIsolatedUOWClasses;
    }

    public boolean hasProxyIndirection() {
        return this.hasProxyIndirection;
    }

    public void setHasProxyIndirection(boolean hasProxyIndirection) {
        this.hasProxyIndirection = hasProxyIndirection;
    }

    public void setLogin(DatabaseLogin datasourceLogin) {
        this.datasourceLogin = datasourceLogin;
    }

    public void setLogin(Login datasourceLogin) {
        this.datasourceLogin = datasourceLogin;
    }

    public void setDatasourceLogin(Login datasourceLogin) {
        this.datasourceLogin = datasourceLogin;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getName() + ")";
    }

    public void useCacheIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useCacheIdentityMap();
        }
    }

    public void useCacheIdentityMap(int cacheSize) {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useCacheIdentityMap();
            descriptor.setIdentityMapSize(cacheSize);
        }
    }

    public void useFullIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useFullIdentityMap();
        }
    }

    public void useFullIdentityMap(int initialCacheSize) {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useFullIdentityMap();
            descriptor.setIdentityMapSize(initialCacheSize);
        }
    }

    public void useNoIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useNoIdentityMap();
        }
    }

    public void useSoftCacheWeakIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useSoftCacheWeakIdentityMap();
        }
    }

    public void useSoftCacheWeakIdentityMap(int cacheSize) {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useSoftCacheWeakIdentityMap();
            descriptor.setIdentityMapSize(cacheSize);
        }
    }

    public boolean usesOptimisticLocking() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            if (!descriptor.usesOptimisticLocking()) continue;
            return true;
        }
        return false;
    }

    public boolean usesSequencing() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            if (!descriptor.usesSequenceNumbers()) continue;
            return true;
        }
        return false;
    }

    public void useWeakIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useWeakIdentityMap();
        }
    }

    public void useWeakIdentityMap(int initialCacheSize) {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useWeakIdentityMap();
            descriptor.setIdentityMapSize(initialCacheSize);
        }
    }

    public void applyLogin() {
    }

    public Map getAliasDescriptors() {
        return this.aliasDescriptors;
    }

    public void addAlias(String alias, ClassDescriptor descriptor) {
        if (this.aliasDescriptors == null) {
            this.aliasDescriptors = new HashMap(10);
        }
        this.aliasDescriptors.put(alias, descriptor);
    }

    public ClassDescriptor getDescriptorForAlias(String alias) {
        ClassDescriptor descriptor = null;
        if (this.aliasDescriptors != null) {
            descriptor = (ClassDescriptor)this.aliasDescriptors.get(alias);
        }
        return descriptor;
    }

    public void setAliasDescriptors(Map aHashtable) {
        this.aliasDescriptors = aHashtable;
    }

    public boolean hasMappingsPostCalculateChangesOnDeleted() {
        return this.hasMappingsPostCalculateChangesOnDeleted;
    }

    public void setHasMappingsPostCalculateChangesOnDeleted(boolean hasMappingsPostCalculateChangesOnDeleted) {
        this.hasMappingsPostCalculateChangesOnDeleted = hasMappingsPostCalculateChangesOnDeleted;
    }

    public boolean hasMappedSuperclasses() {
        return null != this.mappedSuperclassDescriptors && !this.mappedSuperclassDescriptors.isEmpty();
    }

    public void addMappedSuperclass(Object key, RelationalDescriptor value) {
        if (null == this.mappedSuperclassDescriptors) {
            this.mappedSuperclassDescriptors = new HashMap<Object, RelationalDescriptor>(2);
        }
        if (!this.mappedSuperclassDescriptors.containsKey(key)) {
            this.mappedSuperclassDescriptors.put(key, value);
        }
    }

    public RelationalDescriptor getMappedSuperclass(Object key) {
        if (null == this.mappedSuperclassDescriptors) {
            this.mappedSuperclassDescriptors = new HashMap<Object, RelationalDescriptor>(2);
            return null;
        }
        return this.mappedSuperclassDescriptors.get(key);
    }

    public Map<Object, RelationalDescriptor> getMappedSuperclassDescriptors() {
        if (null == this.mappedSuperclassDescriptors) {
            this.mappedSuperclassDescriptors = new HashMap<Object, RelationalDescriptor>(2);
        }
        return this.mappedSuperclassDescriptors;
    }

    public void addMetamodelIdClassMapEntry(String ownerName, String name) {
        if (this.metamodelIdClassMap.containsKey(ownerName)) {
            this.metamodelIdClassMap.get(ownerName).add(name);
        } else {
            ArrayList<String> ownerList = new ArrayList<String>();
            ownerList.add(name);
            this.metamodelIdClassMap.put(ownerName, ownerList);
        }
    }

    public Map<String, List<String>> getMetamodelIdClassMap() {
        return this.metamodelIdClassMap;
    }
}

