/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

public abstract class JsonValue {
    public static final JsonValue NULL = new JsonPrimitive("null");
    public static final JsonValue TRUE = new JsonPrimitive("true");
    public static final JsonValue FALSE = new JsonPrimitive("false");

    public static JsonValue valueOf(int value) {
        return new JsonPrimitive(String.valueOf(value));
    }

    public static JsonValue valueOf(float value) {
        return new JsonPrimitive(String.valueOf(value));
    }

    public static JsonValue valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static JsonValue valueOf(String value) {
        JsonValue result = value == null ? NULL : new JsonPrimitive(JsonValue.quoteString(value));
        return result;
    }

    public static String quoteString(String string) {
        StringBuffer resultBuffer = new StringBuffer();
        resultBuffer.append('\"');
        int length = string.length();
        int i = 0;
        while (i < length) {
            char ch = string.charAt(i);
            if (ch == '\"' || ch == '\\') {
                resultBuffer.append('\\');
            }
            resultBuffer.append(ch);
            ++i;
        }
        resultBuffer.append('\"');
        return resultBuffer.toString();
    }

    private static class JsonPrimitive
    extends JsonValue {
        private final String value;

        JsonPrimitive(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

