/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public final class EventUtil {
    private EventUtil() {
    }

    public static boolean isAccessible(Widget widget) {
        boolean result;
        boolean bl = result = !widget.isDisposed();
        if (result) {
            if (widget instanceof Control) {
                result = EventUtil.isAccessible((Control)widget);
            } else if (widget instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)widget;
                result = EventUtil.isAccessible(menuItem);
            } else if (widget instanceof ToolItem) {
                ToolItem toolItem = (ToolItem)widget;
                result = EventUtil.isAccessible(toolItem);
            } else if (widget instanceof Menu) {
                Menu menu = (Menu)widget;
                result = EventUtil.isAccessible(menu);
            }
        }
        return result;
    }

    private static boolean isAccessible(Control control) {
        return control.getEnabled() && control.getVisible() && EventUtil.isShellAccessible(control.getShell());
    }

    private static boolean isAccessible(Menu menu) {
        return menu.getEnabled() && EventUtil.isShellAccessible(menu.getShell());
    }

    private static boolean isAccessible(MenuItem menuItem) {
        Shell shell = menuItem.getParent().getShell();
        return menuItem.getEnabled() && EventUtil.isShellAccessible(shell);
    }

    private static boolean isAccessible(ToolItem toolItem) {
        Shell shell = toolItem.getParent().getShell();
        return toolItem.getEnabled() && EventUtil.isShellAccessible(shell);
    }

    private static boolean isShellAccessible(Shell shell) {
        Shell modalShell = null;
        Shell activeShell = shell.getDisplay().getActiveShell();
        if (activeShell != null && activeShell.isVisible() && (activeShell.getStyle() & 0x10000) != 0) {
            modalShell = activeShell;
        }
        return modalShell == null || shell == modalShell;
    }
}

