/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.internal.widgets.controldecoratorkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSListenerInfo;
import org.eclipse.rwt.lifecycle.JSListenerType;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ControlDecorator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ControlDecoratorLCA
extends AbstractWidgetLCA {
    private static final String PROP_IMAGE = "image";
    private static final String PROP_VISIBLE = "visible";
    static final String PROP_TEXT = "text";
    static final String PROP_SHOW_HOVER = "showHover";
    static final String PROP_SELECTION_LISTENERS = "selectionListeners";
    private static final JSListenerInfo SELECTION_LISTENER = new JSListenerInfo("mousedown", "this.onWidgetSelected", JSListenerType.ACTION);
    private static final JSListenerInfo DEFAULT_SELECTION_LISTENER = new JSListenerInfo("dblclick", "this.onWidgetDefaultSelected", JSListenerType.ACTION);

    public void preserveValues(Widget widget) {
        ControlDecorator decorator = (ControlDecorator)widget;
        WidgetLCAUtil.preserveBounds((Widget)decorator, decorator.getBounds());
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)decorator);
        adapter.preserve(PROP_IMAGE, (Object)decorator.getImage());
        adapter.preserve(PROP_TEXT, (Object)decorator.getText());
        Boolean showHover = decorator.getShowHover();
        adapter.preserve(PROP_SHOW_HOVER, (Object)showHover);
        adapter.preserve(PROP_VISIBLE, (Object)decorator.isVisible());
        Boolean hasListener = SelectionEvent.hasListener((Adaptable)decorator);
        adapter.preserve(PROP_SELECTION_LISTENERS, (Object)hasListener);
    }

    public void readData(Widget widget) {
        ControlDecoratorLCA.readSelectionEvent((ControlDecorator)widget);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ControlDecorator decorator = (ControlDecorator)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)decorator);
        Object[] args = new Object[]{decorator.getParent()};
        writer.newWidget("org.eclipse.rwt.widgets.ControlDecorator", args);
    }

    public void renderChanges(Widget widget) throws IOException {
        ControlDecorator decorator = (ControlDecorator)widget;
        WidgetLCAUtil.writeBounds((Widget)decorator, (Control)decorator.getParent(), decorator.getBounds());
        WidgetLCAUtil.writeImage((Widget)decorator, PROP_IMAGE, "source", decorator.getImage());
        ControlDecoratorLCA.writeText(decorator);
        ControlDecoratorLCA.writeShowHover(decorator);
        ControlDecoratorLCA.writeVisible(decorator);
        ControlDecoratorLCA.writeSelectionListener(decorator);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private static void writeText(ControlDecorator decorator) throws IOException {
        String newValue = decorator.getText();
        JSWriter writer = JSWriter.getWriterFor((Widget)decorator);
        writer.set(PROP_TEXT, PROP_TEXT, newValue, "");
    }

    private static void writeShowHover(ControlDecorator decorator) throws IOException {
        Boolean newValue = decorator.getShowHover();
        JSWriter writer = JSWriter.getWriterFor((Widget)decorator);
        writer.set(PROP_SHOW_HOVER, PROP_SHOW_HOVER, newValue, Boolean.TRUE);
    }

    private static void writeVisible(ControlDecorator decorator) throws IOException {
        Boolean newValue = decorator.isVisible();
        Boolean defValue = Boolean.TRUE;
        JSWriter writer = JSWriter.getWriterFor((Widget)decorator);
        writer.set(PROP_VISIBLE, "visibility", newValue, defValue);
    }

    private static void writeSelectionListener(ControlDecorator decorator) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)decorator);
        writer.updateListener(SELECTION_LISTENER, PROP_SELECTION_LISTENERS, SelectionEvent.hasListener((Adaptable)decorator));
        writer.updateListener(DEFAULT_SELECTION_LISTENER, PROP_SELECTION_LISTENERS, SelectionEvent.hasListener((Adaptable)decorator));
    }

    private static void readSelectionEvent(ControlDecorator decorator) {
        String eventName = "org.eclipse.swt.events.widgetSelected";
        int eventId = 13;
        if (WidgetLCAUtil.wasEventSent((Widget)decorator, eventName)) {
            ControlDecoratorLCA.processSelectionEvent(decorator, eventId);
        }
        eventName = "org.eclipse.swt.events.widgetDefaultSelected";
        eventId = 14;
        if (WidgetLCAUtil.wasEventSent((Widget)decorator, eventName)) {
            ControlDecoratorLCA.processSelectionEvent(decorator, eventId);
        }
    }

    private static void processSelectionEvent(ControlDecorator decorator, int id) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
        SelectionEvent event = new SelectionEvent((Widget)decorator, null, id, bounds, stateMask, "", true, 0);
        event.processEvent();
    }
}

