/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.listkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.IListAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Widget;

public class ListLCA
extends AbstractWidgetLCA {
    private static final String QX_TYPE = "org.eclipse.swt.widgets.List";
    static final String PROP_SELECTION = "selection";
    static final String PROP_ITEMS = "items";
    static final String PROP_FOCUS_INDEX = "focusIndex";
    static final String PROP_TOP_INDEX = "topIndex";
    static final String PROP_HAS_H_SCROLL_BAR = "hasHScrollBar";
    static final String PROP_HAS_V_SCROLL_BAR = "hasVScrollBar";
    static final String PROP_ITEM_DIMENSIONS = "itemDimensions";
    private static final Integer DEFAULT_SINGLE_SELECTION = new Integer(-1);
    private static final int[] DEFAULT_MULTI_SELECTION = new int[0];
    private static final String[] DEFAUT_ITEMS = new String[0];
    private static final Integer DEFAULT_FOCUS_INDEX = new Integer(-1);
    private static final Integer DEFAULT_TOP_INDEX = new Integer(0);
    private static final Point DEFAULT_ITEM_DIMENSIONS = new Point(0, 0);
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        List list = (List)widget;
        ControlLCAUtil.preserveValues((Control)list);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve("selectionListeners", (Object)SelectionEvent.hasListener((Adaptable)list));
        adapter.preserve(PROP_ITEMS, (Object)list.getItems());
        adapter.preserve(PROP_TOP_INDEX, (Object)new Integer(list.getTopIndex()));
        adapter.preserve(PROP_FOCUS_INDEX, (Object)new Integer(list.getFocusIndex()));
        adapter.preserve(PROP_HAS_H_SCROLL_BAR, (Object)ListLCA.hasHScrollBar(list));
        adapter.preserve(PROP_HAS_V_SCROLL_BAR, (Object)ListLCA.hasVScrollBar(list));
        ListLCA.preserveSelection(list);
        adapter.preserve(PROP_ITEM_DIMENSIONS, (Object)ListLCA.getItemDimensions(list));
        WidgetLCAUtil.preserveCustomVariant((Widget)list);
    }

    public void readData(Widget widget) {
        List list = (List)widget;
        ListLCA.readTopIndex(list);
        ListLCA.readSelection(list);
        ListLCA.readFocusIndex(list);
        ControlLCAUtil.processSelection((Widget)list, null, true);
        ControlLCAUtil.processMouseEvents((Control)list);
        ControlLCAUtil.processKeyEvents((Control)list);
        ControlLCAUtil.processMenuDetect((Control)list);
        WidgetLCAUtil.processHelp((Widget)list);
    }

    public void renderInitialization(Widget widget) throws IOException {
        List list = (List)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)list);
        Boolean multiSelection = !ListLCA.isSingle(list);
        writer.newWidget(QX_TYPE, new Object[]{multiSelection});
        ControlLCAUtil.writeStyleFlags((Control)list);
    }

    public void renderChanges(Widget widget) throws IOException {
        List list = (List)widget;
        ControlLCAUtil.writeChanges((Control)list);
        ListLCA.writeItems(list);
        ListLCA.writeSelection(list);
        ListLCA.writeTopIndex(list);
        ListLCA.writeFocusIndex(list);
        ListLCA.writeScrollBars(list);
        ListLCA.updateSelectionListeners(list);
        ListLCA.writeItemDimensions(list);
        WidgetLCAUtil.writeCustomVariant((Widget)list);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private static void preserveSelection(List list) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)list);
        Object selection = ListLCA.isSingle(list) ? (Object)new Integer(list.getSelectionIndex()) : list.getSelectionIndices();
        adapter.preserve(PROP_SELECTION, selection);
    }

    private static void writeItems(List list) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)list);
        String[] items = list.getItems();
        if (WidgetLCAUtil.hasChanged((Widget)list, PROP_ITEMS, items, DEFAUT_ITEMS)) {
            int i = 0;
            while (i < items.length) {
                items[i] = WidgetLCAUtil.replaceNewLines(items[i], " ");
                items[i] = WidgetLCAUtil.escapeText(items[i], false);
                ++i;
            }
            writer.set(PROP_ITEMS, new Object[]{items});
        }
    }

    private static void writeSelection(List list) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)list);
        String prop = PROP_SELECTION;
        if (ListLCA.isSingle(list)) {
            Integer defValue;
            Integer newValue = new Integer(list.getSelectionIndex());
            if (WidgetLCAUtil.hasChanged((Widget)list, prop, newValue, defValue = DEFAULT_SINGLE_SELECTION)) {
                writer.call("selectItem", new Object[]{newValue});
            }
        } else {
            int[] defValue;
            int[] newValue = list.getSelectionIndices();
            if (WidgetLCAUtil.hasChanged((Widget)list, prop, newValue, defValue = DEFAULT_MULTI_SELECTION)) {
                if (list.getSelectionCount() == list.getItemCount()) {
                    writer.call("selectAll", null);
                } else {
                    int[] selection = list.getSelectionIndices();
                    Integer[] newSelection = new Integer[selection.length];
                    int i = 0;
                    while (i < newSelection.length) {
                        newSelection[i] = new Integer(selection[i]);
                        ++i;
                    }
                    writer.call("selectItems", new Object[]{newSelection});
                }
            }
        }
    }

    private static void writeFocusIndex(List list) throws IOException {
        String prop = PROP_FOCUS_INDEX;
        Integer newValue = new Integer(list.getFocusIndex());
        if (WidgetLCAUtil.hasChanged((Widget)list, prop, newValue, DEFAULT_FOCUS_INDEX)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)list);
            writer.call("focusItem", new Object[]{newValue});
        }
    }

    private static void writeTopIndex(List list) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)list);
        Integer newValue = new Integer(list.getTopIndex());
        writer.set(PROP_TOP_INDEX, PROP_TOP_INDEX, newValue, DEFAULT_TOP_INDEX);
    }

    private static void writeScrollBars(List list) throws IOException {
        boolean hasHBar = ListLCA.hasHScrollBar(list);
        boolean hasVBar = ListLCA.hasVScrollBar(list);
        boolean hasHChanged = WidgetLCAUtil.hasChanged((Widget)list, PROP_HAS_H_SCROLL_BAR, hasHBar, Boolean.TRUE);
        boolean hasVChanged = WidgetLCAUtil.hasChanged((Widget)list, PROP_HAS_V_SCROLL_BAR, hasVBar, Boolean.TRUE);
        if (hasHChanged || hasVChanged) {
            JSWriter writer = JSWriter.getWriterFor((Widget)list);
            writer.set("scrollBarsVisible", new boolean[]{hasHBar, hasVBar});
        }
    }

    private static void updateSelectionListeners(List list) throws IOException {
        Boolean defValue;
        String prop = "selectionListeners";
        Boolean newValue = SelectionEvent.hasListener((Adaptable)list);
        if (WidgetLCAUtil.hasChanged((Widget)list, prop, newValue, defValue = Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)list);
            String value = newValue != false ? "action" : "state";
            writer.set("changeSelectionNotification", value);
        }
    }

    private static void writeItemDimensions(List list) throws IOException {
        Point defValue;
        String prop = PROP_ITEM_DIMENSIONS;
        Point newValue = ListLCA.getItemDimensions(list);
        if (WidgetLCAUtil.hasChanged((Widget)list, prop, newValue, defValue = DEFAULT_ITEM_DIMENSIONS)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)list);
            Object[] args = new Object[]{new Integer(newValue.x), new Integer(newValue.y)};
            writer.call("setItemDimensions", args);
        }
    }

    private static void readSelection(List list) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)list, PROP_SELECTION);
        if (value != null) {
            String[] indiceStrings = "".equals(value) ? new String[]{} : value.split(",");
            int[] indices = new int[indiceStrings.length];
            int i = 0;
            while (i < indices.length) {
                indices[i] = NumberFormatUtil.parseInt((String)indiceStrings[i]);
                ++i;
            }
            list.setSelection(indices);
        }
    }

    private static void readTopIndex(List list) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)list, PROP_TOP_INDEX);
        if (value != null) {
            list.setTopIndex(NumberFormatUtil.parseInt((String)value));
        }
    }

    private static void readFocusIndex(List list) {
        String paramValue = WidgetLCAUtil.readPropertyValue((Widget)list, PROP_FOCUS_INDEX);
        if (paramValue != null) {
            int focusIndex = NumberFormatUtil.parseInt((String)paramValue);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IListAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = list.getAdapter((Class)clazz);
            IListAdapter listAdapter = (IListAdapter)adapter;
            listAdapter.setFocusIndex(focusIndex);
        }
    }

    private static boolean isSingle(List list) {
        return (list.getStyle() & 4) != 0;
    }

    private static Boolean hasHScrollBar(List list) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IListAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = list.getAdapter((Class)clazz);
        IListAdapter listAdapter = (IListAdapter)adapter;
        return listAdapter.hasHScrollBar();
    }

    private static Boolean hasVScrollBar(List list) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IListAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = list.getAdapter((Class)clazz);
        IListAdapter listAdapter = (IListAdapter)adapter;
        return listAdapter.hasVScrollBar();
    }

    private static Point getItemDimensions(List list) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IListAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = list.getAdapter((Class)clazz);
        IListAdapter listAdapter = (IListAdapter)adapter;
        return listAdapter.getItemDimensions();
    }
}

