/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.rap.rwt.client.Client;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServletLog;
import org.eclipse.rap.rwt.internal.util.ClassUtil;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.rap.rwt.service.ServiceManager;
import org.eclipse.rap.rwt.service.SettingStore;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

public final class RWT {
    public static final String ACTIVE_KEYS = "org.eclipse.rap.rwt.activeKeys";
    public static final String CANCEL_KEYS = "org.eclipse.rap.rwt.cancelKeys";
    public static final String MNEMONIC_ACTIVATOR = "org.eclipse.rap.rwt.mnemonicActivator";
    public static final String CUSTOM_ITEM_HEIGHT = "org.eclipse.rap.rwt.customItemHeight";
    public static final String PRELOADED_ITEMS = "org.eclipse.rap.rwt.preloadedItems";
    public static final String MARKUP_ENABLED = "org.eclipse.rap.rwt.markupEnabled";
    public static final String TOOLTIP_MARKUP_ENABLED = "org.eclipse.rap.rwt.tooltipMarkupEnabled";
    public static final String FIXED_COLUMNS = "org.eclipse.rap.rwt.fixedColumns";
    public static final String BADGE = "org.eclipse.rap.rwt.badge";
    public static final String DEFAULT_THEME_ID = "org.eclipse.rap.rwt.theme.Default";
    public static final String CUSTOM_VARIANT = "org.eclipse.rap.rwt.customVariant";
    public static final String ROW_TEMPLATE = "org.eclipse.rap.rwt.rowTemplate";
    public static final int HYPERLINK = 0x4000000;
    public static final int CELL = 0x8000000;

    public static ResourceManager getResourceManager() {
        return RWT.getApplicationContext().getResourceManager();
    }

    public static ServiceManager getServiceManager() {
        return RWT.getApplicationContext().getServiceManager();
    }

    public static SettingStore getSettingStore() {
        return ContextProvider.getApplicationContext().getSettingStoreManager().getStore();
    }

    public static UISession getUISession() {
        RWT.checkContext();
        return ContextProvider.getUISession();
    }

    public static UISession getUISession(Display display) {
        ParamCheck.notNull(display, "display");
        return display.getAdapter(IDisplayAdapter.class).getUISession();
    }

    public static ApplicationContext getApplicationContext() {
        RWT.checkContext();
        return ContextProvider.getApplicationContext();
    }

    public static HttpServletRequest getRequest() {
        RWT.checkContext();
        return ContextProvider.getRequest();
    }

    public static HttpServletResponse getResponse() {
        RWT.checkContext();
        return ContextProvider.getResponse();
    }

    public static Locale getLocale() {
        return RWT.getUISession().getLocale();
    }

    public static void setLocale(Locale locale) {
        RWT.getUISession().setLocale(locale);
    }

    public static void requestThreadExec(Runnable runnable) {
        ParamCheck.notNull(runnable, "runnable");
        RWT.checkContext();
        RWT.checkPhase();
        Display display = LifeCycleUtil.getSessionDisplay();
        if (display == null || display.isDisposed()) {
            SWT.error(45);
        }
        LifeCycle lifeCycle = ContextProvider.getApplicationContext().getLifeCycleFactory().getLifeCycle();
        lifeCycle.requestThreadExec(runnable);
    }

    public static Client getClient() {
        return RWT.getUISession().getClient();
    }

    private static void checkContext() {
        if (!ContextProvider.hasContext()) {
            throw new IllegalStateException("Invalid thread access");
        }
    }

    private static void checkPhase() {
        if (CurrentPhase.get() == null) {
            throw new IllegalStateException("Invalid thread access");
        }
    }

    private RWT() {
    }

    public static final class NLS {
        private static final Map<ResourceBundle, Object> map = new HashMap<ResourceBundle, Object>();

        @Deprecated
        public static <T> T getISO8859_1Encoded(String bundleName, Class<T> clazz) {
            return NLS.get(bundleName, clazz);
        }

        @Deprecated
        public static <T> T getUTF8Encoded(String bundleName, Class<T> clazz) {
            return NLS.get(bundleName, clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T> T get(String bundleName, Class<T> clazz) {
            Object result;
            ClassLoader loader = clazz.getClassLoader();
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, RWT.getLocale(), loader);
            Map<ResourceBundle, Object> map = NLS.map;
            synchronized (map) {
                result = NLS.map.get(bundle);
                if (result == null) {
                    result = ClassUtil.newInstance(clazz);
                    Field[] fields = clazz.getDeclaredFields();
                    int i = 0;
                    while (i < fields.length) {
                        block10: {
                            String fieldName = fields[i].getName();
                            try {
                                if (!String.class.isAssignableFrom(fields[i].getType()) || !Modifier.isPublic(fields[i].getModifiers()) || Modifier.isStatic(fields[i].getModifiers())) break block10;
                                try {
                                    String value = bundle.getString(fieldName);
                                    if (value != null) {
                                        fields[i].setAccessible(true);
                                        fields[i].set(result, value);
                                    }
                                }
                                catch (MissingResourceException mre) {
                                    fields[i].setAccessible(true);
                                    fields[i].set(result, "");
                                    throw mre;
                                }
                            }
                            catch (Exception ex) {
                                String qualifiedName = String.valueOf(clazz.getName()) + "#" + fieldName;
                                ServletLog.log("Failed to load localized message for: " + qualifiedName, ex);
                            }
                        }
                        ++i;
                    }
                    NLS.map.put(bundle, result);
                }
            }
            return (T)result;
        }
    }
}

