/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.BendpointCreationHandle;
import org.eclipse.gef.handles.BendpointHandle;
import org.eclipse.gef.handles.BendpointMoveHandle;
import org.eclipse.gef.requests.BendpointRequest;

public abstract class BendpointEditPolicy
extends SelectionHandlesEditPolicy
implements PropertyChangeListener {
    private static final List NULL_CONSTRAINT = new ArrayList();
    private List originalConstraint;
    private boolean isDeleting = false;
    private static final Point ref1 = new Point();
    private static final Point ref2 = new Point();

    public void activate() {
        super.activate();
        this.getConnection().addPropertyChangeListener("points", (PropertyChangeListener)this);
    }

    private List createHandlesForAutomaticBendpoints() {
        ArrayList<BendpointCreationHandle> list = new ArrayList<BendpointCreationHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        int i = 0;
        while (i < points.size() - 1) {
            list.add(new BendpointCreationHandle(connEP, 0, i));
            ++i;
        }
        return list;
    }

    private List createHandlesForUserBendpoints() {
        ArrayList<BendpointHandle> list = new ArrayList<BendpointHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        List bendPoints = (List)this.getConnection().getRoutingConstraint();
        int bendPointIndex = 0;
        Point currBendPoint = null;
        if (bendPoints == null) {
            bendPoints = NULL_CONSTRAINT;
        } else if (!bendPoints.isEmpty()) {
            currBendPoint = ((Bendpoint)bendPoints.get(0)).getLocation();
        }
        int i = 0;
        while (i < points.size() - 1) {
            list.add(new BendpointCreationHandle(connEP, bendPointIndex, i));
            if (i < points.size() - 1 && bendPointIndex < bendPoints.size() && currBendPoint.equals((Object)points.getPoint(i + 1))) {
                list.add(new BendpointMoveHandle(connEP, bendPointIndex, i + 1));
                if (++bendPointIndex < bendPoints.size()) {
                    currBendPoint = ((Bendpoint)bendPoints.get(bendPointIndex)).getLocation();
                }
            }
            ++i;
        }
        return list;
    }

    protected List createSelectionHandles() {
        List list = new ArrayList();
        list = this.isAutomaticallyBending() ? this.createHandlesForAutomaticBendpoints() : this.createHandlesForUserBendpoints();
        return list;
    }

    public void deactivate() {
        this.getConnection().removePropertyChangeListener("points", (PropertyChangeListener)this);
        super.deactivate();
    }

    protected void eraseConnectionFeedback(BendpointRequest request) {
        this.restoreOriginalConstraint();
        this.originalConstraint = null;
    }

    public void eraseSourceFeedback(Request request) {
        if ("move bendpoint".equals(request.getType()) || "create bendpoint".equals(request.getType())) {
            this.eraseConnectionFeedback((BendpointRequest)request);
        }
    }

    public Command getCommand(Request request) {
        if ("move bendpoint".equals(request.getType())) {
            if (this.isDeleting) {
                return this.getDeleteBendpointCommand((BendpointRequest)request);
            }
            return this.getMoveBendpointCommand((BendpointRequest)request);
        }
        if ("create bendpoint".equals(request.getType())) {
            return this.getCreateBendpointCommand((BendpointRequest)request);
        }
        return null;
    }

    protected Connection getConnection() {
        return (Connection)((ConnectionEditPart)this.getHost()).getFigure();
    }

    protected abstract Command getCreateBendpointCommand(BendpointRequest var1);

    protected abstract Command getDeleteBendpointCommand(BendpointRequest var1);

    protected abstract Command getMoveBendpointCommand(BendpointRequest var1);

    private boolean isAutomaticallyBending() {
        List constraint = (List)this.getConnection().getRoutingConstraint();
        PointList points = this.getConnection().getPoints();
        return points.size() > 2 && (constraint == null || constraint.isEmpty());
    }

    private boolean lineContainsPoint(Point p1, Point p2, Point p) {
        int tolerance = 7;
        Rectangle rect = Rectangle.getSINGLETON();
        rect.setSize(0, 0);
        rect.setLocation(p1.x, p1.y);
        rect.union(p2.x, p2.y);
        rect.expand(tolerance, tolerance);
        if (!rect.contains(p.x, p.y)) {
            return false;
        }
        double result = 0.0;
        if (p1.x != p2.x && p1.y != p2.y) {
            int v1x = p2.x - p1.x;
            int v1y = p2.y - p1.y;
            int v2x = p.x - p1.x;
            int v2y = p.y - p1.y;
            int numerator = v2x * v1y - v1x * v2y;
            int denominator = v1x * v1x + v1y * v1y;
            result = (numerator << 10) / denominator * numerator >> 10;
        }
        return result <= (double)(tolerance * tolerance);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getHost().getSelected() != 0) {
            this.addSelectionHandles();
        }
    }

    protected void restoreOriginalConstraint() {
        if (this.originalConstraint != null) {
            if (this.originalConstraint == NULL_CONSTRAINT) {
                this.getConnection().setRoutingConstraint(null);
            } else {
                this.getConnection().setRoutingConstraint((Object)this.originalConstraint);
            }
        }
    }

    protected void saveOriginalConstraint() {
        this.originalConstraint = (List)this.getConnection().getRoutingConstraint();
        if (this.originalConstraint == null) {
            this.originalConstraint = NULL_CONSTRAINT;
        }
        this.getConnection().setRoutingConstraint(new ArrayList(this.originalConstraint));
    }

    private void setReferencePoints(BendpointRequest request) {
        PointList points = this.getConnection().getPoints();
        int bpIndex = -1;
        List bendPoints = (List)this.getConnection().getRoutingConstraint();
        Point bp = ((Bendpoint)bendPoints.get(request.getIndex())).getLocation();
        int smallestDistance = -1;
        int i = 1;
        while (i < points.size() - 1) {
            if (smallestDistance == -1 || points.getPoint(i).getDistance2(bp) < smallestDistance) {
                bpIndex = i;
                smallestDistance = points.getPoint(i).getDistance2(bp);
                if (smallestDistance == 0) break;
            }
            ++i;
        }
        points.getPoint(ref1, bpIndex - 1);
        this.getConnection().translateToAbsolute((Translatable)ref1);
        points.getPoint(ref2, bpIndex + 1);
        this.getConnection().translateToAbsolute((Translatable)ref2);
    }

    protected void showCreateBendpointFeedback(BendpointRequest request) {
        List constraint;
        Point p = new Point(request.getLocation());
        this.getConnection().translateToRelative((Translatable)p);
        AbsoluteBendpoint bp = new AbsoluteBendpoint(p);
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
            constraint = (List)this.getConnection().getRoutingConstraint();
            constraint.add(request.getIndex(), bp);
        } else {
            constraint = (List)this.getConnection().getRoutingConstraint();
        }
        constraint.set(request.getIndex(), bp);
        this.getConnection().setRoutingConstraint((Object)constraint);
    }

    protected void showDeleteBendpointFeedback(BendpointRequest request) {
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
            List constraint = (List)this.getConnection().getRoutingConstraint();
            constraint.remove(request.getIndex());
            this.getConnection().setRoutingConstraint((Object)constraint);
        }
    }

    protected void showMoveBendpointFeedback(BendpointRequest request) {
        Point p = new Point(request.getLocation());
        if (!this.isDeleting) {
            this.setReferencePoints(request);
        }
        if (this.lineContainsPoint(ref1, ref2, p)) {
            if (!this.isDeleting) {
                this.isDeleting = true;
                this.eraseSourceFeedback(request);
                this.showDeleteBendpointFeedback(request);
            }
            return;
        }
        if (this.isDeleting) {
            this.isDeleting = false;
            this.eraseSourceFeedback(request);
        }
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
        }
        List constraint = (List)this.getConnection().getRoutingConstraint();
        this.getConnection().translateToRelative((Translatable)p);
        AbsoluteBendpoint bp = new AbsoluteBendpoint(p);
        constraint.set(request.getIndex(), bp);
        this.getConnection().setRoutingConstraint((Object)constraint);
    }

    public void showSourceFeedback(Request request) {
        if ("move bendpoint".equals(request.getType())) {
            this.showMoveBendpointFeedback((BendpointRequest)request);
        } else if ("create bendpoint".equals(request.getType())) {
            this.showCreateBendpointFeedback((BendpointRequest)request);
        }
    }
}

