/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScrollPaneSolver;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Slider;

public class FigureCanvas
extends Composite {
    private static final int ACCEPTED_STYLES = 638847744;
    static final int DEFAULT_STYLES = 1311488;
    private static final int REQUIRED_STYLES = 0x100300;
    public static int NEVER = 0;
    public static int AUTOMATIC = 1;
    public static int ALWAYS = 2;
    protected Slider horizontalBar;
    protected Slider verticalBar;
    protected Canvas innerCanvas;
    private int vBarVisibility = AUTOMATIC;
    private int hBarVisibility = AUTOMATIC;
    private Viewport viewport;
    private Font font;
    private int hBarOffset;
    private int vBarOffset;
    private PropertyChangeListener horizontalChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            RangeModel model = FigureCanvas.this.getViewport().getHorizontalRangeModel();
            FigureCanvas.this.hBarOffset = Math.max(0, -model.getMinimum());
            Slider horizontalBar = FigureCanvas.this.getHorizontalSlider();
            if (horizontalBar != null) {
                horizontalBar.setValues(model.getValue() + FigureCanvas.this.hBarOffset, model.getMinimum() + FigureCanvas.this.hBarOffset, model.getMaximum() + FigureCanvas.this.hBarOffset, model.getExtent(), Math.max(1, model.getExtent() / 20), Math.max(1, model.getExtent() * 3 / 4));
            }
        }
    };
    private PropertyChangeListener verticalChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            RangeModel model = FigureCanvas.this.getViewport().getVerticalRangeModel();
            FigureCanvas.this.vBarOffset = Math.max(0, -model.getMinimum());
            Slider verticalBar = FigureCanvas.this.getVerticalSlider();
            if (verticalBar != null) {
                verticalBar.setValues(model.getValue() + FigureCanvas.this.vBarOffset, model.getMinimum() + FigureCanvas.this.vBarOffset, model.getMaximum() + FigureCanvas.this.vBarOffset, model.getExtent(), Math.max(1, model.getExtent() / 20), Math.max(1, model.getExtent() * 3 / 4));
            }
        }
    };
    private final LightweightSystem lws;

    public FigureCanvas(Composite parent) {
        this(parent, 0x20000000, new LightweightSystem());
    }

    public FigureCanvas(Composite parent, int style) {
        this(parent, style, new LightweightSystem());
    }

    public FigureCanvas(int style, Composite parent) {
        this(style, parent, new LightweightSystem());
    }

    public FigureCanvas(Composite parent, LightweightSystem lws) {
        this(parent, 0x20000000, lws);
    }

    public FigureCanvas(int style, Composite parent, LightweightSystem lws) {
        super(parent, FigureCanvas.checkStyle(style));
        Slider verticalBar;
        this.setLayout(new Layout(){

            protected org.eclipse.swt.graphics.Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return FigureCanvas.this.innerCanvas.computeSize(wHint, hHint, flushCache);
            }

            protected void layout(Composite composite, boolean flushCache) {
                if (!TextSizeUtil.isTemporaryResize()) {
                    org.eclipse.swt.graphics.Point size = composite.getSize();
                    int vScrollBarWidth = FigureCanvas.this.getVScrollBarWidth();
                    int hScrollBarHeight = FigureCanvas.this.getHScrollBarHeight();
                    if (!FigureCanvas.this.getHorizontalSlider().isVisible()) {
                        hScrollBarHeight = 0;
                    }
                    if (!FigureCanvas.this.getVerticalSlider().isVisible()) {
                        vScrollBarWidth = 0;
                    }
                    FigureCanvas.this.getHorizontalSlider().setBounds(0, size.y - hScrollBarHeight, size.x - vScrollBarWidth, hScrollBarHeight);
                    FigureCanvas.this.getVerticalSlider().setBounds(size.x - vScrollBarWidth, 0, vScrollBarWidth, size.y - hScrollBarHeight);
                    FigureCanvas.this.innerCanvas.setLocation(0, 0);
                    FigureCanvas.this.innerCanvas.setSize(size.x - vScrollBarWidth, size.y - hScrollBarHeight);
                }
            }
        });
        Slider horizontalBar = this.getHorizontalSlider();
        if (horizontalBar != null) {
            horizontalBar.setVisible(false);
        }
        if ((verticalBar = this.getVerticalSlider()) != null) {
            verticalBar.setVisible(false);
        }
        this.lws = lws;
        lws.setControl(this.getInnerCanvas());
        this.hook();
    }

    public org.eclipse.swt.graphics.Rectangle getClientArea() {
        return this.innerCanvas.getClientArea();
    }

    private Canvas getInnerCanvas() {
        if (this.innerCanvas == null) {
            this.innerCanvas = new Canvas((Composite)this, this.getStyle());
            this.setData(Canvas.class.getName(), this.innerCanvas);
        }
        return this.innerCanvas;
    }

    public FigureCanvas(Composite parent, int style, LightweightSystem lws) {
        this(style | 0x140300, parent, lws);
    }

    private static int checkStyle(int style) {
        if ((style & 0x100300) != 0x100300) {
            throw new IllegalArgumentException("Required style missing on FigureCanvas");
        }
        if ((style & 0xD9EBF4FF) != 0) {
            throw new IllegalArgumentException("Invalid style being set on FigureCanvas");
        }
        return style;
    }

    public void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        this.getInnerCanvas().addFocusListener(listener);
    }

    public void addDragDetectListener(DragDetectListener listener) {
        super.addDragDetectListener(listener);
        this.getInnerCanvas().addDragDetectListener(listener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        super.addMenuDetectListener(listener);
        this.getInnerCanvas().addMenuDetectListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        super.addKeyListener(listener);
        this.getInnerCanvas().addKeyListener(listener);
    }

    public void addListener(int eventType, Listener listener) {
        super.addListener(eventType, listener);
        this.getInnerCanvas().addListener(eventType, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        this.getInnerCanvas().removeFocusListener(listener);
    }

    public void removeDragDetectListener(DragDetectListener listener) {
        super.removeDragDetectListener(listener);
        this.getInnerCanvas().removeDragDetectListener(listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        super.removeMenuDetectListener(listener);
        this.getInnerCanvas().removeMenuDetectListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        super.removeKeyListener(listener);
        this.getInnerCanvas().removeKeyListener(listener);
    }

    public void removeListener(int eventType, Listener listener) {
        super.removeListener(eventType, listener);
        this.getInnerCanvas().removeListener(eventType, listener);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        int borderSize = this.computeTrim((int)0, (int)0, (int)0, (int)0).x * -2;
        if (wHint >= 0) {
            wHint = Math.max(0, wHint - borderSize);
        }
        if (hHint >= 0) {
            hHint = Math.max(0, hHint - borderSize);
        }
        Dimension size = this.getLightweightSystem().getRootFigure().getPreferredSize(wHint, hHint).getExpanded(borderSize, borderSize);
        size.union(new Dimension(wHint, hHint));
        return new org.eclipse.swt.graphics.Point(size.width, size.height);
    }

    public IFigure getContents() {
        return this.getViewport().getContents();
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = super.getFont();
        }
        return this.font;
    }

    public int getHorizontalScrollBarVisibility() {
        return this.hBarVisibility;
    }

    int getVScrollBarWidth() {
        return 16;
    }

    int getHScrollBarHeight() {
        return 16;
    }

    public LightweightSystem getLightweightSystem() {
        return this.lws;
    }

    public int getVerticalScrollBarVisibility() {
        return this.vBarVisibility;
    }

    public Viewport getViewport() {
        if (this.viewport == null) {
            this.setViewport(new Viewport(true));
        }
        return this.viewport;
    }

    private void hook() {
        Slider verticalBar;
        this.getLightweightSystem().getUpdateManager().addUpdateListener(new UpdateListener(){

            public void notifyPainting(Rectangle damage, Map dirtyRegions) {
            }

            public void notifyValidating() {
                if (!FigureCanvas.this.isDisposed()) {
                    FigureCanvas.this.layoutViewport();
                }
            }
        });
        final Slider horizontalBar = this.getHorizontalSlider();
        if (horizontalBar != null) {
            horizontalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FigureCanvas.this.scrollToX(horizontalBar.getSelection() - FigureCanvas.this.hBarOffset);
                }
            });
        }
        if ((verticalBar = this.getVerticalSlider()) != null) {
            verticalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FigureCanvas.this.scrollToY(verticalBar.getSelection() - FigureCanvas.this.vBarOffset);
                }
            });
        }
    }

    private void hookViewport() {
        this.getViewport().getHorizontalRangeModel().addPropertyChangeListener(this.horizontalChangeListener);
        this.getViewport().getVerticalRangeModel().addPropertyChangeListener(this.verticalChangeListener);
    }

    private void unhookViewport() {
        this.getViewport().getHorizontalRangeModel().removePropertyChangeListener(this.horizontalChangeListener);
        this.getViewport().getVerticalRangeModel().removePropertyChangeListener(this.verticalChangeListener);
    }

    private void layoutViewport() {
        ScrollPaneSolver.Result result = ScrollPaneSolver.solve(new Rectangle(this.innerCanvas.getBounds()).setLocation(0, 0), this.getViewport(), this.getHorizontalScrollBarVisibility(), this.getVerticalScrollBarVisibility(), this.innerCanvas.computeTrim((int)0, (int)0, (int)0, (int)0).width, this.innerCanvas.computeTrim((int)0, (int)0, (int)0, (int)0).height);
        this.getLightweightSystem().setIgnoreResize(true);
        try {
            Slider verticalBar;
            Slider horizontalBar = this.getHorizontalSlider();
            if (horizontalBar != null && horizontalBar.getVisible() != result.showH) {
                horizontalBar.setVisible(result.showH);
                this.layout(new Control[]{horizontalBar});
            }
            if ((verticalBar = this.getVerticalSlider()) != null && verticalBar.getVisible() != result.showV) {
                verticalBar.setVisible(result.showV);
                this.layout(new Control[]{verticalBar});
            }
            Rectangle r = new Rectangle(this.getClientArea());
            r.setLocation(0, 0);
            this.getLightweightSystem().getRootFigure().setBounds(r);
        }
        finally {
            this.getLightweightSystem().setIgnoreResize(false);
        }
    }

    public void scrollSmoothTo(int x, int y) {
        x = this.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), x);
        y = this.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), y);
        int oldX = this.getViewport().getViewLocation().x;
        int oldY = this.getViewport().getViewLocation().y;
        int dx = x - oldX;
        int dy = y - oldY;
        if (dx == 0 && dy == 0) {
            return;
        }
        Dimension viewingArea = this.getViewport().getClientArea().getSize();
        int minFrames = 3;
        int maxFrames = 6;
        if (dx == 0 || dy == 0) {
            minFrames = 6;
            maxFrames = 13;
        }
        int frames = (Math.abs(dx) + Math.abs(dy)) / 15;
        frames = Math.max(frames, minFrames);
        frames = Math.min(frames, maxFrames);
        int stepX = Math.min(dx / frames, viewingArea.width / 3);
        int stepY = Math.min(dy / frames, viewingArea.height / 3);
        int i = 1;
        while (i < frames) {
            this.scrollTo(oldX + i * stepX, oldY + i * stepY);
            this.getViewport().getUpdateManager().performUpdate();
            ++i;
        }
        this.scrollTo(x, y);
    }

    public void scrollTo(int x, int y) {
        x = this.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), x);
        y = this.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), y);
        if (x == this.getViewport().getViewLocation().x) {
            this.scrollToY(y);
        } else if (y == this.getViewport().getViewLocation().y) {
            this.scrollToX(x);
        } else {
            this.getViewport().setViewLocation(x, y);
        }
    }

    public void scrollToX(int hOffset) {
        org.eclipse.swt.graphics.Rectangle bounds;
        int hOffsetOld;
        hOffset = this.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), hOffset);
        if (hOffset == (hOffsetOld = this.getViewport().getViewLocation().x)) {
            return;
        }
        int dx = -hOffset + hOffsetOld;
        Rectangle clientArea = this.getViewport().getBounds().getCropped(this.getViewport().getInsets());
        Rectangle blit = clientArea.getResized(-Math.abs(dx), 0);
        Rectangle expose = clientArea.getCopy();
        Point dest = clientArea.getTopLeft();
        expose.width = Math.abs(dx);
        if (dx < 0) {
            blit.translate(-dx, 0);
            expose.x = dest.x + blit.width;
        } else {
            dest.x += dx;
        }
        Control[] children = this.getInnerCanvas().getChildren();
        boolean[] manualMove = new boolean[children.length];
        int i = 0;
        while (i < children.length) {
            bounds = children[i].getBounds();
            manualMove[i] = blit.width <= 0 || bounds.x > blit.x + blit.width || bounds.y > blit.y + blit.height || bounds.x + bounds.width < blit.x || bounds.y + bounds.height < blit.y;
            ++i;
        }
        this.scroll(dest.x, dest.y, blit.x, blit.y, blit.width, blit.height, true);
        i = 0;
        while (i < children.length) {
            if (!children[i].isDisposed()) {
                bounds = children[i].getBounds();
                if (manualMove[i]) {
                    children[i].setBounds(bounds.x + dx, bounds.y, bounds.width, bounds.height);
                }
            }
            ++i;
        }
        this.getViewport().setIgnoreScroll(true);
        this.getViewport().setHorizontalLocation(hOffset);
        this.getViewport().setIgnoreScroll(false);
        this.getInnerCanvas().redraw();
    }

    public void scrollToY(int vOffset) {
        org.eclipse.swt.graphics.Rectangle bounds;
        int vOffsetOld;
        vOffset = this.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), vOffset);
        if (vOffset == (vOffsetOld = this.getViewport().getViewLocation().y)) {
            return;
        }
        int dy = -vOffset + vOffsetOld;
        Rectangle clientArea = this.getViewport().getBounds().getCropped(this.getViewport().getInsets());
        Rectangle blit = clientArea.getResized(0, -Math.abs(dy));
        Rectangle expose = clientArea.getCopy();
        Point dest = clientArea.getTopLeft();
        expose.height = Math.abs(dy);
        if (dy < 0) {
            blit.translate(0, -dy);
            expose.y = dest.y + blit.height;
        } else {
            dest.y += dy;
        }
        Control[] children = this.getInnerCanvas().getChildren();
        boolean[] manualMove = new boolean[children.length];
        int i = 0;
        while (i < children.length) {
            bounds = children[i].getBounds();
            manualMove[i] = blit.height <= 0 || bounds.x > blit.x + blit.width || bounds.y > blit.y + blit.height || bounds.x + bounds.width < blit.x || bounds.y + bounds.height < blit.y;
            ++i;
        }
        this.scroll(dest.x, dest.y, blit.x, blit.y, blit.width, blit.height, true);
        i = 0;
        while (i < children.length) {
            if (!children[i].isDisposed()) {
                bounds = children[i].getBounds();
                if (manualMove[i]) {
                    children[i].setBounds(bounds.x, bounds.y + dy, bounds.width, bounds.height);
                }
            }
            ++i;
        }
        this.getViewport().setIgnoreScroll(true);
        this.getViewport().setVerticalLocation(vOffset);
        this.getViewport().setIgnoreScroll(false);
        this.getInnerCanvas().redraw();
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (all) {
            Control[] children = this.getInnerCanvas().getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                org.eclipse.swt.graphics.Rectangle rect = child.getBounds();
                if (Math.min(x + width, rect.x + rect.width) >= Math.max(x, rect.x) && Math.min(y + height, rect.y + rect.height) >= Math.max(y, rect.y)) {
                    child.setLocation(rect.x + deltaX, rect.y + deltaY);
                }
                ++i;
            }
        }
    }

    public void setBorder(Border border) {
        this.getLightweightSystem().getRootFigure().setBorder(border);
    }

    public void setContents(IFigure figure) {
        this.getViewport().setContents(figure);
    }

    public void setFont(Font font) {
        this.font = font;
        super.setFont(font);
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.getInnerCanvas().setMenu(menu);
    }

    public void setHorizontalScrollBarVisibility(int v) {
        this.hBarVisibility = v;
    }

    public void setScrollBarVisibility(int both) {
        this.setHorizontalScrollBarVisibility(both);
        this.setVerticalScrollBarVisibility(both);
    }

    public void setVerticalScrollBarVisibility(int v) {
        this.vBarVisibility = v;
    }

    public void setViewport(Viewport vp) {
        if (this.viewport != null) {
            this.unhookViewport();
        }
        this.viewport = vp;
        this.lws.setContents(this.viewport);
        this.hookViewport();
    }

    private int verifyScrollBarOffset(RangeModel model, int value) {
        value = Math.max(model.getMinimum(), value);
        return Math.min(model.getMaximum() - model.getExtent(), value);
    }

    public Slider getHorizontalSlider() {
        this.checkWidget();
        if (this.horizontalBar == null) {
            this.horizontalBar = new Slider((Composite)this, 256);
            this.horizontalBar.setMaximum(100);
            this.horizontalBar.setThumb(10);
        }
        return this.horizontalBar;
    }

    public Slider getVerticalSlider() {
        this.checkWidget();
        if (this.verticalBar == null) {
            this.verticalBar = new Slider((Composite)this, 512);
            this.verticalBar.setMaximum(100);
            this.verticalBar.setThumb(10);
        }
        return this.verticalBar;
    }
}

