/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.tab;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.rap.tools.launch.rwt.internal.util.StatusUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class JavaProjectSelectionDialog {
    private static final int LABEL_PROVIDER_FLAGS = JavaElementLabelProvider.SHOW_DEFAULT;
    private final Shell parent;
    private ElementListSelectionDialog dialog;
    private IJavaProject initialSelection;

    public JavaProjectSelectionDialog(Shell parent) {
        this.parent = parent;
    }

    public void setInitialSelection(IJavaProject initialSelection) {
        this.initialSelection = initialSelection;
    }

    public IJavaProject getInitialSelection() {
        return this.initialSelection;
    }

    public IJavaProject open() {
        this.createDialog();
        this.initializeDialog();
        IJavaProject result = this.openDialog();
        this.closeDialog();
        return result;
    }

    private void createDialog() {
        JavaElementLabelProvider labelProvider = JavaProjectSelectionDialog.createLabelProvider();
        this.dialog = new ElementListSelectionDialog(this.parent, (ILabelProvider)labelProvider);
        this.dialog.setTitle("Project Selection");
        this.dialog.setMessage("Select a project to constrain your search");
    }

    private void initializeDialog() {
        this.dialog.setElements((Object[])JavaProjectSelectionDialog.collectAllJavaProjects());
        if (this.initialSelection != null) {
            this.dialog.setInitialSelections(new Object[]{this.initialSelection});
        } else {
            this.dialog.setInitialSelections(new Object[0]);
        }
    }

    private IJavaProject openDialog() {
        IJavaProject result = null;
        if (this.dialog.open() == 0) {
            result = (IJavaProject)this.dialog.getFirstResult();
        }
        return result;
    }

    private void closeDialog() {
        this.dialog.close();
        this.dialog = null;
    }

    private static JavaElementLabelProvider createLabelProvider() {
        return new JavaElementLabelProvider(LABEL_PROVIDER_FLAGS);
    }

    private static IJavaProject[] collectAllJavaProjects() {
        IJavaProject[] result;
        try {
            result = JavaCore.create((IWorkspaceRoot)JavaProjectSelectionDialog.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException jme) {
            result = new IJavaProject[]{};
            StatusUtil.log(jme);
        }
        return result;
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

