/**
 * /**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.BasisTypen.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.toolboxmodel.BasisTypen.util.BasisTypenAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class BasisTypenItemProviderAdapterFactory extends BasisTypenAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BasisTypenItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Aussenanlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Aussenanlage_TypeClassItemProvider bezeichnung_Aussenanlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Aussenanlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Aussenanlage_TypeClassAdapter() {
		if (bezeichnung_Aussenanlage_TypeClassItemProvider == null) {
			bezeichnung_Aussenanlage_TypeClassItemProvider = new Bezeichnung_Aussenanlage_TypeClassItemProvider(this);
		}

		return bezeichnung_Aussenanlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Element_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Element_AttributeGroupItemProvider bezeichnung_Element_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Element_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Element_AttributeGroupAdapter() {
		if (bezeichnung_Element_AttributeGroupItemProvider == null) {
			bezeichnung_Element_AttributeGroupItemProvider = new Bezeichnung_Element_AttributeGroupItemProvider(this);
		}

		return bezeichnung_Element_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Lageplan_Kurz_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Lageplan_Kurz_TypeClassItemProvider bezeichnung_Lageplan_Kurz_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Lageplan_Kurz_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Lageplan_Kurz_TypeClassAdapter() {
		if (bezeichnung_Lageplan_Kurz_TypeClassItemProvider == null) {
			bezeichnung_Lageplan_Kurz_TypeClassItemProvider = new Bezeichnung_Lageplan_Kurz_TypeClassItemProvider(this);
		}

		return bezeichnung_Lageplan_Kurz_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Lageplan_Lang_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Lageplan_Lang_TypeClassItemProvider bezeichnung_Lageplan_Lang_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Lageplan_Lang_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Lageplan_Lang_TypeClassAdapter() {
		if (bezeichnung_Lageplan_Lang_TypeClassItemProvider == null) {
			bezeichnung_Lageplan_Lang_TypeClassItemProvider = new Bezeichnung_Lageplan_Lang_TypeClassItemProvider(this);
		}

		return bezeichnung_Lageplan_Lang_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Tabelle_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Tabelle_TypeClassItemProvider bezeichnung_Tabelle_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Tabelle_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Tabelle_TypeClassAdapter() {
		if (bezeichnung_Tabelle_TypeClassItemProvider == null) {
			bezeichnung_Tabelle_TypeClassItemProvider = new Bezeichnung_Tabelle_TypeClassItemProvider(this);
		}

		return bezeichnung_Tabelle_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.Datum_Auslieferung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Datum_Auslieferung_TypeClassItemProvider datum_Auslieferung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.Datum_Auslieferung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatum_Auslieferung_TypeClassAdapter() {
		if (datum_Auslieferung_TypeClassItemProvider == null) {
			datum_Auslieferung_TypeClassItemProvider = new Datum_Auslieferung_TypeClassItemProvider(this);
		}

		return datum_Auslieferung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.ID_Bearbeitungsvermerk_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ID_Bearbeitungsvermerk_TypeClassItemProvider iD_Bearbeitungsvermerk_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.ID_Bearbeitungsvermerk_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createID_Bearbeitungsvermerk_TypeClassAdapter() {
		if (iD_Bearbeitungsvermerk_TypeClassItemProvider == null) {
			iD_Bearbeitungsvermerk_TypeClassItemProvider = new ID_Bearbeitungsvermerk_TypeClassItemProvider(this);
		}

		return iD_Bearbeitungsvermerk_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.Kennzahl_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Kennzahl_TypeClassItemProvider kennzahl_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.Kennzahl_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKennzahl_TypeClassAdapter() {
		if (kennzahl_TypeClassItemProvider == null) {
			kennzahl_TypeClassItemProvider = new Kennzahl_TypeClassItemProvider(this);
		}

		return kennzahl_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.Oertlicher_Elementname_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Oertlicher_Elementname_TypeClassItemProvider oertlicher_Elementname_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.Oertlicher_Elementname_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOertlicher_Elementname_TypeClassAdapter() {
		if (oertlicher_Elementname_TypeClassItemProvider == null) {
			oertlicher_Elementname_TypeClassItemProvider = new Oertlicher_Elementname_TypeClassItemProvider(this);
		}

		return oertlicher_Elementname_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.Pruefmerkmale_Daten_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Pruefmerkmale_Daten_AttributeGroupItemProvider pruefmerkmale_Daten_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.Pruefmerkmale_Daten_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPruefmerkmale_Daten_AttributeGroupAdapter() {
		if (pruefmerkmale_Daten_AttributeGroupItemProvider == null) {
			pruefmerkmale_Daten_AttributeGroupItemProvider = new Pruefmerkmale_Daten_AttributeGroupItemProvider(this);
		}

		return pruefmerkmale_Daten_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.Pruefsumme_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Pruefsumme_Art_TypeClassItemProvider pruefsumme_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.Pruefsumme_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPruefsumme_Art_TypeClassAdapter() {
		if (pruefsumme_Art_TypeClassItemProvider == null) {
			pruefsumme_Art_TypeClassItemProvider = new Pruefsumme_Art_TypeClassItemProvider(this);
		}

		return pruefsumme_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.Pruefsumme_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Pruefsumme_TypeClassItemProvider pruefsumme_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.Pruefsumme_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPruefsumme_TypeClassAdapter() {
		if (pruefsumme_TypeClassItemProvider == null) {
			pruefsumme_TypeClassItemProvider = new Pruefsumme_TypeClassItemProvider(this);
		}

		return pruefsumme_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.Version_Auslieferung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Version_Auslieferung_TypeClassItemProvider version_Auslieferung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.Version_Auslieferung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVersion_Auslieferung_TypeClassAdapter() {
		if (version_Auslieferung_TypeClassItemProvider == null) {
			version_Auslieferung_TypeClassItemProvider = new Version_Auslieferung_TypeClassItemProvider(this);
		}

		return version_Auslieferung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.BasisTypen.Zeiger_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zeiger_TypeClassItemProvider zeiger_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.BasisTypen.Zeiger_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZeiger_TypeClassAdapter() {
		if (zeiger_TypeClassItemProvider == null) {
			zeiger_TypeClassItemProvider = new Zeiger_TypeClassItemProvider(this);
		}

		return zeiger_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (bezeichnung_Aussenanlage_TypeClassItemProvider != null) bezeichnung_Aussenanlage_TypeClassItemProvider.dispose();
		if (bezeichnung_Element_AttributeGroupItemProvider != null) bezeichnung_Element_AttributeGroupItemProvider.dispose();
		if (bezeichnung_Lageplan_Kurz_TypeClassItemProvider != null) bezeichnung_Lageplan_Kurz_TypeClassItemProvider.dispose();
		if (bezeichnung_Lageplan_Lang_TypeClassItemProvider != null) bezeichnung_Lageplan_Lang_TypeClassItemProvider.dispose();
		if (bezeichnung_Tabelle_TypeClassItemProvider != null) bezeichnung_Tabelle_TypeClassItemProvider.dispose();
		if (datum_Auslieferung_TypeClassItemProvider != null) datum_Auslieferung_TypeClassItemProvider.dispose();
		if (iD_Bearbeitungsvermerk_TypeClassItemProvider != null) iD_Bearbeitungsvermerk_TypeClassItemProvider.dispose();
		if (kennzahl_TypeClassItemProvider != null) kennzahl_TypeClassItemProvider.dispose();
		if (oertlicher_Elementname_TypeClassItemProvider != null) oertlicher_Elementname_TypeClassItemProvider.dispose();
		if (pruefmerkmale_Daten_AttributeGroupItemProvider != null) pruefmerkmale_Daten_AttributeGroupItemProvider.dispose();
		if (pruefsumme_Art_TypeClassItemProvider != null) pruefsumme_Art_TypeClassItemProvider.dispose();
		if (pruefsumme_TypeClassItemProvider != null) pruefsumme_TypeClassItemProvider.dispose();
		if (version_Auslieferung_TypeClassItemProvider != null) version_Auslieferung_TypeClassItemProvider.dispose();
		if (zeiger_TypeClassItemProvider != null) zeiger_TypeClassItemProvider.dispose();
	}

}
