/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.ordering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.OrderedTreeLayout;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.AbstractTreeViewOrdering;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class OrderedTreeOrdering
extends AbstractTreeViewOrdering {
    private Collection<String> domainClasses;
    private OrderedTreeLayout layout;
    private Map<View, List<Node>> map;

    public OrderedTreeOrdering(OrderedTreeLayout layout) {
        this.layout = layout;
        this.domainClasses = this.getDomainClasses();
        this.map = new WeakHashMap<View, List<Node>>();
    }

    private Collection<String> getDomainClasses() {
        ArrayList<String> classes = new ArrayList<String>();
        for (AbstractNodeMapping mapping : this.layout.getNodeMapping()) {
            if (StringUtil.isEmpty((String)mapping.getDomainClass())) continue;
            classes.add(mapping.getDomainClass());
        }
        return classes;
    }

    @Override
    public List<View> getRoots(List<View> views) {
        LinkedList<View> result = new LinkedList<View>(views);
        for (View currentView : views) {
            this.map.put(currentView, this.computeChildren(currentView, views));
            for (Node node : this.map.get(currentView)) {
                result.remove(node);
            }
        }
        return result;
    }

    @Override
    protected void clear() {
        this.map.clear();
    }

    @Override
    public List<View> getChildren(View parent, List<View> views) {
        if (this.map.containsKey(parent)) {
            return this.map.get(parent);
        }
        return Collections.emptyList();
    }

    public List<Node> computeChildren(View parent, List<View> views) {
        ModelAccessor accesor;
        EObject element;
        LinkedList<Node> result = new LinkedList<Node>();
        if (parent.getElement() instanceof DSemanticDecorator && (element = ((DSemanticDecorator)parent.getElement()).getTarget()) != null && element.eResource() != null && (accesor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(element)) != null && this.isInstanceOfOneDomainClass(element, accesor)) {
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)element);
            RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
            Collection acceleoResult = safeInterpreter.evaluateCollection(element, (EObject)this.layout, (EStructuralFeature)DescriptionPackage.eINSTANCE.getOrderedTreeLayout_ChildrenExpression());
            ArrayList<EObject> children = new ArrayList<EObject>(acceleoResult);
            result.addAll(this.getChildrenNode(views, children));
        }
        return result;
    }

    private List<Node> getChildrenNode(List<View> views, List<EObject> children) {
        LinkedList<Node> childrenNodes = new LinkedList<Node>();
        block0: for (EObject child : children) {
            for (View view : views) {
                EObject currentSemantic;
                if (!(view instanceof Node) || !(view.getElement() instanceof DSemanticDecorator) || !(currentSemantic = ((DSemanticDecorator)view.getElement()).getTarget()).equals(child)) continue;
                childrenNodes.add((Node)view);
                continue block0;
            }
        }
        return childrenNodes;
    }

    private boolean isInstanceOfOneDomainClass(EObject element, ModelAccessor accessor) {
        boolean isInstance = false;
        Iterator<String> it = this.domainClasses.iterator();
        while (it.hasNext() && !isInstance) {
            isInstance = accessor.eInstanceOf(element, it.next());
        }
        return isInstance;
    }
}

