/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.utils.dnd;

import java.awt.AWTException;
import java.awt.Robot;
import java.io.IOException;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.util.Geometry;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;

public class DndUtil {
    private static final int DRAG_THRESHOLD = "gtk".equals(SWT.getPlatform()) ? 16 : 10;
    private static final int DRAG_DELAY = 400;
    private final Display display;

    public DndUtil(Display display) {
        this.display = display;
    }

    public void dragAndDrop(AbstractSWTBot<? extends Widget> source, AbstractSWTBot<? extends Widget> target, org.eclipse.swt.graphics.Point locationOnTarget) {
        Rectangle targetRectangle = DndUtil.absoluteLocation(target);
        org.eclipse.swt.graphics.Point dropTarget = new org.eclipse.swt.graphics.Point(targetRectangle.x + locationOnTarget.x, targetRectangle.y + locationOnTarget.y);
        this.doDragAndDrop(source, dropTarget);
    }

    public void dragAndDrop(AbstractSWTBot<? extends Widget> source, AbstractSWTBot<? extends Widget> target, Point locationOnTarget) {
        this.dragAndDrop(source, target, new org.eclipse.swt.graphics.Point(locationOnTarget.x, locationOnTarget.y));
    }

    public void dragAndDrop(AbstractSWTBot<? extends Widget> source, org.eclipse.swt.graphics.Point target) {
        this.doDragAndDrop(source, target);
    }

    private void doDragAndDrop(AbstractSWTBot<? extends Widget> source, final org.eclipse.swt.graphics.Point dest) {
        Rectangle sourceLocation = DndUtil.absoluteLocation(source);
        org.eclipse.swt.graphics.Point slightOffset = Geometry.add((org.eclipse.swt.graphics.Point)Geometry.getLocation((Rectangle)sourceLocation), (org.eclipse.swt.graphics.Point)new org.eclipse.swt.graphics.Point(DRAG_THRESHOLD, DRAG_THRESHOLD));
        final org.eclipse.swt.graphics.Point sourcePoint = Geometry.min((org.eclipse.swt.graphics.Point)Geometry.centerPoint((Rectangle)sourceLocation), (org.eclipse.swt.graphics.Point)slightOffset);
        try {
            final Robot awtRobot = new Robot();
            this.syncExec(new VoidResult(){

                public void run() {
                    awtRobot.mouseMove(sourcePoint.x, sourcePoint.y);
                    awtRobot.mousePress(16);
                    awtRobot.mouseMove(sourcePoint.x + DRAG_THRESHOLD, sourcePoint.y);
                }
            });
            SWTBotWrapper botWrapper = new SWTBotWrapper(source);
            botWrapper.notifyDragDetect();
            SWTUtils.sleep((long)400L);
            this.syncExec(new VoidResult(){

                public void run() {
                    awtRobot.mouseMove(dest.x + DRAG_THRESHOLD, dest.y);
                    awtRobot.mouseMove(dest.x, dest.y);
                }
            });
            SWTUtils.sleep((long)400L);
            this.syncExec(new VoidResult(){

                public void run() {
                    awtRobot.mouseRelease(16);
                }
            });
        }
        catch (AWTException e) {
            throw new RuntimeException(e);
        }
    }

    private void syncExec(VoidResult toExecute) {
        UIThreadRunnable.syncExec((Display)this.display, (VoidResult)toExecute);
    }

    public static <T extends Widget> org.eclipse.swt.graphics.Point before(AbstractSWTBot<T> targetItem) {
        return DndUtil.pointOnUpperBorder(DndUtil.absoluteLocation(targetItem));
    }

    public static <T extends Widget> org.eclipse.swt.graphics.Point on(AbstractSWTBot<T> targetItem) {
        return Geometry.centerPoint((Rectangle)DndUtil.absoluteLocation(targetItem));
    }

    public static <T extends Widget> org.eclipse.swt.graphics.Point after(AbstractSWTBot<T> targetItem) {
        return DndUtil.pointOnLowerBorder(DndUtil.absoluteLocation(targetItem));
    }

    private static org.eclipse.swt.graphics.Point pointOnLowerBorder(Rectangle rect) {
        return new org.eclipse.swt.graphics.Point(Geometry.centerPoint((Rectangle)rect).x, rect.y + rect.height - 1);
    }

    private static org.eclipse.swt.graphics.Point pointOnUpperBorder(Rectangle rect) {
        return new org.eclipse.swt.graphics.Point(Geometry.centerPoint((Rectangle)rect).x, rect.y + 1);
    }

    private static <T extends Widget> Rectangle absoluteLocation(AbstractSWTBot<T> item) {
        Object result = ReflectionHelper.invokeMethodWithoutExceptionWithReturn(item, AbstractSWTBot.class, (String)"absoluteLocation", (Class[])new Class[0], (Object[])new Object[0], (boolean)true);
        return (Rectangle)result;
    }

    public static boolean isUsingXvnc() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") >= 0) {
            String xdisplay = System.getenv("DISPLAY");
            StringBuilder commandBuilder = new StringBuilder();
            commandBuilder.append("/usr/bin/pgrep -l -f ");
            commandBuilder.append("Xvnc.*");
            commandBuilder.append(xdisplay);
            try {
                Process proc = Runtime.getRuntime().exec(commandBuilder.toString());
                proc.waitFor();
                return proc.exitValue() == 0;
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    private class SWTBotWrapper
    extends AbstractSWTBot<Widget> {
        AbstractSWTBot<? extends Widget> wrappedSWTBot;

        SWTBotWrapper(AbstractSWTBot<? extends Widget> w) throws WidgetNotFoundException {
            super(w.widget);
            this.wrappedSWTBot = w;
        }

        public void notifyDragDetect() {
            Event dragDetectEvent = this.createMouseEvent(1, 0, 0);
            final Control control = this.getDNDControl();
            final Listener dragSourceListener = (Listener)this.syncExec((Result)new Result<Listener>(){

                public Listener run() {
                    Listener[] listenerArray = control.getListeners(29);
                    int n = listenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Listener listener = listenerArray[n2];
                        if (DragSource.class.equals(listener.getClass().getEnclosingClass())) {
                            return listener;
                        }
                        ++n2;
                    }
                    return null;
                }
            });
            try {
                if (dragSourceListener != null) {
                    this.syncExec(new VoidResult(){

                        public void run() {
                            control.removeListener(29, dragSourceListener);
                        }
                    });
                }
                this.notify(29, dragDetectEvent, (Widget)control);
            }
            catch (Throwable throwable) {
                if (dragSourceListener != null) {
                    this.syncExec(new VoidResult(control, dragSourceListener){
                        private final /* synthetic */ Control val$control;
                        private final /* synthetic */ Listener val$dragSourceListener;
                        {
                            this.val$control = control;
                            this.val$dragSourceListener = listener;
                        }

                        public void run() {
                            this.val$control.addListener(29, this.val$dragSourceListener);
                        }
                    });
                }
                throw throwable;
            }
            if (dragSourceListener != null) {
                this.syncExec(new /* invalid duplicate definition of identical inner class */);
            }
        }

        protected Control getDNDControl() {
            return (Control)ReflectionHelper.invokeMethodWithoutExceptionWithReturn(this.wrappedSWTBot, AbstractSWTBot.class, (String)"getDNDControl", (Class[])new Class[0], (Object[])new Object[0], (boolean)true);
        }

        protected Rectangle getBounds() {
            return (Rectangle)ReflectionHelper.invokeMethodWithoutExceptionWithReturn(this.wrappedSWTBot, AbstractSWTBot.class, (String)"getBounds", (Class[])new Class[0], (Object[])new Object[0], (boolean)true);
        }
    }
}

