/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.ext.widgets.reference.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.IEEFOnClickController;
import org.eclipse.eef.core.ext.widgets.reference.internal.EEFExtReferenceController;
import org.eclipse.eef.ext.widgets.reference.eefextwidgetsreference.EEFExtReferenceDescription;
import org.eclipse.eef.ide.ui.api.widgets.EEFTableSelectionListener;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.AbstractEEFExtReferenceLifecycleManager;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtEObjectCreationWizard;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtReferenceUIPlugin;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EReferenceContentProvider;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.Messages;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class EEFExtMultipleReferenceLifecycleManager
extends AbstractEEFExtReferenceLifecycleManager {
    private static final int TABLE_MINIMAL_HEIGHT = 150;
    protected TableViewer tableViewer;
    protected SelectionListener tableSelectionListener;
    protected Button upButton;
    protected AbstractEEFExtReferenceLifecycleManager.ButtonSelectionListener upButtonListener;
    protected Button downButton;
    protected AbstractEEFExtReferenceLifecycleManager.ButtonSelectionListener downButtonListener;

    public EEFExtMultipleReferenceLifecycleManager(EEFExtReferenceDescription description, EObject target, EReference eReference, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(description, target, eReference, variableManager, interpreter, editingContextAdapter);
    }

    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        this.widgetFactory = formContainer.getWidgetFactory();
        Composite referenceComposite = this.widgetFactory.createFlatFormComposite(parent);
        GridLayout referenceGridLayout = new GridLayout(2, false);
        referenceComposite.setLayout((Layout)referenceGridLayout);
        GridData referenceCompositeGridData = new GridData(4, 0x1000000, true, false);
        referenceComposite.setLayoutData((Object)referenceCompositeGridData);
        this.createTable(referenceComposite);
        Composite buttonsComposite = this.widgetFactory.createFlatFormComposite(referenceComposite);
        GridData buttonCompositeGridData = new GridData();
        buttonCompositeGridData.verticalAlignment = 1;
        buttonsComposite.setLayoutData((Object)buttonCompositeGridData);
        GridLayout buttonCompositeGridLayout = new GridLayout(1, false);
        buttonCompositeGridLayout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)buttonCompositeGridLayout);
        this.createButtons(buttonsComposite);
        Point computedSize = buttonsComposite.computeSize(-1, -1);
        this.tableViewer.getTable().setSize(0, Math.max(150, computedSize.y));
        this.widgetFactory.paintBordersFor(parent);
        this.controller = new EEFExtReferenceController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
    }

    @Override
    protected void createButtons(Composite buttonsComposite) {
        if (!this.eReference.isContainment()) {
            Image browseImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Browse_16x16.gif"));
            this.browseButton = this.createButton(buttonsComposite, browseImage);
        }
        Image addImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Add_16x16.gif"));
        Image removeImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Delete_16x16.gif"));
        Image upImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/ArrowUp_16x16.gif"));
        Image downImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/ArrowDown_16x16.gif"));
        this.addButton = this.createButton(buttonsComposite, addImage);
        this.removeButton = this.createButton(buttonsComposite, removeImage);
        this.upButton = this.createButton(buttonsComposite, upImage);
        this.downButton = this.createButton(buttonsComposite, downImage);
    }

    protected void createTable(Composite parent) {
        ScrolledComposite scrolledComposite = this.widgetFactory.createScrolledComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        scrolledComposite.setLayoutData((Object)gridData);
        int style = 268503564;
        Table table = this.widgetFactory.createTable((Composite)scrolledComposite, style);
        this.tableViewer = new TableViewer(table);
        GridData tableGridData = new GridData(4, 128, true, false, 1, 1);
        tableGridData.horizontalIndent = 5;
        this.tableViewer.getTable().setLayoutData((Object)tableGridData);
        this.composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.composedAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.tableViewer.setContentProvider((IContentProvider)new EReferenceContentProvider(this.eReference));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider((AdapterFactory)this.composedAdapterFactory, (Viewer)this.tableViewer)));
        scrolledComposite.setContent((Control)table);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setAlwaysShowScrollBars(true);
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.tableSelectionListener = new EEFTableSelectionListener((IEEFOnClickController)this.controller);
        this.tableViewer.getTable().addSelectionListener(this.tableSelectionListener);
        this.initializeMoveButton(Direction.UP);
        this.initializeMoveButton(Direction.DOWN);
    }

    @Override
    protected void browseButtonCallback() {
        IItemPropertySource propertySource;
        IItemPropertyDescriptor propertyDescriptor;
        Adapter adapter = this.composedAdapterFactory.adapt((Notifier)this.target, IItemPropertySource.class);
        if (adapter instanceof IItemPropertySource && (propertyDescriptor = (propertySource = (IItemPropertySource)adapter).getPropertyDescriptor((Object)this.target, (Object)this.eReference)) != null) {
            ArrayList choiceOfValues = new ArrayList(propertyDescriptor.getChoiceOfValues((Object)this.target));
            final AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
            LabelProvider labelProvider = new LabelProvider(){

                public String getText(Object object) {
                    return adapterFactoryLabelProvider.getText(object);
                }

                public Image getImage(Object object) {
                    return ExtendedImageRegistry.getInstance().getImage((Object)adapterFactoryLabelProvider.getImage(object));
                }
            };
            FeatureEditorDialog dialog = new FeatureEditorDialog(this.tableViewer.getTable().getShell(), (ILabelProvider)labelProvider, this.target, (EStructuralFeature)this.eReference, propertyDescriptor.getDisplayName((Object)this.target), choiceOfValues);
            dialog.open();
            EList result = dialog.getResult();
            if (result != null) {
                this.target.eSet((EStructuralFeature)this.eReference, (Object)result);
            }
        }
    }

    @Override
    protected void addButtonCallback() {
        EEFExtEObjectCreationWizard wizard = new EEFExtEObjectCreationWizard(this.target, this.eReference, this.editingContextAdapter);
        WizardDialog wizardDialog = new WizardDialog(this.tableViewer.getTable().getShell(), (IWizard)wizard);
        wizardDialog.open();
    }

    @Override
    protected void removeButtonCallback() {
        this.editingContextAdapter.performModelChange(() -> {
            List<Object> objects = this.selectionToList(this.tableViewer.getSelection());
            for (Object object : objects) {
                EcoreUtil.remove((EObject)this.target, (EStructuralFeature)this.eReference, (Object)object);
            }
        });
    }

    protected void initializeMoveButton(Direction direction) {
        AbstractEEFExtReferenceLifecycleManager.ButtonSelectionListener listener = new AbstractEEFExtReferenceLifecycleManager.ButtonSelectionListener(this.editingContextAdapter, () -> this.moveButtonCallback(direction));
        if (direction == Direction.UP) {
            this.upButtonListener = listener;
            this.upButton.addSelectionListener((SelectionListener)this.upButtonListener);
            this.upButton.setToolTipText(Messages.ReferenceUpButton_tooltipText);
        } else {
            this.downButtonListener = listener;
            this.downButton.addSelectionListener((SelectionListener)this.downButtonListener);
            this.downButton.setToolTipText(Messages.ReferenceDownButton_tooltipText);
        }
    }

    protected void moveButtonCallback(Direction direction) {
        List<Object> objects = this.selectionToList(this.tableViewer.getSelection());
        EList<?> values = this.getValues();
        for (Object object : objects) {
            if (direction == Direction.UP) {
                values.move(Math.max(0, values.indexOf(object) - 1), values.indexOf(object));
                continue;
            }
            values.move(Math.min(values.size() - 1, values.indexOf(object) + 1), values.indexOf(object));
        }
        this.tableViewer.refresh();
    }

    private EList<?> getValues() {
        Object value = this.target.eGet((EStructuralFeature)this.eReference);
        if (value instanceof EList) {
            return (EList)value;
        }
        return new BasicEList();
    }

    private List<Object> selectionToList(ISelection selection) {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                objects.add(object);
                ++n2;
            }
        }
        return objects;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.tableViewer.setInput((Object)this.target);
    }

    @Override
    protected void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.upButton != null && !this.upButton.isDisposed()) {
            this.upButton.setEnabled(isEnabled);
        }
        if (this.downButton != null && !this.downButton.isDisposed()) {
            this.downButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.tableViewer != null && this.tableViewer.getTable() != null && !this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.getTable().removeSelectionListener(this.tableSelectionListener);
        }
        this.removeListener(this.upButton, this.upButtonListener);
        this.removeListener(this.downButton, this.downButtonListener);
    }

    protected Control getValidationControl() {
        return this.tableViewer.getTable().getParent();
    }

    protected static enum Direction {
        UP,
        DOWN;

    }
}

