/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration.resource;

import com.google.common.base.Predicate;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceFileExtensionPredicate
implements Predicate<Resource> {
    private final String fileExtension;
    private final boolean shouldBePlatformResource;

    public ResourceFileExtensionPredicate(String fileExtension) {
        this(fileExtension, true);
    }

    public ResourceFileExtensionPredicate(String fileExtension, boolean shouldBePlatformResource) {
        this.fileExtension = fileExtension;
        this.shouldBePlatformResource = shouldBePlatformResource;
    }

    public boolean apply(Resource input) {
        boolean result = true;
        if (this.shouldBePlatformResource) {
            result = input.getURI().isPlatformResource();
        }
        return result && input.getURI() != null && input.getURI().fileExtension() != null && input.getURI().fileExtension().equals(this.fileExtension);
    }
}

