/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.ResizeKind;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.AbstractNodeMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DiagramElementMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingExtHelper;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public final class NodeMappingHelper {
    private IInterpreter interpreter;
    private StyleHelper styleHelper;

    public NodeMappingHelper(IInterpreter interpreter) {
        this.interpreter = interpreter;
        this.styleHelper = new StyleHelper(interpreter);
    }

    public DNode createNode(NodeMapping self, EObject modelElement, EObject container, DDiagram diagram) {
        NodeStyle bestStyle;
        DNode newNode = DiagramFactory.eINSTANCE.createDNode();
        NodeStyleDescription style = (NodeStyleDescription)new MappingWithInterpreterHelper(this.interpreter).getBestStyleDescription((DiagramElementMapping)self, modelElement, (EObject)newNode, container, diagram);
        newNode.setTarget(modelElement);
        newNode.setActualMapping(self);
        DiagramElementMappingHelper.refreshSemanticElements((DiagramElementMapping)self, (DDiagramElement)newNode, this.interpreter);
        this.interpreter.setVariable("diagram", (Object)diagram);
        this.interpreter.setVariable("view", (Object)newNode);
        if (style != null && style.getLabelExpression() != null) {
            try {
                String name = this.interpreter.evaluateString(modelElement, style.getLabelExpression());
                newNode.setName(name);
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression(), (Throwable)e);
            }
        }
        if (style != null) {
            newNode.setResizeKind(style.getResizeKind());
            this.styleHelper.setComputedSize(newNode, style);
        }
        if ((bestStyle = (NodeStyle)new MappingWithInterpreterHelper(this.interpreter).getBestStyle((DiagramElementMapping)self, modelElement, (EObject)newNode, container, diagram)) != null) {
            newNode.setOwnedStyle(bestStyle);
        }
        MappingExtHelper.addDoneNode((AbstractNodeMapping)self, (DDiagramElement)newNode);
        this.interpreter.unSetVariable("view");
        this.interpreter.unSetVariable("diagram");
        AbstractNodeMappingSpecOperations.createBorderingNodes((AbstractNodeMapping)self, modelElement, (DDiagramElement)newNode, Collections.EMPTY_LIST, diagram);
        if (newNode.getOwnedStyle() != null) {
            Option noPreviousStyle = Options.newNone();
            new StyleHelper(this.interpreter).refreshStyle((Style)newNode.getOwnedStyle(), (Option<? extends Style>)noPreviousStyle);
        }
        return newNode;
    }

    public void updateNode(NodeMapping self, DNode node) {
        DDiagram parentDiagram;
        NodeStyleDescription style;
        EObject modelElement;
        block17: {
            block15: {
                modelElement = node.getTarget();
                DSemanticDecorator container = (DSemanticDecorator)node.eContainer();
                style = null;
                parentDiagram = node.getParentDiagram();
                if (container != null) {
                    style = (NodeStyleDescription)new MappingWithInterpreterHelper(this.interpreter).getBestStyleDescription((DiagramElementMapping)self, modelElement, (EObject)node, container.getTarget(), parentDiagram);
                }
                if (style != null && style.getLabelExpression() != null) {
                    try {
                        try {
                            this.interpreter.setVariable("diagram", (Object)parentDiagram);
                            this.interpreter.setVariable("view", (Object)node);
                            String name = this.interpreter.evaluateString(modelElement, style.getLabelExpression());
                            node.setName(name);
                        }
                        catch (EvaluationException e) {
                            RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression(), (Throwable)e);
                            this.interpreter.unSetVariable("diagram");
                            this.interpreter.unSetVariable("view");
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        this.interpreter.unSetVariable("diagram");
                        this.interpreter.unSetVariable("view");
                        throw throwable;
                    }
                    this.interpreter.unSetVariable("diagram");
                    this.interpreter.unSetVariable("view");
                }
            }
            if (style != null && style.getTooltipExpression() != null) {
                try {
                    try {
                        this.interpreter.setVariable("diagram", (Object)parentDiagram);
                        this.interpreter.setVariable("view", (Object)node);
                        String tooltip = this.interpreter.evaluateString(modelElement, style.getTooltipExpression());
                        node.setTooltipText(tooltip);
                    }
                    catch (EvaluationException e) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getTooltipStyleDescription_TooltipExpression(), (Throwable)e);
                        this.interpreter.unSetVariable("diagram");
                        this.interpreter.unSetVariable("view");
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    this.interpreter.unSetVariable("diagram");
                    this.interpreter.unSetVariable("view");
                    throw throwable;
                }
                this.interpreter.unSetVariable("diagram");
                this.interpreter.unSetVariable("view");
            }
        }
        if (node.getResizeKind() == ResizeKind.NONE_LITERAL) {
            this.styleHelper.setComputedSize(node, style);
        }
        DiagramElementMappingHelper.refreshSemanticElements((DiagramElementMapping)self, (DDiagramElement)node, this.interpreter);
        EObject containerVariable = null;
        if (node.eContainer() instanceof DSemanticDecorator) {
            containerVariable = ((DSemanticDecorator)node.eContainer()).getTarget();
        }
        StyleDescription bestStyleDescription = new MappingWithInterpreterHelper(this.interpreter).getBestStyleDescription((DiagramElementMapping)self, modelElement, (EObject)node, containerVariable, parentDiagram);
        Style bestStyle = node.getStyle();
        if ((bestStyle == null || bestStyle.getDescription() != bestStyleDescription) && bestStyleDescription != null) {
            bestStyle = this.styleHelper.createStyle(bestStyleDescription);
        }
        this.styleHelper.setAndRefreshStyle((DDiagramElement)node, node.getStyle(), bestStyle);
        MappingExtHelper.addDoneNode((AbstractNodeMapping)self, (DDiagramElement)node);
    }

    public DNodeListElement createListElement(NodeMapping self, EObject modelElement, DDiagram diagram) {
        DNodeListElement newNode = DiagramFactory.eINSTANCE.createDNodeListElement();
        NodeStyleDescription style = (NodeStyleDescription)new MappingWithInterpreterHelper(this.interpreter).getBestStyleDescription((DiagramElementMapping)self, modelElement, (EObject)newNode, null, diagram);
        newNode.setTarget(modelElement);
        newNode.setActualMapping(self);
        DiagramElementMappingHelper.refreshSemanticElements((DiagramElementMapping)self, (DDiagramElement)newNode, this.interpreter);
        if (style != null && !StringUtil.isEmpty((String)style.getLabelExpression())) {
            newNode.setName(DiagramElementMappingHelper.computeLabel((DDiagramElement)newNode, (BasicLabelStyleDescription)style, diagram, this.interpreter));
        }
        MappingExtHelper.addDoneNode((AbstractNodeMapping)self, (DDiagramElement)newNode);
        NodeStyle bestStyle = (NodeStyle)new MappingWithInterpreterHelper(this.interpreter).getBestStyle((DiagramElementMapping)self, modelElement, (EObject)newNode, null, diagram);
        if (bestStyle != null) {
            newNode.setOwnedStyle(bestStyle);
        }
        return newNode;
    }

    public void updateListElement(NodeMapping self, DNodeListElement listElement) {
        EObject modelElement = listElement.getTarget();
        DSemanticDecorator container = (DSemanticDecorator)listElement.eContainer();
        NodeStyleDescription style = null;
        DDiagram parentDiagram = listElement.getParentDiagram();
        if (container != null) {
            style = (NodeStyleDescription)new MappingWithInterpreterHelper(this.interpreter).getBestStyleDescription((DiagramElementMapping)self, modelElement, (EObject)listElement, container.getTarget(), parentDiagram);
        }
        if (style != null && !StringUtil.isEmpty((String)style.getLabelExpression())) {
            listElement.setName(DiagramElementMappingHelper.computeLabel((DDiagramElement)listElement, style, parentDiagram, this.interpreter));
        }
        EObject containerVariable = null;
        if (listElement.eContainer() instanceof DSemanticDecorator) {
            containerVariable = ((DSemanticDecorator)listElement.eContainer()).getTarget();
        }
        DiagramElementMappingHelper.refreshSemanticElements((DiagramElementMapping)self, (DDiagramElement)listElement, this.interpreter);
        NodeStyle bestStyle = (NodeStyle)new MappingWithInterpreterHelper(this.interpreter).getBestStyle((DiagramElementMapping)self, modelElement, (EObject)listElement, containerVariable, parentDiagram);
        if ((bestStyle == null || bestStyle.getDescription() != style) && style != null) {
            listElement.setOwnedStyle(bestStyle);
        }
        this.styleHelper.setAndRefreshStyle((DDiagramElement)listElement, listElement.getStyle(), (Style)bestStyle);
        MappingExtHelper.addDoneNode((AbstractNodeMapping)self, (DDiagramElement)listElement);
    }

    private static boolean isInstanceOf(EObject eObj, String typename) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.INSTANCE_OF_KEY);
        boolean result = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(eObj).eInstanceOf(eObj, typename);
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.INSTANCE_OF_KEY);
        return result;
    }
}

