/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.util;

import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sphinx.emf.ui.internal.Activator;
import org.eclipse.ui.IMemento;

public class ExtendedURIEditorInput
extends URIEditorInput {
    public ExtendedURIEditorInput(URI uri) {
        super(uri);
    }

    public ExtendedURIEditorInput(URI uri, String name) {
        super(uri, name);
    }

    public ExtendedURIEditorInput(IMemento memento) {
        super(memento);
    }

    protected String getBundleSymbolicName() {
        return Activator.getPlugin().getSymbolicName();
    }

    public String getToolTipText() {
        URI uri = this.getURI();
        if (uri.isPlatformResource()) {
            StringBuilder uriString = new StringBuilder();
            String path = uri.toPlatformString(true);
            uriString.append(new Path(path).makeRelative().toString());
            String uriFragment = uri.fragment();
            if (uriFragment != null) {
                uriString.append("#");
                uriString.append(uriFragment);
            }
            return uriString.toString();
        }
        return super.getToolTipText();
    }
}

