/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.viewers.filters;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ElementTypeViewerFilter
extends ViewerFilter {
    protected boolean accept;
    protected Set<Class<?>> types = new HashSet();

    public ElementTypeViewerFilter(Set<Class<?>> types, boolean accept) {
        this.types = types;
        this.accept = accept;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element != null) {
            Class<?> elementType = element.getClass();
            if (this.types.contains(elementType)) {
                return this.accept;
            }
            if (this.matchesSupertype(elementType)) {
                return this.accept;
            }
            return !this.accept;
        }
        return true;
    }

    protected boolean matchesSupertype(Class<?> elementType) {
        for (Class<?> type : this.types) {
            if (!type.isAssignableFrom(elementType)) continue;
            this.types.add(elementType);
            return true;
        }
        return false;
    }
}

