/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerTypesModel;

public class MarkerType {
    private MarkerTypesModel model;
    private String id;
    private String label;
    private String[] supertypeIds;

    public MarkerType(MarkerTypesModel model, String id, String label, String[] supertypeIds) {
        this.model = model;
        this.id = id;
        this.label = label;
        this.supertypeIds = supertypeIds;
    }

    public MarkerType[] getAllSupertypes() {
        ArrayList result = new ArrayList();
        this.getAllSupertypes(result);
        return result.toArray(new MarkerType[result.size()]);
    }

    private void getAllSupertypes(ArrayList result) {
        MarkerType[] supers;
        MarkerType[] markerTypeArray = supers = this.getSupertypes();
        int n = supers.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerType super1 = markerTypeArray[n2];
            MarkerType sup = super1;
            if (!result.contains(sup)) {
                result.add(sup);
                sup.getAllSupertypes(result);
            }
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public MarkerType[] getSubtypes() {
        MarkerType[] types = this.model.getTypes();
        ArrayList<MarkerType> result = new ArrayList<MarkerType>();
        MarkerType[] markerTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String[] supers;
            MarkerType type = markerTypeArray[n2];
            String[] stringArray = supers = type.getSupertypeIds();
            int n3 = supers.length;
            int n4 = 0;
            while (n4 < n3) {
                String super1 = stringArray[n4];
                if (super1.equals(this.id)) {
                    result.add(type);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new MarkerType[result.size()]);
    }

    public MarkerType[] getAllSubTypes() {
        ArrayList subTypes = new ArrayList();
        this.addSubTypes(subTypes, this);
        MarkerType[] subs = new MarkerType[subTypes.size()];
        subTypes.toArray(subs);
        return subs;
    }

    private void addSubTypes(List list, MarkerType superType) {
        MarkerType[] subTypes;
        MarkerType[] markerTypeArray = subTypes = superType.getSubtypes();
        int n = subTypes.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerType subType2 = markerTypeArray[n2];
            MarkerType subType = subType2;
            if (!list.contains(subType)) {
                list.add(subType);
            }
            this.addSubTypes(list, subType);
            ++n2;
        }
    }

    public String[] getSupertypeIds() {
        return this.supertypeIds;
    }

    public MarkerType[] getSupertypes() {
        ArrayList<MarkerType> result = new ArrayList<MarkerType>();
        String[] stringArray = this.supertypeIds;
        int n = this.supertypeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String supertypeId = stringArray[n2];
            MarkerType sup = this.model.getType(supertypeId);
            if (sup != null) {
                result.add(sup);
            }
            ++n2;
        }
        return result.toArray(new MarkerType[result.size()]);
    }

    public boolean isSubtypeOf(MarkerType superType) {
        if (this.id.equals(superType.getId())) {
            return true;
        }
        String[] stringArray = this.supertypeIds;
        int n = this.supertypeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String supertypeId = stringArray[n2];
            MarkerType sup = this.model.getType(supertypeId);
            if (sup != null && sup.isSubtypeOf(superType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MarkerType)) {
            return false;
        }
        return ((MarkerType)other).getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

