/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.domain.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.domain.factory.EditingDomainFactoryListenerRegistry;
import org.eclipse.sphinx.emf.domain.factory.ITransactionalEditingDomainFactoryListener;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.saving.IResourceSaveIndicator;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.domain.WorkspaceEditingDomainManager;
import org.eclipse.sphinx.emf.workspace.domain.factory.IExtendedTransactionalEditingDomainFactory;
import org.eclipse.sphinx.emf.workspace.domain.mapping.IWorkspaceEditingDomainMapping;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.internal.saving.ResourceSaveIndicator;
import org.eclipse.sphinx.platform.resources.AbstractResourceVisitor;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractWorkspaceEditingDomainMapping
implements IWorkspaceEditingDomainMapping,
ITransactionalEditingDomainFactoryListener {
    protected static final String EDITING_DOMAIN_ID_PREFIX = "editingDomainFor";
    protected Map<TransactionalEditingDomain, IResourceSaveIndicator> resourceSaveIndicators = new WeakHashMap<TransactionalEditingDomain, IResourceSaveIndicator>();
    protected Map<TransactionalEditingDomain, WorkspaceSynchronizer> modelWorkspaceSynchronizers = new WeakHashMap<TransactionalEditingDomain, WorkspaceSynchronizer>();
    protected ListenerList globalResourceSetListeners = new ListenerList();
    protected ListenerList globalOperationHistoryListeners = new ListenerList();

    public static String getDefaultEditingDomainId(Collection<IMetaModelDescriptor> mmDescriptors) {
        StringBuilder id = new StringBuilder(EDITING_DOMAIN_ID_PREFIX);
        for (IMetaModelDescriptor descriptor : mmDescriptors) {
            id.append("_");
            id.append(descriptor.getIdentifier());
        }
        return id.toString();
    }

    protected AbstractWorkspaceEditingDomainMapping() {
        EditingDomainFactoryListenerRegistry.INSTANCE.addListener(MetaModelDescriptorRegistry.ANY_MM, null, (ITransactionalEditingDomainFactoryListener)this, null);
    }

    protected TransactionalEditingDomain createEditingDomain(IExtendedTransactionalEditingDomainFactory factory, Collection<IMetaModelDescriptor> mmDescriptors) {
        Assert.isNotNull((Object)factory);
        TransactionalEditingDomain editingDomain = factory.createEditingDomain(mmDescriptors);
        String editingDomainId = this.getEditingDomainId(editingDomain, mmDescriptors);
        TransactionalEditingDomain.Registry.INSTANCE.add(editingDomainId, editingDomain);
        return editingDomain;
    }

    protected IResourceSaveIndicator createResourceSaveIndicator(TransactionalEditingDomain editingDomain) {
        return new ResourceSaveIndicator(editingDomain);
    }

    protected IExtendedTransactionalEditingDomainFactory getEditingDomainFactory(IMetaModelDescriptor mmDescriptor) {
        IExtendedTransactionalEditingDomainFactory factory = WorkspaceEditingDomainManager.INSTANCE.getEditingDomainFactory(mmDescriptor);
        if (factory == null) {
            throw new NullPointerException(NLS.bind((String)Messages.error_notFound_editingDomainFactory, (Object)mmDescriptor.getName()));
        }
        return factory;
    }

    protected String getEditingDomainId(TransactionalEditingDomain editingDomain, Collection<IMetaModelDescriptor> mmDescriptors) {
        return AbstractWorkspaceEditingDomainMapping.getDefaultEditingDomainId(mmDescriptors);
    }

    @Override
    public TransactionalEditingDomain getEditingDomain(IFile file) {
        IMetaModelDescriptor descriptor = MetaModelDescriptorRegistry.INSTANCE.getEffectiveDescriptor(file);
        if (descriptor != null) {
            return this.getEditingDomain(file.getParent(), descriptor);
        }
        return null;
    }

    @Override
    public final List<TransactionalEditingDomain> getEditingDomains(IContainer container) {
        if (container instanceof IFolder) {
            return this.getEditingDomains((IFolder)container);
        }
        if (container instanceof IProject) {
            return this.getEditingDomains((IProject)container);
        }
        if (container instanceof IWorkspaceRoot) {
            return this.getEditingDomains((IWorkspaceRoot)container);
        }
        return Collections.emptyList();
    }

    protected List<TransactionalEditingDomain> getEditingDomains(IFolder folder) {
        if (folder != null) {
            final ArrayList<TransactionalEditingDomain> editingDomains = new ArrayList<TransactionalEditingDomain>();
            try {
                folder.accept((IResourceVisitor)new AbstractResourceVisitor(){

                    public boolean doVisit(IResource resource) throws CoreException {
                        TransactionalEditingDomain editingDomain;
                        IFile file;
                        if (resource instanceof IFile && (file = (IFile)resource).isAccessible() && (editingDomain = AbstractWorkspaceEditingDomainMapping.this.getEditingDomain(file)) != null && !editingDomains.contains(editingDomain)) {
                            editingDomains.add(editingDomain);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            }
            return editingDomains;
        }
        return Collections.emptyList();
    }

    protected List<TransactionalEditingDomain> getEditingDomains(IProject project) {
        ArrayList<TransactionalEditingDomain> editingDomains = new ArrayList<TransactionalEditingDomain>();
        for (IModelDescriptor modelDescriptor : ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project)) {
            editingDomains.add(modelDescriptor.getEditingDomain());
        }
        return editingDomains;
    }

    protected List<TransactionalEditingDomain> getEditingDomains(IWorkspaceRoot workspaceRoot) {
        return this.getEditingDomains();
    }

    @Override
    public void addGlobalResourceSetListener(ResourceSetListener listener) {
        for (TransactionalEditingDomain editingDomain : this.getEditingDomains()) {
            editingDomain.addResourceSetListener(listener);
        }
        this.globalResourceSetListeners.add((Object)listener);
    }

    @Override
    public void removeGlobalResourceSetListener(ResourceSetListener listener) {
        for (TransactionalEditingDomain editingDomain : this.getEditingDomains()) {
            editingDomain.removeResourceSetListener(listener);
        }
        this.globalResourceSetListeners.remove((Object)listener);
    }

    @Override
    public void addGlobalOperationHistoryListener(IOperationHistoryListener listener) {
        for (TransactionalEditingDomain editingDomain : this.getEditingDomains()) {
            WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).addOperationHistoryListener(listener);
        }
        this.globalOperationHistoryListeners.add((Object)listener);
    }

    @Override
    public void removeGlobalOperationHistoryListener(IOperationHistoryListener listener) {
        for (TransactionalEditingDomain editingDomain : this.getEditingDomains()) {
            WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).removeOperationHistoryListener(listener);
        }
        this.globalOperationHistoryListeners.remove((Object)listener);
    }

    @Override
    public IResourceSaveIndicator getResourceSaveIndicator(TransactionalEditingDomain editingDomain) {
        return this.resourceSaveIndicators.get(editingDomain);
    }

    public void postCreateEditingDomain(TransactionalEditingDomain editingDomain) {
        Object listener;
        IResourceSaveIndicator resourceSaveIndicator = this.createResourceSaveIndicator(editingDomain);
        this.resourceSaveIndicators.put(editingDomain, resourceSaveIndicator);
        WorkspaceSynchronizer workspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, (WorkspaceSynchronizer.Delegate)resourceSaveIndicator);
        this.modelWorkspaceSynchronizers.put(editingDomain, workspaceSynchronizer);
        Object[] objectArray = this.globalResourceSetListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            editingDomain.addResourceSetListener((ResourceSetListener)listener);
            ++n2;
        }
        objectArray = this.globalOperationHistoryListeners.getListeners();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).addOperationHistoryListener((IOperationHistoryListener)listener);
            ++n2;
        }
    }

    public void preDisposeEditingDomain(TransactionalEditingDomain editingDomain) {
        Object listener;
        this.resourceSaveIndicators.remove(editingDomain);
        WorkspaceSynchronizer workspaceSynchronizer = this.modelWorkspaceSynchronizers.remove(editingDomain);
        if (workspaceSynchronizer != null) {
            workspaceSynchronizer.dispose();
        }
        Object[] objectArray = this.globalResourceSetListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            editingDomain.removeResourceSetListener((ResourceSetListener)listener);
            ++n2;
        }
        objectArray = this.globalOperationHistoryListeners.getListeners();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).removeOperationHistoryListener((IOperationHistoryListener)listener);
            ++n2;
        }
    }

    @Override
    public void dispose() {
        EditingDomainFactoryListenerRegistry.INSTANCE.removeListener((ITransactionalEditingDomainFactoryListener)this);
    }
}

