/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.resources;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.sphinx.platform.internal.Activator;
import org.eclipse.sphinx.platform.messages.PlatformMessages;
import org.eclipse.sphinx.platform.resources.MarkerDescriptor;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class MarkerJob
extends WorkspaceJob {
    public static final MarkerJob INSTANCE = new MarkerJob();
    protected Queue<MarkerTask> taskQueue = new ConcurrentLinkedQueue<MarkerTask>();

    protected MarkerJob() {
        super(PlatformMessages.job_updatingProblemMarkers);
        this.setSystem(true);
        this.setPriority(40);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        MarkerTask mt = null;
        while ((mt = this.taskQueue.poll()) != null) {
            try {
                mt.execute();
            }
            catch (CoreException ex) {
                if (!mt.resource.isAccessible() || !mt.resource.isSynchronized(0)) continue;
                PlatformLogUtil.logAsError(Activator.getDefault(), (Object)ex);
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCreateMarkerTask(IResource resource, String type, int severity, String message) {
        CreateMarkerTask cmt = new CreateMarkerTask(resource, type, severity, message);
        Queue<MarkerTask> queue = this.taskQueue;
        synchronized (queue) {
            this.taskQueue.add(cmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCreateMarkerTask(IResource resource, String type, Map<String, Object> attributes) {
        CreateMarkerTask cmt = new CreateMarkerTask(resource, type, attributes);
        Queue<MarkerTask> queue = this.taskQueue;
        synchronized (queue) {
            this.taskQueue.add(cmt);
        }
    }

    public void addCreateMarkerTask(IResource resource, MarkerDescriptor markerDescriptor) {
        this.addCreateMarkerTask(resource, markerDescriptor.getType(), markerDescriptor.getAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeleteMarkerTask(IResource resource, String type) {
        DeleteMarkerTask dmt = new DeleteMarkerTask(resource, type);
        Queue<MarkerTask> queue = this.taskQueue;
        synchronized (queue) {
            this.taskQueue.add(dmt);
        }
    }

    protected static class CreateMarkerTask
    extends MarkerTask {
        public CreateMarkerTask(IResource resource, String type, Map<String, Object> attributes) {
            super(resource, type, attributes);
        }

        public CreateMarkerTask(IResource resource, String type, int severity, String message) {
            super(resource, type);
            this.getAttributes().put("severity", severity);
            this.getAttributes().put("message", message);
        }

        @Override
        void execute() throws CoreException {
            IMarker marker = this.resource.createMarker(this.getType());
            marker.setAttributes(this.getAttributes());
        }
    }

    protected static class DeleteMarkerTask
    extends MarkerTask {
        public DeleteMarkerTask(IResource resource, String type) {
            super(resource, type);
        }

        @Override
        void execute() throws CoreException {
            this.resource.deleteMarkers(this.getType(), false, 0);
        }
    }

    protected static abstract class MarkerTask
    extends MarkerDescriptor {
        protected IResource resource;

        public MarkerTask(IResource resource, String type) {
            super(type);
            this.resource = resource;
        }

        public MarkerTask(IResource resource, String type, Map<String, Object> attributes) {
            super(type, attributes);
            this.resource = resource;
        }

        abstract void execute() throws CoreException;
    }
}

