/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.hummingbird20.ide.ui.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.sphinx.emf.edit.ExtendedItemPropertyDescriptor;
import org.eclipse.sphinx.examples.hummingbird20.common.Common20Package;
import org.eclipse.sphinx.examples.hummingbird20.ide.ui.providers.OutgoingConnectionsItemProvider;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.Component;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.Connection;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.InstanceModel20Package;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.edit.ConnectionItemProvider;
import org.eclipse.sphinx.examples.hummingbird20.typemodel.Interface;
import org.eclipse.sphinx.examples.hummingbird20.typemodel.Port;
import org.eclipse.sphinx.examples.hummingbird20.typemodel.edit.InterfaceItemProvider;

public class ExtendedConnectionItemProvider
extends ConnectionItemProvider {
    public ExtendedConnectionItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getFont(Object object) {
        return IItemFontProvider.ITALIC_FONT;
    }

    public Object getParent(Object object) {
        Object parent = super.getParent(object);
        if (((Component)parent).getOutgoingConnections().contains(object)) {
            return this.adapterFactory.adapt(parent, OutgoingConnectionsItemProvider.class);
        }
        return parent;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.remove(Common20Package.Literals.IDENTIFIABLE__DESCRIPTION);
            this.childrenFeatures.add(InstanceModel20Package.Literals.CONNECTION__SOURCE_PORT);
            this.childrenFeatures.add(InstanceModel20Package.Literals.CONNECTION__TARGET_COMPONENT);
        }
        return this.childrenFeatures;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Connection.class)) {
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            Port sourcePort = ((Connection)object).getSourcePort();
            if (sourcePort != null) {
                this.addRequiredInterface(sourcePort.getRequiredInterface(), this.getString("_UI_Port_requiredInterface_feature"));
            }
        }
        return this.itemPropertyDescriptors;
    }

    private void addRequiredInterface(Interface requiredInterface, final String featureName) {
        InterfaceItemProvider interfaceItemProvider = (InterfaceItemProvider)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory().adapt((Notifier)requiredInterface, IItemPropertySource.class);
        if (interfaceItemProvider != null) {
            List descriptors = interfaceItemProvider.getPropertyDescriptors((Object)requiredInterface);
            for (IItemPropertyDescriptor descriptor : descriptors) {
                this.itemPropertyDescriptors.add(new ItemPropertyDescriptorDecorator(requiredInterface, descriptor){

                    public String getCategory(Object thisObject) {
                        return featureName;
                    }

                    public String getId(Object thisObject) {
                        return String.valueOf(featureName) + this.getDisplayName(thisObject);
                    }
                });
            }
        }
    }

    protected void addSourcePortPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ExtendedItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Connection_sourcePort_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Connection_sourcePort_feature", "_UI_Connection_type"), (EStructuralFeature)InstanceModel20Package.Literals.CONNECTION__SOURCE_PORT, true, false, true, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                Connection connection = (Connection)object;
                Component sourceComponent = connection.getSourceComponent();
                if (sourceComponent == null || sourceComponent.getType() == null) {
                    return null;
                }
                Component targetComponent = connection.getTargetComponent();
                if (targetComponent == null || targetComponent.getType() == null) {
                    return null;
                }
                EList sourcePorts = sourceComponent.getType().getPorts();
                ArrayList<Port> availablePorts = new ArrayList<Port>();
                for (Port port : sourcePorts) {
                    if (targetComponent.getType().getProvidedInterfaces() == null || port.getRequiredInterface() == null || !targetComponent.getType().getProvidedInterfaces().contains((Object)port.getRequiredInterface())) continue;
                    availablePorts.add(port);
                }
                return availablePorts;
            }
        });
    }
}

