/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.wizards.pages;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.emf.workspace.ui.internal.messages.Messages;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ide.dialogs.PathVariableSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FileSystemSelectionArea;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.filesystem.FileSystemConfiguration;
import org.eclipse.ui.internal.ide.filesystem.FileSystemSupportRegistry;

public class CreateLinkedResourceGroup {
    private Listener listener;
    private String linkTarget = "";
    private String[] filterExtensions = new String[0];
    private int type;
    private FontMetrics fontMetrics;
    private Composite groupComposite;
    private Text linkTargetField;
    private Button browseButton;
    private Button variablesButton;
    private Label resolvedPathLabelText;
    private Label resolvedPathLabelData;
    private final IStringValue updatableResourceName;
    private String lastUpdatedValue;
    private FileSystemSelectionArea fileSystemSelectionArea;

    public CreateLinkedResourceGroup(int type, Listener listener, IStringValue updatableResourceName) {
        this.type = type;
        this.listener = listener;
        this.updatableResourceName = updatableResourceName;
        if (updatableResourceName != null) {
            this.lastUpdatedValue = updatableResourceName.getValue();
        }
    }

    public Composite createContents(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        this.groupComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.groupComposite.setLayout((Layout)layout);
        GridData gd = new GridData(784);
        gd.heightHint = 250;
        gd.widthHint = 250;
        this.groupComposite.setLayoutData((Object)gd);
        this.groupComposite.setFont(font);
        if (this.type == 1) {
            new Label(this.groupComposite, 4).setText(Messages.wizardNewLinkedFileCreationPage_targetFileLabel);
        } else {
            new Label(this.groupComposite, 4).setText(Messages.wizardNewLinkedFolderCreationPage_targetFolderLabel);
        }
        this.createLinkLocationGroup(this.groupComposite, true);
        return this.groupComposite;
    }

    private void createLinkLocationGroup(Composite locationGroup, boolean enabled) {
        Composite linkTargetGroup = new Composite(locationGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        linkTargetGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        linkTargetGroup.setLayoutData((Object)data);
        this.linkTargetField = new Text(linkTargetGroup, 2048);
        data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 2;
        this.linkTargetField.setLayoutData((Object)data);
        this.linkTargetField.setEnabled(enabled);
        this.linkTargetField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value;
                CreateLinkedResourceGroup.this.linkTarget = CreateLinkedResourceGroup.this.linkTargetField.getText();
                CreateLinkedResourceGroup.this.resolveVariable();
                if (CreateLinkedResourceGroup.this.updatableResourceName != null && ((value = CreateLinkedResourceGroup.this.updatableResourceName.getValue()) == null || value.equals("") || value.equals(CreateLinkedResourceGroup.this.lastUpdatedValue))) {
                    Path linkTargetPath = new Path(CreateLinkedResourceGroup.this.linkTarget);
                    String lastSegment = linkTargetPath.lastSegment();
                    CreateLinkedResourceGroup.this.lastUpdatedValue = lastSegment = lastSegment == null ? "" : lastSegment;
                    CreateLinkedResourceGroup.this.updatableResourceName.setValue(lastSegment);
                }
                if (CreateLinkedResourceGroup.this.listener != null) {
                    CreateLinkedResourceGroup.this.listener.handleEvent(new Event());
                }
            }
        });
        this.browseButton = new Button(linkTargetGroup, 8);
        this.browseButton.setText(IDEWorkbenchMessages.CreateLinkedResourceGroup_browseButton);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateLinkedResourceGroup.this.handleLinkTargetBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        this.setButtonLayoutData(this.browseButton);
        this.variablesButton = new Button(linkTargetGroup, 8);
        this.variablesButton.setText(IDEWorkbenchMessages.CreateLinkedResourceGroup_variablesButton);
        this.variablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateLinkedResourceGroup.this.handleVariablesButtonPressed();
            }
        });
        this.variablesButton.setEnabled(enabled);
        this.setButtonLayoutData(this.variablesButton);
        this.createFileSystemSelection(linkTargetGroup, enabled);
        this.createResolvedPathGroup(locationGroup, 0);
        if (this.linkTarget != null && this.linkTarget.length() > 0) {
            this.linkTargetField.setText(this.linkTarget);
        }
    }

    private void createFileSystemSelection(Composite composite, boolean enabled) {
        if (FileSystemSupportRegistry.getInstance().hasOneFileSystem()) {
            return;
        }
        this.fileSystemSelectionArea = new FileSystemSelectionArea();
        this.fileSystemSelectionArea.createContents(composite);
        this.fileSystemSelectionArea.setEnabled(enabled);
    }

    private void createResolvedPathGroup(Composite locationGroup, int indent) {
        Composite resolvedPathGroup = new Composite(locationGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        resolvedPathGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalIndent = indent;
        resolvedPathGroup.setLayoutData((Object)data);
        this.resolvedPathLabelText = new Label(resolvedPathGroup, 4);
        this.resolvedPathLabelText.setText(IDEWorkbenchMessages.CreateLinkedResourceGroup_resolvedPathLabel);
        this.resolvedPathLabelText.setVisible(false);
        this.resolvedPathLabelData = new Label(resolvedPathGroup, 4);
        data = new GridData(768);
        this.resolvedPathLabelData.setLayoutData((Object)data);
        this.resolvedPathLabelData.setVisible(false);
    }

    private IStatus createStatus(int severity, String message) {
        return new Status(severity, Activator.getPlugin().getBundle().getSymbolicName(), severity, message, null);
    }

    public void dispose() {
        if (this.groupComposite != null && !this.groupComposite.isDisposed()) {
            this.groupComposite.dispose();
        }
    }

    public URI getLinkTargetURI() {
        FileSystemConfiguration configuration;
        if (!this.linkTarget.startsWith("/")) {
            IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
            try {
                URI path = new URI(this.linkTarget.replace(File.separatorChar, '/'));
                URI resolved = pathVariableManager.resolveURI(path);
                if (path != resolved) {
                    return path;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if ((configuration = this.getSelectedConfiguration()) == null) {
            return URIUtil.toURI((String)this.linkTarget);
        }
        return configuration.getContributor().getURI(this.linkTarget);
    }

    private void handleLinkTargetBrowseButtonPressed() {
        boolean isDefault;
        IFileStore store = null;
        String selection = null;
        FileSystemConfiguration config = this.getSelectedConfiguration();
        boolean bl = isDefault = config == null || FileSystemSupportRegistry.getInstance().getDefaultConfiguration().equals(config);
        if (this.linkTarget.length() > 0 && !(store = IDEResourceInfoUtils.getFileStore((String)this.linkTarget)).fetchInfo().exists()) {
            store = null;
        }
        if (this.type == 1) {
            if (isDefault) {
                FileDialog dialog = new FileDialog(this.linkTargetField.getShell());
                dialog.setText(IDEWorkbenchMessages.CreateLinkedResourceGroup_targetSelectionTitle);
                if (store != null) {
                    if (store.fetchInfo().isDirectory()) {
                        dialog.setFilterPath(this.linkTarget);
                    } else {
                        dialog.setFileName(this.linkTarget);
                    }
                } else {
                    dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
                }
                if (this.filterExtensions != null && this.filterExtensions.length != 0) {
                    dialog.setFilterExtensions(this.filterExtensions);
                }
                selection = dialog.open();
            } else {
                URI uri = config.getContributor().browseFileSystem(this.linkTarget, this.linkTargetField.getShell());
                if (uri != null) {
                    selection = uri.toString();
                }
            }
        } else {
            String filterPath = null;
            if (store != null) {
                IFileStore path = store;
                if (!store.fetchInfo().isDirectory()) {
                    path = store.getParent();
                }
                if (path != null) {
                    filterPath = store.toString();
                }
            }
            if (isDefault) {
                DirectoryDialog dialog = new DirectoryDialog(this.linkTargetField.getShell());
                dialog.setMessage(IDEWorkbenchMessages.CreateLinkedResourceGroup_targetSelectionLabel);
                if (filterPath != null) {
                    dialog.setFilterPath(filterPath);
                } else {
                    dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
                }
                selection = dialog.open();
            } else {
                URI uri;
                String initialPath = "";
                if (filterPath != null) {
                    initialPath = filterPath;
                }
                if ((uri = config.getContributor().browseFileSystem(initialPath, this.linkTargetField.getShell())) != null) {
                    selection = uri.toString();
                }
            }
        }
        if (selection != null) {
            this.linkTargetField.setText(selection);
        }
    }

    private FileSystemConfiguration getSelectedConfiguration() {
        if (this.fileSystemSelectionArea == null) {
            return null;
        }
        return this.fileSystemSelectionArea.getSelectedConfiguration();
    }

    private void handleVariablesButtonPressed() {
        String[] variableNames;
        PathVariableSelectionDialog dialog;
        int variableTypes = 2;
        if (this.type == 1) {
            variableTypes |= 1;
        }
        if ((dialog = new PathVariableSelectionDialog(this.linkTargetField.getShell(), variableTypes)).open() == 0 && (variableNames = (String[])dialog.getResult()) != null && variableNames.length == 1) {
            this.linkTargetField.setText(variableNames[0]);
        }
    }

    protected void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private void resolveVariable() {
        try {
            URI uri = new URI(this.linkTarget);
            IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
            URI resolvedURI = pathVariableManager.resolveURI(uri);
            if (uri.equals(resolvedURI)) {
                this.resolvedPathLabelText.setVisible(false);
                this.resolvedPathLabelData.setVisible(false);
            } else {
                this.resolvedPathLabelText.setVisible(true);
                this.resolvedPathLabelData.setVisible(true);
                IPath resolvedPath = URIUtil.toPath((URI)resolvedURI);
                this.resolvedPathLabelData.setText(resolvedPath.toOSString());
            }
        }
        catch (URISyntaxException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
        }
    }

    private GridData setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return data;
    }

    public void setLinkTarget(String target) {
        this.linkTarget = target;
        if (this.linkTargetField != null && !this.linkTargetField.isDisposed()) {
            this.linkTargetField.setText(target);
        }
    }

    private IStatus validateFileType(IFileInfo linkTargetFile) {
        if (this.type == 1 && linkTargetFile.isDirectory()) {
            return this.createStatus(4, IDEWorkbenchMessages.CreateLinkedResourceGroup_linkTargetNotFile);
        }
        if (this.type == 2 && !linkTargetFile.isDirectory()) {
            return this.createStatus(4, IDEWorkbenchMessages.CreateLinkedResourceGroup_linkTargetNotFolder);
        }
        return Status.OK_STATUS;
    }

    public IStatus validateLinkLocation(IResource linkHandle) {
        Path location;
        if (this.linkTargetField == null || this.linkTargetField.isDisposed()) {
            return Status.OK_STATUS;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        FileSystemConfiguration configuration = this.getSelectedConfiguration();
        if ((configuration == null || "file".equals(configuration.getScheme())) && (location = new Path(this.linkTarget)).isUNC()) {
            return this.createStatus(2, IDEWorkbenchMessages.CreateLinkedResourceGroup_unableToValidateLinkTarget);
        }
        URI locationURI = this.getLinkTargetURI();
        if (locationURI == null) {
            return this.createStatus(2, IDEWorkbenchMessages.CreateLinkedResourceGroup_unableToValidateLinkTarget);
        }
        IStatus locationStatus = workspace.validateLinkLocationURI(linkHandle, locationURI);
        if (locationStatus.getSeverity() == 4 || this.linkTarget.trim().equals("")) {
            return locationStatus;
        }
        URI resolved = workspace.getPathVariableManager().resolveURI(locationURI);
        IFileInfo linkTargetFile = IDEResourceInfoUtils.getFileInfo((URI)resolved);
        if (linkTargetFile != null && linkTargetFile.exists()) {
            IStatus fileTypeStatus = this.validateFileType(linkTargetFile);
            if (!fileTypeStatus.isOK()) {
                return fileTypeStatus;
            }
        } else if (locationStatus.isOK()) {
            return this.createStatus(2, IDEWorkbenchMessages.CreateLinkedResourceGroup_linkTargetNonExistent);
        }
        return locationStatus;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }

    public static interface IStringValue {
        public void setValue(String var1);

        public String getValue();
    }
}

