/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.fields.IFieldListener;
import org.eclipse.sphinx.platform.ui.fields.SelectionButtonField;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.sphinx.xtendxpand.outlet.ExtendedOutlet;
import org.eclipse.sphinx.xtendxpand.ui.internal.Activator;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.sphinx.xtendxpand.ui.outlet.providers.OutletProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.xpand2.output.Outlet;

public class EditOutletDialog
extends StatusDialog {
    private ExtendedOutlet outlet;
    private OutletProvider outletProvider;
    private String initialOutletName;
    private boolean editableName;
    private Text nameText;
    private Text locationText;
    private SelectionButtonField protectedRegionField;
    private Button workspaceBrowse;
    private Button fileBrowse;
    private Button variables;
    protected Listener listener = new Listener();

    public EditOutletDialog(Shell parent, ExtendedOutlet outlet, boolean edit, boolean editableName, OutletProvider outletProvider) {
        super(parent);
        String title = edit ? Messages.title_editOutletDialog : Messages.title_newOutletDialog;
        this.setTitle(title);
        this.outlet = outlet;
        this.editableName = editableName;
        this.outletProvider = outletProvider;
        this.initialOutletName = outlet.getName();
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        parent.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        parent.setLayoutData((Object)layoutData);
        this.createLabel(parent, Messages.label_name, 1);
        this.nameText = this.createText(parent, 768, 1);
        this.nameText.setEditable(this.editableName);
        if (this.outlet.getName() != null) {
            this.nameText.setText(this.outlet.getName());
        }
        if (this.editableName) {
            this.nameText.addModifyListener((ModifyListener)this.listener);
        } else if (this.outlet.getName() == null) {
            this.nameText.setText(Messages.label_default);
        }
        this.createLabel(parent, Messages.label_location, 1);
        this.locationText = this.createText(parent, 768, 1);
        if (this.outlet.getPathExpression() != null) {
            this.locationText.setText(this.outlet.getPathExpression());
        }
        this.locationText.addModifyListener((ModifyListener)this.listener);
        this.createLabel(parent, "", 1);
        Composite buttonsParent = new Composite(parent, 0);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 3;
        buttonsParent.setLayout((Layout)blayout);
        GridData bLayoutData = new GridData(128);
        buttonsParent.setLayoutData((Object)bLayoutData);
        this.workspaceBrowse = this.createPushButton(buttonsParent, Messages.label_workspaceBrowse, null);
        this.workspaceBrowse.addSelectionListener((SelectionListener)this.listener);
        this.fileBrowse = this.createPushButton(buttonsParent, Messages.label_fileSystemBrowse, null);
        this.fileBrowse.addSelectionListener((SelectionListener)this.listener);
        this.variables = this.createPushButton(buttonsParent, Messages.label_variablesBrowse, null);
        this.variables.addSelectionListener((SelectionListener)this.listener);
        this.protectedRegionField = new SelectionButtonField(32);
        this.protectedRegionField.setLabelText(Messages.label_useAsProtectedRegion);
        this.protectedRegionField.fillIntoGrid(parent, 3);
        this.protectedRegionField.setSelectionWithoutEvent(this.outlet.isProtectedRegion());
        this.protectedRegionField.addFieldListener((IFieldListener)this.listener);
        return parent;
    }

    protected void handleNameChanged() {
        IStatus nameStatus = this.validateOutletName();
        if (nameStatus.isOK()) {
            this.outlet.setName(this.nameText.getText());
        }
        this.updateStatus(this.validateOutletInputs());
    }

    protected void handleLocationChanged() {
        IStatus locationStatus = this.validateOutletLocation();
        if (locationStatus.isOK()) {
            String location = this.locationText.getText();
            this.outlet.setPathExpression(location, this.outletProvider.getProject());
        }
        this.updateStatus(this.validateOutletInputs());
    }

    protected void handleBrowseFileSystem() {
        String filePath = this.locationText.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        filePath = dialog.open();
        if (filePath != null) {
            this.locationText.setText(filePath);
        }
    }

    protected void handleBrowseWorkspace() {
        IResource resource;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(Messages.title_containerSelection);
        dialog.setMessage(Messages.msg_containerSelection);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (this.outletProvider.getProject() != null) {
            dialog.setInitialSelection((Object)this.outletProvider.getProject());
        }
        if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
            IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
            String location = resource.getProject() == this.outletProvider.getProject() ? String.valueOf(variableManager.generateVariableExpression(ExtendedOutlet.VARIABLE_PROJECT_LOC, null)) + '/' + resource.getProjectRelativePath().toString() : String.valueOf(variableManager.generateVariableExpression(ExtendedOutlet.VARIABLE_WORKSPACE_LOC, null)) + resource.getFullPath().toString();
            this.locationText.setText(location);
        }
    }

    protected void handleInsertVariable() {
        String variableName;
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if ((dialog.open() == 0 || dialog.getResult().length == 1) && (variableName = dialog.getVariableExpression()) != null) {
            this.locationText.setText(variableName);
        }
    }

    protected IStatus validateOutletInputs() {
        IStatus status = this.validateOutletName();
        if (!status.isOK()) {
            return status;
        }
        return this.validateOutletLocation();
    }

    protected IStatus validateOutletName() {
        String name = this.nameText.getText();
        if (name.trim().length() == 0) {
            return StatusUtil.createStatus((int)4, (int)4, (String)Messages.msg_outletNameEmptyValidationError, (String)Activator.getPlugin().getSymbolicName(), null);
        }
        if (name.equals(this.initialOutletName)) {
            return Status.OK_STATUS;
        }
        for (Outlet outlet : this.outletProvider.getOutlets()) {
            if (!name.equals(outlet.getName())) continue;
            return StatusUtil.createStatus((int)4, (int)4, (String)Messages.msg_outletNameExistValidationError, (String)Activator.getPlugin().getSymbolicName(), null);
        }
        return Status.OK_STATUS;
    }

    protected IStatus validateOutletLocation() {
        String location = this.locationText.getText();
        if (location.trim().length() == 0 || !Path.ROOT.isValidPath(location)) {
            return StatusUtil.createStatus((int)4, (int)4, (String)Messages.msg_outletLocationEmptyValidationError, (String)Activator.getPlugin().getSymbolicName(), null);
        }
        return Status.OK_STATUS;
    }

    private Label createLabel(Composite parent, String text, int hspan) {
        Label label = new Label(parent, 0);
        label.setFont(parent.getFont());
        label.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        gd.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        this.setButtonDimensionHint(button);
        return button;
    }

    private Text createText(Composite parent, int style, int hspan) {
        Text text = new Text(parent, 2048);
        text.setFont(parent.getFont());
        GridData gd = new GridData(style);
        gd.horizontalSpan = hspan;
        text.setLayoutData((Object)gd);
        return text;
    }

    private void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = this.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    public ExtendedOutlet getOutlet() {
        return this.outlet;
    }

    public void create() {
        super.create();
        this.updateButtonsEnableState(this.validateOutletInputs());
    }

    private int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    class Listener
    extends SelectionAdapter
    implements ModifyListener,
    IFieldListener {
        Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == EditOutletDialog.this.fileBrowse) {
                EditOutletDialog.this.handleBrowseFileSystem();
            } else if (source == EditOutletDialog.this.workspaceBrowse) {
                EditOutletDialog.this.handleBrowseWorkspace();
            } else if (source == EditOutletDialog.this.variables) {
                EditOutletDialog.this.handleInsertVariable();
            }
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (source == EditOutletDialog.this.nameText) {
                EditOutletDialog.this.handleNameChanged();
            } else if (source == EditOutletDialog.this.locationText) {
                EditOutletDialog.this.handleLocationChanged();
            }
        }

        public void dialogFieldChanged(IField field) {
            if (field == EditOutletDialog.this.protectedRegionField) {
                EditOutletDialog.this.outlet.setProtectedRegion(EditOutletDialog.this.protectedRegionField.isSelected());
            }
        }
    }
}

