/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.util;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CheckValidationContextHelper {
    protected Map<Object, Object> context;

    public CheckValidationContextHelper(Map<Object, Object> context) {
        this.context = context;
    }

    public Set<String> getConstraintCategories() {
        Object categories;
        if (this.context != null && (categories = this.context.get("CATEGORIES")) instanceof Set) {
            Set castedCategories = (Set)categories;
            return castedCategories;
        }
        return Collections.emptySet();
    }

    public boolean areIntrinsicModelIntegrityConstraintsEnabled() {
        Object enabled;
        if (this.context != null && (enabled = this.context.get("ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS")) instanceof Boolean) {
            return (Boolean)enabled;
        }
        return false;
    }

    public void addEnableIntrinsicModelIntegrityConstraintsOption(Boolean enabled) {
        if (this.context != null && enabled != null) {
            this.context.put("ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS", enabled);
        }
    }

    public Boolean removeEnableIntrinsicModelIntegrityConstraintsOption() {
        Object enabled;
        if (this.context != null && (enabled = this.context.remove("ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS")) instanceof Boolean) {
            return (Boolean)enabled;
        }
        return null;
    }

    public IProgressMonitor getProgressMonitor() {
        Object monitor;
        if (this.context != null && (monitor = this.context.get("PROGRESS_MONITOR")) instanceof IProgressMonitor) {
            return (IProgressMonitor)monitor;
        }
        return new NullProgressMonitor();
    }

    public void addProgressMonitorOption(IProgressMonitor monitor) {
        if (this.context != null && monitor != null) {
            this.context.put("PROGRESS_MONITOR", monitor);
        }
    }

    public IProgressMonitor removeProgressMonitorOption() {
        Object monitor;
        if (this.context != null && (monitor = this.context.remove("PROGRESS_MONITOR")) instanceof IProgressMonitor) {
            return (IProgressMonitor)monitor;
        }
        return null;
    }
}

