/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading.operations;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.loading.operations.AbstractProjectLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IProjectReloadOperation;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;

public class DefaultProjectReloadOperation
extends AbstractProjectLoadOperation
implements IProjectReloadOperation {
    public DefaultProjectReloadOperation(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor) {
        super(mmDescriptor != null ? Messages.job_reloadingModel : Messages.job_reloadingModels, projects, includeReferencedProjects, mmDescriptor);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.runReloadProjects(this.getProjects(), this.isIncludeReferencedProjects(), this.getMetaModelDescriptor(), monitor);
    }

    protected void runReloadProjects(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(projects);
        for (IProject project : projects) {
            String taskName = mmDescriptor != null ? NLS.bind((String)Messages.task_reloadingModelInProject, (Object)mmDescriptor.getName(), (Object)project.getName()) : NLS.bind((String)Messages.task_reloadingModelsInProject, (Object)project.getName());
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)100);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            Collection files = ExtendedPlatform.getAllFiles((IProject)project, (boolean)includeReferencedProjects);
            progress.worked(1);
            if (files.size() == 0) {
                progress.done();
                return;
            }
            this.runDetectAndReloadModelFiles(files, mmDescriptor, ExtendedPlatform.isRootProject((IProject)project), (IProgressMonitor)progress.newChild(99));
        }
    }
}

