/**
 * <copyright>
 * 
 * Copyright (c) 2014-2016 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 *     itemis - [503063] Provide launching support for Sphinx Workflows
 *     itemis - [506671] Add support for specifying and injecting user-defined arguments for workflows through workflow launch configurations
 * 
 * </copyright>
 */
package org.eclipse.sphinx.examples.workflows.simple.xtend;

import java.util.List;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.emf.mwe2.runtime.workflow.Workflow;
import org.eclipse.sphinx.examples.workflows.simple.java.SimpleJavaWorkflowComponent;
import org.eclipse.sphinx.examples.workflows.simple.xtend.SimpleXtendWorkflowComponent;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class SimpleXtendWorkflow extends Workflow {
  public SimpleXtendWorkflow() {
    List<IWorkflowComponent> _children = this.getChildren();
    SimpleJavaWorkflowComponent _simpleJavaWorkflowComponent = new SimpleJavaWorkflowComponent();
    _children.add(_simpleJavaWorkflowComponent);
    List<IWorkflowComponent> _children_1 = this.getChildren();
    SimpleXtendWorkflowComponent _simpleXtendWorkflowComponent = new SimpleXtendWorkflowComponent();
    _children_1.add(_simpleXtendWorkflowComponent);
  }
  
  @Override
  public void preInvoke() {
    InputOutput.<String>println("Running simple Xtend-based workflow");
    super.preInvoke();
  }
}
