/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.rtool;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.rtools.Messages;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.ui.ElementNameProvider;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.statet.r.core.model.IRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.ui.editors.IRSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class RElementNameVariableResolver
implements IDynamicVariableResolver {
    public static final String R_OBJECT_NAME_NAME = "r_object_name";

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        IWorkbenchPart part = UIAccess.getActiveWorkbenchPart((boolean)false);
        if (part != null) {
            ISelection selection;
            IWorkbenchPartSite site = part.getSite();
            ISelectionProvider selectionProvider = site.getSelectionProvider();
            if (selectionProvider != null && (selection = selectionProvider.getSelection()) instanceof IStructuredSelection) {
                Object element;
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (selection.isEmpty()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)Messages.Variable_error_EmptySelection_message, (Object)R_OBJECT_NAME_NAME)));
                }
                if (structuredSelection.size() == 1 && (element = structuredSelection.getFirstElement()) instanceof IRElement) {
                    Object elementName = selection instanceof ElementNameProvider ? ((ElementNameProvider)selection).getElementName(selection instanceof ITreeSelection ? ((ITreeSelection)selection).getPaths()[0] : element) : ((IRElement)element).getElementName();
                    return this.checkName((ElementName)elementName);
                }
                IModelElement[] elements = LTKSelectionUtils.getSelectedElements((IStructuredSelection)((IStructuredSelection)selection));
                if (elements != null && elements.length == 1 && elements[0].getModelTypeId() == "R") {
                    return this.checkName(elements[0].getElementName());
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)Messages.Variable_error_NoSingleRElement_message, (Object)R_OBJECT_NAME_NAME)));
            }
            ISourceEditor editor = (ISourceEditor)part.getAdapter(ISourceEditor.class);
            if (editor instanceof IRSourceEditor) {
                try {
                    IRSourceEditor rEditor = (IRSourceEditor)editor;
                    Point range = rEditor.getViewer().getSelectedRange();
                    String contentType = TextUtils.getContentType((IDocument)rEditor.getViewer().getDocument(), (IDocContentSections)rEditor.getDocumentContentInfo(), (int)range.x, (range.y == 0 ? 1 : 0) != 0);
                    RAssistInvocationContext context = new RAssistInvocationContext(rEditor, (IRegion)new Region(range.x, range.y), contentType, null, null);
                    return this.checkName((ElementName)context.getNameSelection());
                }
                catch (BadLocationException | BadPartitioningException throwable) {
                    // empty catch block
                }
            }
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)Messages.Variable_error_NoSingleRElement_message, (Object)R_OBJECT_NAME_NAME)));
    }

    private String checkName(ElementName elementName) throws CoreException {
        String name;
        if (elementName instanceof RElementName && (name = ((RElementName)elementName).getDisplayName(3)) != null) {
            return name;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)Messages.Variable_error_InvalidObject_QualifiedName_message, (Object)R_OBJECT_NAME_NAME)));
    }
}

