/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core.conversion;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class ChainedConverter
implements IConverter {
    private final Object fromType;
    private final Object toType;
    private final ImList<IConverter> converters;

    public ChainedConverter(ImList<IConverter> converters) {
        if (converters.isEmpty()) {
            throw new IllegalArgumentException("converters.size= 0");
        }
        this.converters = converters;
        this.fromType = ((IConverter)converters.get(0)).getFromType();
        this.toType = ((IConverter)converters.get(converters.size() - 1)).getToType();
    }

    public Object getFromType() {
        return this.fromType;
    }

    public Object getToType() {
        return this.toType;
    }

    @NonNullByDefault(value={})
    public Object convert(Object fromObject) {
        for (IConverter converter : this.converters) {
            fromObject = converter.convert(fromObject);
        }
        return fromObject;
    }
}

