/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.dialogs;

import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Geometry;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

@NonNullByDefault
public class DialogUtils {
    public static final int HISTORY_MAX = 25;
    private static final String[] EMPTY_ARRAY_SETTING = new String[0];

    public static IDialogSettings getDialogSettings(AbstractUIPlugin plugin, String dialogId) {
        String sectionName = dialogId;
        IDialogSettings settings = plugin.getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    public static IDialogSettings getSection(IDialogSettings settings, String sectionName) {
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    public static void saveHistorySettings(IDialogSettings settings, String key, String newItem) {
        String[] items = DialogUtils.combineHistoryItems(settings.getArray(key), newItem);
        settings.put(key, items);
    }

    public static String[] combineHistoryItems(String[] existingItems, String newItem) {
        LinkedHashSet<String> history = new LinkedHashSet<String>(25);
        if (newItem != null && newItem.length() > 0) {
            history.add(newItem);
        }
        if (existingItems != null) {
            int i = 0;
            while (i < existingItems.length && history.size() < 25) {
                history.add(existingItems[i]);
                ++i;
            }
        }
        return history.toArray(new String[history.size()]);
    }

    public static String[] noNull(String @Nullable [] array) {
        return array != null ? array : EMPTY_ARRAY_SETTING;
    }

    public static void setEnabled(List<? extends Control> controls, @Nullable List<? extends Control> exceptions, boolean enable) {
        for (Control control : controls) {
            Composite c;
            Control[] children;
            if (exceptions != null && exceptions.contains(control)) continue;
            control.setEnabled(enable);
            if (!(control instanceof Composite) || (children = (c = (Composite)control).getChildren()).length <= 0) continue;
            DialogUtils.setEnabled(children, exceptions, enable);
        }
    }

    public static void setEnabled(Control[] controls, @Nullable List<? extends Control> exceptions, boolean enable) {
        DialogUtils.setEnabled((List<? extends Control>)ImCollections.newList((Object[])controls), exceptions, enable);
    }

    public static void setEnabled(Control control, @Nullable List<? extends Control> exceptions, boolean enable) {
        DialogUtils.setEnabled((List<? extends Control>)ImCollections.newList((Object)control), exceptions, enable);
    }

    public static void setVisible(List<? extends Control> controls, @Nullable List<? extends Control> exceptions, boolean enable) {
        for (Control control : controls) {
            Composite c;
            Control[] children;
            if (exceptions != null && exceptions.contains(control)) continue;
            control.setVisible(enable);
            if (!(control instanceof Composite) || (children = (c = (Composite)control).getChildren()).length <= 0) continue;
            DialogUtils.setVisible(children, exceptions, enable);
        }
    }

    public static void setVisible(Control[] controls, @Nullable List<? extends Control> exceptions, boolean enable) {
        DialogUtils.setVisible((List<? extends Control>)ImCollections.newList((Object[])controls), exceptions, enable);
    }

    public static void setVisible(Control control, @Nullable List<? extends Control> exceptions, boolean enable) {
        DialogUtils.setVisible((List<? extends Control>)ImCollections.newList((Object)control), exceptions, enable);
    }

    public static Monitor getClosestMonitor(Display toSearch, Rectangle rectangle) {
        int closest = Integer.MAX_VALUE;
        Point toFind = Geometry.centerPoint((Rectangle)rectangle);
        Monitor[] monitors = toSearch.getMonitors();
        Monitor result = monitors[0];
        int idx = 0;
        while (idx < monitors.length) {
            Monitor current = monitors[idx];
            Rectangle clientArea = current.getClientArea();
            if (clientArea.contains(toFind)) {
                return current;
            }
            int distance = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)clientArea), (Point)toFind);
            if (distance < closest) {
                closest = distance;
                result = current;
            }
            ++idx;
        }
        return result;
    }

    private DialogUtils() {
    }
}

