/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.ui;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.docmlet.base.ui.DocBaseUIResources;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.ltk.model.core.elements.IEmbeddedForeignElement;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.ui.IElementLabelProvider;
import org.eclipse.swt.graphics.Image;

public class WikitextLabelProvider
extends StyledCellLabelProvider
implements IElementLabelProvider,
ILabelProvider {
    private DocBaseUIResources docBaseResources = DocBaseUIResources.INSTANCE;

    public void dispose() {
        super.dispose();
        this.docBaseResources = null;
    }

    public Image getImage(Object element) {
        if (element instanceof IModelElement) {
            return this.getImage((IModelElement)element);
        }
        if (element instanceof WikitextNameAccess) {
            return this.getImage(element);
        }
        return null;
    }

    public Image getImage(IModelElement element) {
        switch (element.getElementType() & 0xFFF) {
            case 1040: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Preamble");
            }
            case 1057: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H1");
            }
            case 1058: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H2");
            }
            case 1059: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H3");
            }
            case 1060: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H4");
            }
            case 1061: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H5");
            }
            case 1062: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H6");
            }
            case 2048: {
                ISourceStructElement foreignElement = ((IEmbeddedForeignElement)element).getForeignElement();
                return foreignElement != null ? this.getEmbeddedForeignImage((IModelElement)foreignElement) : null;
            }
        }
        return null;
    }

    protected Image getDocBaseImage(String imageId) {
        return this.docBaseResources.getImage(imageId);
    }

    protected Image getEmbeddedForeignImage(IModelElement element) {
        if (element.getModelTypeId() == "Yaml") {
            return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Preamble");
        }
        return null;
    }

    public Image getImage(WikitextNameAccess access) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IModelElement) {
            return this.getText((IModelElement)element);
        }
        if (element instanceof WikitextNameAccess) {
            return this.getText(element);
        }
        return null;
    }

    public String getText(IModelElement element) {
        return element.getElementName().getDisplayName();
    }

    public String getText(WikitextNameAccess access) {
        return access.getDisplayName();
    }

    public StyledString getStyledText(IModelElement element) {
        return new StyledString(element.getElementName().getDisplayName());
    }

    public void update(ViewerCell cell) {
        Object cellElement = cell.getElement();
        if (cellElement instanceof IModelElement) {
            IModelElement element = (IModelElement)cellElement;
            cell.setImage(this.getImage(element));
            StyledString styledText = this.getStyledText(element);
            cell.setText(styledText.getString());
            cell.setStyleRanges(styledText.getStyleRanges());
            super.update(cell);
        } else {
            cell.setImage(null);
            cell.setText(cellElement.toString());
            cell.setStyleRanges(null);
            super.update(cell);
        }
    }
}

