/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.io;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.statet.ecommons.io.FileValidator;
import org.eclipse.statet.ecommons.variables.core.ObservableVariable;

public class ObservableFileValidator
extends FileValidator {
    private final Realm realm;
    private IChangeListener observableListener;
    private ResourceObservableValue resourceObservable;
    private FileStoreObservableValue fileStoreObservable;

    public ObservableFileValidator(Realm realm) {
        this.realm = realm;
    }

    @Override
    void checkVariable(IStringVariable variable) {
        if (variable instanceof ObservableVariable) {
            if (this.observableListener == null) {
                this.observableListener = new IChangeListener(){

                    public void handleChange(ChangeEvent event) {
                        ObservableFileValidator.this.updateVariableResolution();
                    }
                };
            }
            ((ObservableVariable)variable).addChangeListener(this.observableListener);
        }
    }

    @Override
    protected void setStatus(IStatus status) {
        super.setStatus(status);
        if (this.resourceObservable != null) {
            this.resourceObservable.update(this.getWorkspaceResource());
        }
        if (this.fileStoreObservable != null) {
            this.fileStoreObservable.update(this.getFileStore());
        }
    }

    public IObservableValue<IResource> getWorkspaceResourceObservable() {
        if (this.resourceObservable == null) {
            this.resourceObservable = new ResourceObservableValue(this.realm);
            this.resourceObservable.update(this.getWorkspaceResource());
        }
        return this.resourceObservable;
    }

    public IObservableValue<IFileStore> getFileStoreObservable() {
        if (this.resourceObservable == null) {
            this.fileStoreObservable = new FileStoreObservableValue(this.realm);
            this.fileStoreObservable.update(this.getFileStore());
        }
        return this.fileStoreObservable;
    }

    private class FileStoreObservableValue
    extends AbstractObservableValue<IFileStore> {
        private IFileStore value;

        public FileStoreObservableValue(Realm realm) {
            super(realm);
        }

        public Object getValueType() {
            return IFileStore.class;
        }

        protected IFileStore doGetValue() {
            return this.value;
        }

        protected void doSetValue(IFileStore value) {
            ObservableFileValidator.this.setExplicit(value);
            ObservableFileValidator.this.checkExplicit();
        }

        void update(IFileStore newValue) {
            if (newValue != null ? !newValue.equals(this.value) : this.value != null) {
                this.value = newValue;
                this.fireValueChange(Diffs.createValueDiff((Object)this.value, (Object)this.value));
            }
        }
    }

    private class ResourceObservableValue
    extends AbstractObservableValue<IResource> {
        private IResource value;

        public ResourceObservableValue(Realm realm) {
            super(realm);
        }

        public Object getValueType() {
            return IResource.class;
        }

        protected IResource doGetValue() {
            return this.value;
        }

        protected void doSetValue(IResource value) {
            ObservableFileValidator.this.setExplicit(value);
            ObservableFileValidator.this.checkExplicit();
        }

        void update(IResource newValue) {
            if (newValue != null ? !newValue.equals((Object)this.value) : this.value != null) {
                this.value = newValue;
                this.fireValueChange(Diffs.createValueDiff((Object)this.value, (Object)this.value));
            }
        }
    }
}

