/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.eclient.graphics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.rj.eclient.graphics.ColorManager;
import org.eclipse.statet.internal.rj.eclient.graphics.EclipseRGraphic;
import org.eclipse.statet.internal.rj.eclient.graphics.FontManager;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.eclient.graphics.ERGraphic;
import org.eclipse.statet.rj.eclient.graphics.ERGraphicsManager;
import org.eclipse.statet.rj.eclient.graphics.RGraphicsPreferencePage;
import org.eclipse.statet.rj.eclient.graphics.comclient.ToolRClientGraphicActions;
import org.eclipse.statet.rj.server.client.RClientGraphic;
import org.eclipse.statet.rj.server.client.RClientGraphicActions;
import org.eclipse.statet.rj.server.client.RClientGraphicFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
public class EclipseRGraphicFactory
implements RClientGraphicFactory,
ERGraphicsManager {
    private final CopyOnWriteIdentityListSet<EclipseRGraphic> graphics = new CopyOnWriteIdentityListSet();
    private final CopyOnWriteIdentityListSet<ERGraphicsManager.Listener> listeners = new CopyOnWriteIdentityListSet();
    private final AddedSafeRunnable addedRunnable = new AddedSafeRunnable();
    private final RemovedSafeRunnable removedRunnable = new RemovedSafeRunnable();
    private final ShowSafeRunnable showRunnable = new ShowSafeRunnable();
    private final Display defaultDisplay = UIAccess.getDisplay();
    private final FontManager fontManager = new FontManager(this.defaultDisplay);
    private final ColorManager colorManager = new ColorManager(this.defaultDisplay);

    public EclipseRGraphicFactory() {
        this.defaultDisplay.asyncExec(new Runnable(){

            @Override
            public void run() {
                EclipseRGraphicFactory.this.defaultDisplay.disposeExec(new Runnable(){

                    @Override
                    public void run() {
                        EclipseRGraphicFactory.this.fontManager.dispose();
                        EclipseRGraphicFactory.this.colorManager.dispose();
                    }
                });
            }
        });
    }

    public Map<String, ? extends Object> getInitServerProperties() {
        HashMap map = new HashMap();
        IPreferencesService preferences = Platform.getPreferencesService();
        final AtomicReference<double @Nullable []> dpi = new AtomicReference<double[]>();
        dpi.set(RGraphicsPreferencePage.parseDPI(preferences.getString("org.eclipse.statet.rj.eclient.graphics/display", "dpi.xy", null, null)));
        if (dpi.get() == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Point point = Display.getCurrent().getDPI();
                    dpi.set(new double[]{point.x, point.y});
                }
            });
            if (dpi.get() == null) {
                dpi.set(new double[]{96.0, 96.0});
            }
        }
        map.put("display.ppi", dpi.get());
        return map;
    }

    public RClientGraphic newGraphic(int devId, double w, double h, RClientGraphic.InitConfig config, boolean active, @Nullable RClientGraphicActions actions, int options) {
        final EclipseRGraphic egraphic = new EclipseRGraphic(devId, w, h, config, active, actions instanceof ToolRClientGraphicActions ? (ToolRClientGraphicActions)actions : null, options, this);
        if ((options & 4) == 0) {
            this.defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    EclipseRGraphicFactory.this.graphics.add((Object)egraphic);
                    ImIdentityList listeners = EclipseRGraphicFactory.this.listeners.toList();
                    ((EclipseRGraphicFactory)EclipseRGraphicFactory.this).showRunnable.graphic = egraphic;
                    ((EclipseRGraphicFactory)EclipseRGraphicFactory.this).showRunnable.bestPriority = Integer.MIN_VALUE;
                    for (ERGraphicsManager.Listener listener : listeners) {
                        if (!(listener instanceof ERGraphicsManager.ListenerShowExtension)) continue;
                        ((EclipseRGraphicFactory)EclipseRGraphicFactory.this).showRunnable.listener = (ERGraphicsManager.ListenerShowExtension)listener;
                        SafeRunner.run((ISafeRunnable)EclipseRGraphicFactory.this.showRunnable);
                    }
                    ((EclipseRGraphicFactory)EclipseRGraphicFactory.this).showRunnable.listener = null;
                    if (((EclipseRGraphicFactory)EclipseRGraphicFactory.this).showRunnable.bestPriority >= 0) {
                        SafeRunner.run((ISafeRunnable)EclipseRGraphicFactory.this.showRunnable);
                    }
                    EclipseRGraphicFactory.this.showRunnable.clear();
                    ((EclipseRGraphicFactory)EclipseRGraphicFactory.this).addedRunnable.graphic = egraphic;
                    Iterator iterator = listeners.iterator();
                    while (iterator.hasNext()) {
                        ERGraphicsManager.Listener listener;
                        ((EclipseRGraphicFactory)EclipseRGraphicFactory.this).addedRunnable.listener = listener = (ERGraphicsManager.Listener)iterator.next();
                        SafeRunner.run((ISafeRunnable)EclipseRGraphicFactory.this.addedRunnable);
                    }
                    EclipseRGraphicFactory.this.addedRunnable.clear();
                }
            });
        }
        return egraphic;
    }

    public void closeGraphic(RClientGraphic graphic) {
        EclipseRGraphic egraphic = (EclipseRGraphic)graphic;
        this.close(egraphic);
        egraphic.closeFromR();
    }

    void close(final EclipseRGraphic graphic) {
        if (!this.defaultDisplay.isDisposed()) {
            this.defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    EclipseRGraphicFactory.this.graphics.remove((Object)graphic);
                    ImIdentityList listeners = EclipseRGraphicFactory.this.listeners.toList();
                    ((EclipseRGraphicFactory)EclipseRGraphicFactory.this).removedRunnable.graphic = graphic;
                    Iterator iterator = listeners.iterator();
                    while (iterator.hasNext()) {
                        ERGraphicsManager.Listener listener;
                        ((EclipseRGraphicFactory)EclipseRGraphicFactory.this).removedRunnable.listener = listener = (ERGraphicsManager.Listener)iterator.next();
                        SafeRunner.run((ISafeRunnable)EclipseRGraphicFactory.this.removedRunnable);
                    }
                    EclipseRGraphicFactory.this.removedRunnable.clear();
                }
            });
        }
    }

    public @Nullable FontManager getFontManager(Display display) {
        if (display == this.defaultDisplay) {
            return this.fontManager;
        }
        return null;
    }

    public @Nullable ColorManager getColorManager(Display display) {
        if (display == this.defaultDisplay) {
            return this.colorManager;
        }
        return null;
    }

    public ImList<? extends ERGraphic> getAllGraphics() {
        return this.graphics.toList();
    }

    @Override
    public void addListener(ERGraphicsManager.Listener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(ERGraphicsManager.Listener listener) {
        this.listeners.remove((Object)listener);
    }

    private static class AddedSafeRunnable
    implements ISafeRunnable {
        ERGraphic graphic;
        ERGraphicsManager.Listener listener;

        AddedSafeRunnable() {
        }

        void clear() {
            this.graphic = null;
            this.listener = null;
        }

        public void run() {
            this.listener.graphicAdded(this.graphic);
        }

        public void handleException(Throwable exception) {
        }
    }

    private static class RemovedSafeRunnable
    implements ISafeRunnable {
        ERGraphic graphic;
        ERGraphicsManager.Listener listener;

        RemovedSafeRunnable() {
        }

        void clear() {
            this.graphic = null;
            this.listener = null;
        }

        public void run() {
            this.listener.graphicRemoved(this.graphic);
        }

        public void handleException(Throwable exception) {
        }
    }

    private static class ShowSafeRunnable
    implements ISafeRunnable {
        int bestPriority;
        ERGraphicsManager.ListenerShowExtension bestListener;
        ERGraphic graphic;
        @Nullable ERGraphicsManager.ListenerShowExtension listener;

        ShowSafeRunnable() {
        }

        void clear() {
            this.bestListener = null;
            this.graphic = null;
            this.listener = null;
        }

        public void run() {
            ERGraphicsManager.ListenerShowExtension listener = this.listener;
            if (listener != null) {
                int priority = listener.canShowGraphic(this.graphic);
                if (priority > this.bestPriority) {
                    this.bestPriority = priority;
                    this.bestListener = listener;
                }
            } else {
                this.bestListener.showGraphic(this.graphic);
            }
        }

        public void handleException(Throwable exception) {
        }
    }
}

