/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.editors;

import java.util.Map;
import org.eclipse.statet.ecommons.preferences.AbstractPreferencesModelObject;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ltk.ui.sourceediting.ISmartInsertSettings;

public class REditorOptions
extends AbstractPreferencesModelObject
implements ISmartInsertSettings {
    public static final String GROUP_ID = "r/r.editor/options";
    public static final String SMARTINSERT_GROUP_ID = "r/r.editor/smartinsert";
    public static final Preference.BooleanPref SMARTINSERT_BYDEFAULT_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.statet.r.ui/editor.r/options", "smartinsert.as_default.enabled");
    public static final Preference.BooleanPref SMARTINSERT_ONPASTE_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.statet.r.ui/editor.r/options", "smartinsert.on_paste.enabled");
    public static final Preference<ISmartInsertSettings.TabAction> SMARTINSERT_TAB_ACTION_PREF = new Preference.EnumPref("org.eclipse.statet.r.ui/editor.r/options", "SmartInsert.Tab.action", ISmartInsertSettings.TabAction.class);
    public static final Preference.BooleanPref SMARTINSERT_CLOSECURLY_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.statet.r.ui/editor.r/options", "smartinsert.close_curlybrackets.enabled");
    public static final Preference.BooleanPref SMARTINSERT_CLOSEROUND_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.statet.r.ui/editor.r/options", "smartinsert.close_roundbrackets.enabled");
    public static final Preference.BooleanPref SMARTINSERT_CLOSESQUARE_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.statet.r.ui/editor.r/options", "smartinsert.close_squarebrackets.enabled");
    public static final Preference.BooleanPref SMARTINSERT_CLOSESPECIAL_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.statet.r.ui/editor.r/options", "smartinsert.close_specialpercent.enabled");
    public static final Preference.BooleanPref SMARTINSERT_CLOSESTRINGS_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.statet.r.ui/editor.r/options", "smartinsert.close_strings.enabled");
    public static final Preference.BooleanPref PREF_SPELLCHECKING_ENABLED = new Preference.BooleanPref("org.eclipse.statet.r.ui/editor.r/options", "spellcheck.enabled");
    public static final Preference.BooleanPref FOLDING_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.statet.r.ui/editor.r/options", "folding.enabled");
    public static final String FOLDING_SHARED_GROUP_ID = "r/r.editor/folding.shared";
    public static final Preference.BooleanPref FOLDING_RESTORE_STATE_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.statet.r.ui/editor.r/options", "Folding.RestoreState.enabled");
    public static final Preference.BooleanPref PREF_MARKOCCURRENCES_ENABLED = new Preference.BooleanPref("org.eclipse.statet.r.ui/editor.r/options", "markoccurrences.enabled");
    private boolean fIsSmartByDefaultEnabled;
    private ISmartInsertSettings.TabAction fSmartTabAction;
    private boolean fIsSmartCurlyBracketsEnabled;
    private boolean fIsSmartRoundBracketsEnabled;
    private boolean fIsSmartSquareBracketsEnabled;
    private boolean fIsSmartSpecialPercentEnabled;
    private boolean fIsSmartStringsEnabled;
    private boolean fIsSmartPasteEnabled;

    public REditorOptions(int mode) {
        if (mode >= 1) {
            this.installLock();
        }
        this.loadDefaults();
    }

    public String[] getNodeQualifiers() {
        return new String[0];
    }

    public void loadDefaults() {
        this.fIsSmartByDefaultEnabled = true;
        this.fSmartTabAction = ISmartInsertSettings.TabAction.INSERT_INDENT_LEVEL;
        this.fIsSmartCurlyBracketsEnabled = true;
        this.fIsSmartRoundBracketsEnabled = true;
        this.fIsSmartSquareBracketsEnabled = true;
        this.fIsSmartSpecialPercentEnabled = true;
        this.fIsSmartStringsEnabled = true;
        this.fIsSmartPasteEnabled = true;
    }

    public void load(PreferenceAccess prefs) {
        this.fIsSmartByDefaultEnabled = (Boolean)prefs.getPreferenceValue((Preference)SMARTINSERT_BYDEFAULT_ENABLED_PREF);
        this.fSmartTabAction = (ISmartInsertSettings.TabAction)prefs.getPreferenceValue(SMARTINSERT_TAB_ACTION_PREF);
        this.fIsSmartCurlyBracketsEnabled = (Boolean)prefs.getPreferenceValue((Preference)SMARTINSERT_CLOSECURLY_ENABLED_PREF);
        this.fIsSmartRoundBracketsEnabled = (Boolean)prefs.getPreferenceValue((Preference)SMARTINSERT_CLOSEROUND_ENABLED_PREF);
        this.fIsSmartSquareBracketsEnabled = (Boolean)prefs.getPreferenceValue((Preference)SMARTINSERT_CLOSESQUARE_ENABLED_PREF);
        this.fIsSmartSpecialPercentEnabled = (Boolean)prefs.getPreferenceValue((Preference)SMARTINSERT_CLOSESPECIAL_ENABLED_PREF);
        this.fIsSmartStringsEnabled = (Boolean)prefs.getPreferenceValue((Preference)SMARTINSERT_CLOSESTRINGS_ENABLED_PREF);
        this.fIsSmartPasteEnabled = (Boolean)prefs.getPreferenceValue((Preference)SMARTINSERT_ONPASTE_ENABLED_PREF);
    }

    public Map<Preference<?>, Object> deliverToPreferencesMap(Map<Preference<?>, Object> map) {
        map.put((Preference<?>)SMARTINSERT_BYDEFAULT_ENABLED_PREF, this.fIsSmartByDefaultEnabled);
        map.put(SMARTINSERT_TAB_ACTION_PREF, this.fSmartTabAction);
        map.put((Preference<?>)SMARTINSERT_CLOSECURLY_ENABLED_PREF, this.fIsSmartCurlyBracketsEnabled);
        map.put((Preference<?>)SMARTINSERT_CLOSEROUND_ENABLED_PREF, this.fIsSmartRoundBracketsEnabled);
        map.put((Preference<?>)SMARTINSERT_CLOSESQUARE_ENABLED_PREF, this.fIsSmartSquareBracketsEnabled);
        map.put((Preference<?>)SMARTINSERT_CLOSESPECIAL_ENABLED_PREF, this.fIsSmartSpecialPercentEnabled);
        map.put((Preference<?>)SMARTINSERT_CLOSESTRINGS_ENABLED_PREF, this.fIsSmartStringsEnabled);
        map.put((Preference<?>)SMARTINSERT_ONPASTE_ENABLED_PREF, this.fIsSmartPasteEnabled);
        return map;
    }

    public boolean isSmartInsertEnabledByDefault() {
        return this.fIsSmartByDefaultEnabled;
    }

    public ISmartInsertSettings.TabAction getSmartInsertTabAction() {
        return this.fSmartTabAction;
    }

    public boolean isSmartPasteEnabled() {
        return this.fIsSmartPasteEnabled;
    }

    public boolean isSmartCurlyBracketsEnabled() {
        return this.fIsSmartCurlyBracketsEnabled;
    }

    public boolean isSmartRoundBracketsEnabled() {
        return this.fIsSmartRoundBracketsEnabled;
    }

    public boolean isSmartSquareBracketsEnabled() {
        return this.fIsSmartSquareBracketsEnabled;
    }

    public boolean isSmartSpecialPercentEnabled() {
        return this.fIsSmartSpecialPercentEnabled;
    }

    public boolean isSmartStringsEnabled() {
        return this.fIsSmartStringsEnabled;
    }
}

