/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.rtool;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.statet.ecommons.models.core.util.ElementPartition;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.util.ViewActionUtil;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.actions.AbstractToolHandler;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.ui.util.RElementInputContentProvider;
import org.eclipse.statet.r.ui.util.RElementInputUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class PrintRElementHandler
extends AbstractToolHandler<RProcess> {
    private final ViewActionUtil actionUtil;

    public PrintRElementHandler(ViewActionUtil actionUtil) {
        super("R", "org.eclipse.statet.r.basic", (ToolProvider)actionUtil.getWorkbenchPart(), (IServiceLocator)actionUtil.getWorkbenchPart().getSite());
        this.actionUtil = actionUtil;
    }

    private ITreeSelection getSelection() {
        ISelectionProvider selectionProvider = this.actionUtil.getSelectionProvider();
        return (ITreeSelection)selectionProvider.getSelection();
    }

    private boolean isValidSelection(ITreeSelection selection) {
        CombinedRElement rElement;
        if (selection == null || selection.size() != 1) {
            return false;
        }
        Object element = selection.getFirstElement();
        return !(element instanceof ElementPartition) || (rElement = RElementInputContentProvider.getCombinedRElement(element)) != null && rElement.getRObjectType() == 7;
    }

    protected boolean evaluateIsEnabled(RProcess tool, @Nullable Object evaluationContext) {
        return super.evaluateIsEnabled((Tool)tool, evaluationContext) && this.isValidSelection(this.getSelection());
    }

    protected @Nullable Object execute(RProcess tool, ExecutionEvent event) {
        if (!UIAccess.isOkToUse((Control)this.actionUtil.getControl())) {
            return null;
        }
        ITreeSelection selection = this.getSelection();
        if (!this.isValidSelection(selection)) {
            return null;
        }
        TreePath treePath = selection.getPaths()[0];
        RElementName elementName = RElementInputUtils.getRElementName(treePath, selection);
        if (elementName != null) {
            String cmd = elementName.getDisplayName(3);
            if (treePath.getLastSegment() instanceof ElementPartition) {
                ElementPartition partition = (ElementPartition)treePath.getLastSegment();
                cmd = String.valueOf(cmd) + '[' + (partition.getPartitionStart() + 1L) + ':' + (partition.getPartitionStart() + partition.getPartitionLength()) + ']';
            }
            try {
                ToolController controller = NicoUITools.accessController((String)"R", (ToolProcess)tool);
                controller.submit(cmd, SubmitType.TOOLS);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }
}

