/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.statet.ecommons.text.core.IFragmentDocument;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.console.ConsolePageEditor;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.util.LoadReferencesUtil;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.rsource.ast.FCall;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.source.IRDocumentConstants;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.editors.IRSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.RFrameSearchPath;
import org.eclipse.ui.IWorkbenchPart;

public class RAssistInvocationContext
extends AssistInvocationContext {
    private static final byte PARSE_OPERATOR = 1;
    private static final byte PARSE_SYMBOL = 2;
    private static final char[] F_BRACKETS = new char[]{'(', ')'};
    private RHeuristicTokenScanner scanner;
    private RElementName prefixName;
    private int prefixLastSegmentOffset = -1;
    private final RProcess tool;
    private LoadReferencesUtil toolReferencesUtil;

    public RAssistInvocationContext(IRSourceEditor editor, int offset, String contentType, boolean isProposal, RHeuristicTokenScanner scanner, IProgressMonitor monitor) {
        super((ISourceEditor)editor, offset, contentType, isProposal ? 2 : 0, monitor);
        this.scanner = scanner;
        this.tool = this.determineRProcess();
    }

    public RAssistInvocationContext(IRSourceEditor editor, IRegion region, String contentType, RHeuristicTokenScanner scanner, IProgressMonitor monitor) {
        super((ISourceEditor)editor, region, contentType, 2, monitor);
        this.scanner = scanner;
        this.tool = this.determineRProcess();
    }

    private RProcess determineRProcess() {
        IRSourceEditor editor = this.getEditor();
        Object tool = editor instanceof ConsolePageEditor ? (Tool)editor.getAdapter(Tool.class) : NicoUITools.getTool((IWorkbenchPart)editor.getWorkbenchPart());
        return tool instanceof RProcess ? (RProcess)tool : null;
    }

    protected boolean reuse(ISourceEditor editor, int offset) {
        if (super.reuse(editor, offset)) {
            if (this.toolReferencesUtil != null) {
                this.toolReferencesUtil.setWaitTimeout((long)this.getToolReferencesWaitTimeout());
            }
            return true;
        }
        return false;
    }

    protected String getModelTypeId() {
        return "R";
    }

    public IRSourceEditor getEditor() {
        return (IRSourceEditor)super.getEditor();
    }

    public IRSourceUnit getSourceUnit() {
        return (IRSourceUnit)super.getSourceUnit();
    }

    protected String computeIdentifierPrefix(int endOffset) throws BadPartitioningException, BadLocationException {
        AbstractDocument document = (AbstractDocument)this.getDocument();
        if (endOffset < 0 || endOffset > document.getLength()) {
            throw new BadLocationException("offset= " + endOffset);
        }
        if (endOffset == 0) {
            return "";
        }
        int offset = endOffset;
        int currentMode = 3;
        int validModes = 3;
        String partitioning = this.getEditor().getDocumentContentInfo().getPartitioning();
        ITypedRegion partition = document.getPartition(partitioning, offset, true);
        if (partition.getType() == "R.QuotedSymbol" || partition.getType() == "R.String") {
            offset = partition.getOffset();
            currentMode = 1;
        }
        int startOffset = offset;
        block5: while (offset > 0) {
            char c = document.getChar(offset - 1);
            if (RTokens.isRobustSeparator((int)c)) {
                switch (c) {
                    case '$': 
                    case '@': {
                        if ((currentMode & 1) == 0) break block5;
                        startOffset = --offset;
                        currentMode = (byte)(validModes & 2);
                        continue block5;
                    }
                    case ':': {
                        if ((currentMode & 1) == 0 || offset < 2 || document.getChar(offset - 2) != ':') break block5;
                        offset = offset >= 3 && document.getChar(offset - 3) == ':' ? (offset -= 3) : (offset -= 2);
                        validModes = (byte)(validModes & 0xFFFFFFFE);
                        currentMode = (byte)(validModes & 2);
                        continue block5;
                    }
                    case '`': {
                        if ((currentMode & 2) == 0 || (partition = document.getPartition(partitioning, offset - 1, false)).getType() != "R.QuotedSymbol") break block5;
                        startOffset = offset = partition.getOffset();
                        currentMode = (byte)(validModes & 1);
                        continue block5;
                    }
                }
                break;
            }
            if ((currentMode & 2) == 0) break;
            startOffset = --offset;
            currentMode = (byte)(currentMode | (byte)(validModes & 1));
        }
        return document.get(startOffset, endOffset - startOffset);
    }

    protected int computeIdentifierPrefixLastSegmentOffset(int endOffset) throws BadPartitioningException, BadLocationException {
        AbstractDocument document = (AbstractDocument)this.getDocument();
        if (endOffset < 0 || endOffset > document.getLength()) {
            throw new BadLocationException("endOffset= " + endOffset);
        }
        if (endOffset == 0) {
            return 0;
        }
        int offset = endOffset;
        String partitioning = this.getEditor().getDocumentContentInfo().getPartitioning();
        ITypedRegion partition = document.getPartition(partitioning, offset, true);
        if (partition.getType() == "R.QuotedSymbol" || partition.getType() == "R.String") {
            return partition.getOffset();
        }
        int startOffset = offset;
        while (offset > 0) {
            char c = document.getChar(offset - 1);
            if (RTokens.isRobustSeparator((int)c, (boolean)false)) break;
            startOffset = --offset;
        }
        return startOffset;
    }

    public RElementName getIdentifierElementName() {
        if (this.prefixName == null) {
            this.prefixName = RElementName.parseDefault((String)this.getIdentifierPrefix());
        }
        return this.prefixName;
    }

    public int getIdentifierLastSegmentOffset() {
        if (this.prefixLastSegmentOffset < 0) {
            try {
                this.prefixLastSegmentOffset = this.computeIdentifierPrefixLastSegmentOffset(this.getInvocationOffset());
            }
            catch (BadLocationException | BadPartitioningException e) {
                this.prefixLastSegmentOffset = this.getInvocationOffset();
                throw new RuntimeException(e);
            }
        }
        return this.prefixLastSegmentOffset;
    }

    public final RHeuristicTokenScanner getRHeuristicTokenScanner() {
        if (this.scanner == null) {
            this.scanner = RHeuristicTokenScanner.create((IDocContentSections)this.getEditor().getDocumentContentInfo());
        }
        return this.scanner;
    }

    private static RElementName getElementAccessOfRegion(RElementAccess access, TextRegion region) {
        RElementAccess current = access;
        while (current != null) {
            if (current.getSegmentName() == null) {
                return null;
            }
            switch (current.getType()) {
                case 17: 
                case 21: 
                case 25: 
                case 26: 
                case 33: 
                case 34: 
                case 37: 
                case 38: {
                    break;
                }
                default: {
                    return null;
                }
            }
            RAstNode nameNode = current.getNameNode();
            if (nameNode != null && nameNode.getStartOffset() <= region.getStartOffset() && nameNode.getEndOffset() >= region.getEndOffset()) {
                return RElementName.create((RElementName)access, (RElementName)current.getNextSegment(), (boolean)true);
            }
            current = current.getNextSegment();
        }
        return null;
    }

    public RElementName getNameSelection() {
        AstNode selectedNode = this.getAstSelection().getCovering();
        if (selectedNode instanceof RAstNode) {
            RAstNode node = (RAstNode)selectedNode;
            RElementAccess access = null;
            while (node != null && access == null) {
                if (Thread.interrupted()) {
                    return null;
                }
                ImList attachments = node.getAttachments();
                for (Object attachment : attachments) {
                    if (!(attachment instanceof RElementAccess)) continue;
                    node = null;
                    access = (RElementAccess)attachment;
                    RElementName e = RAssistInvocationContext.getElementAccessOfRegion(access, (TextRegion)this);
                    if (e != null) {
                        return e;
                    }
                    if (!Thread.interrupted()) continue;
                    return null;
                }
                if (node == null) continue;
                node = node.getRParent();
            }
        }
        return null;
    }

    public FCallInfo getFCallInfo() {
        int index;
        RHeuristicTokenScanner scanner = this.getRHeuristicTokenScanner();
        int offset = this.getIdentifierOffset();
        IDocument document = this.getDocument();
        int offsetShift = 0;
        if (document instanceof IFragmentDocument) {
            IFragmentDocument inputDoc = (IFragmentDocument)document;
            document = inputDoc.getMasterDocument();
            offsetShift = inputDoc.getOffsetInMasterDocument();
            offset += offsetShift;
        }
        if (scanner == null || offset < 2) {
            return null;
        }
        scanner.configureDefaultParitions(document);
        if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(scanner.getPartition(offset - 1).getType()) && (index = scanner.findOpeningPeer(offset - 1, F_BRACKETS)) >= 0) {
            return this.searchFCallInfo(index - offsetShift);
        }
        return null;
    }

    private FCallInfo searchFCallInfo(int openOffset) {
        AstInfo astInfo = this.getAstInfo();
        if (astInfo == null || astInfo.getRoot() == null) {
            return null;
        }
        AstSelection selection = AstSelection.search((AstNode)astInfo.getRoot(), (int)openOffset, (int)(openOffset + 1), (int)3);
        AstNode node = selection.getCovering();
        while (node != null && node instanceof RAstNode) {
            RAstNode rnode = (RAstNode)node;
            FCall fcallNode = null;
            if (rnode.getNodeType() == NodeType.F_CALL && openOffset == (fcallNode = (FCall)rnode).getArgsOpenOffset()) {
                ImList attachments = fcallNode.getAttachments();
                for (Object attachment : attachments) {
                    RElementAccess fcallAccess;
                    if (!(attachment instanceof RElementAccess) || !(fcallAccess = (RElementAccess)attachment).isFunctionAccess() || fcallAccess.isWriteAccess()) continue;
                    return new FCallInfo(fcallNode, fcallAccess);
                }
            }
            node = rnode.getParent();
        }
        return null;
    }

    public RProcess getTool() {
        return this.tool;
    }

    public boolean isToolConsole() {
        return this.getEditor() instanceof ConsolePageEditor;
    }

    public LoadReferencesUtil getToolReferencesUtil() {
        if (this.toolReferencesUtil == null && this.tool != null) {
            this.toolReferencesUtil = new LoadReferencesUtil(this.tool, this.getToolReferencesWaitTimeout()){

                protected void allFinished(ImList<CombinedRElement> resolvedElements) {
                    if (!resolvedElements.isEmpty()) {
                        RAssistInvocationContext.this.toolReferencesResolved(resolvedElements);
                    }
                }
            };
        }
        return this.toolReferencesUtil;
    }

    protected int getToolReferencesWaitTimeout() {
        return 250;
    }

    protected void toolReferencesResolved(ImList<CombinedRElement> resolvedElements) {
    }

    public int getDefaultRFrameSearchMode() {
        return this.isToolConsole() ? 2 : 1;
    }

    public class FCallInfo {
        private final FCall node;
        private final RElementAccess access;
        private RFrameSearchPath searchPath;

        public FCallInfo(FCall node, RElementAccess access) {
            this.node = node;
            this.access = access;
        }

        public FCall getNode() {
            return this.node;
        }

        public RElementAccess getAccess() {
            return this.access;
        }

        private RFrameSearchPath createSearchPath(int mode) {
            RFrameSearchPath searchPath = new RFrameSearchPath();
            RAstNode parent = this.node.getRParent();
            searchPath.init(RAssistInvocationContext.this, (RAstNode)(parent != null ? parent : this.node), mode, this.getAccess().getScope());
            return searchPath;
        }

        public RFrameSearchPath getSearchPath(int mode) {
            int defaultMode = RAssistInvocationContext.this.getDefaultRFrameSearchMode();
            if (mode == 0 || mode == defaultMode) {
                if (this.searchPath == null) {
                    this.searchPath = this.createSearchPath(defaultMode);
                }
                return this.searchPath;
            }
            return this.createSearchPath(mode);
        }

        public int getArgIdx(int offset) {
            if (offset <= this.node.getArgsOpenOffset() || this.node.getArgsCloseOffset() != Integer.MIN_VALUE && offset > this.node.getArgsCloseOffset()) {
                return -1;
            }
            FCall.Args args = this.node.getArgsChild();
            int last = args.getChildCount() - 1;
            if (last < 0) {
                return 0;
            }
            int argIdx = 0;
            while (argIdx < last) {
                if (args.getSeparatorOffset(argIdx) >= offset) {
                    return argIdx;
                }
                ++argIdx;
            }
            return last;
        }

        public int getArgBeginOffset(int argIdx) {
            if (argIdx < 0) {
                return Integer.MIN_VALUE;
            }
            int sep = argIdx == 0 ? this.node.getArgsOpenOffset() : this.node.getArgsChild().getSeparatorOffset(argIdx - 1);
            return sep + 1;
        }

        public FCall.Arg getArg(int argIdx) {
            if (argIdx < 0) {
                return null;
            }
            FCall.Args args = this.node.getArgsChild();
            return argIdx < args.getChildCount() ? args.getChild(argIdx) : null;
        }
    }
}

