/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.net.URI;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.ecommons.net.resourcemapping.core.IResourceMapping;
import org.eclipse.statet.ecommons.net.resourcemapping.core.IResourceMappingManager;
import org.eclipse.statet.ecommons.net.resourcemapping.core.ResourceMappingOrder;
import org.eclipse.statet.ecommons.net.resourcemapping.core.ResourceMappingUtils;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.IWorkspaceSourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IAssistCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.PathCompletionComputor;
import org.eclipse.statet.nico.ui.console.ConsolePageEditor;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.RUtil;

public class RPathCompletionComputer
extends PathCompletionComputor {
    private RProcess associatedTool;
    private IContainer baseResource;
    private IFileStore baseFileStore;

    public String getPluginId() {
        return "org.eclipse.statet.r.ui";
    }

    public void sessionStarted(ISourceEditor editor, ContentAssist assist) {
        this.associatedTool = null;
        this.baseResource = null;
        this.baseFileStore = null;
        if (editor instanceof ConsolePageEditor) {
            Tool tool = (Tool)editor.getAdapter(Tool.class);
            if (tool instanceof RProcess) {
                this.associatedTool = (RProcess)tool;
            }
        } else {
            ISourceUnit su = editor.getSourceUnit();
            if (su instanceof IWorkspaceSourceUnit) {
                this.baseResource = null;
                IResource resource = ((IWorkspaceSourceUnit)su).getResource();
                if (this.baseResource == null) {
                    this.baseResource = resource.getParent();
                }
                if (this.baseResource != null) {
                    try {
                        this.baseFileStore = EFS.getStore((URI)this.baseResource.getLocationURI());
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
        }
        super.sessionStarted(editor, assist);
    }

    public void sessionEnded() {
        super.sessionEnded();
        this.associatedTool = null;
    }

    protected boolean getIsWindows() {
        if (this.associatedTool != null) {
            return this.associatedTool.getWorkspaceData().isWindows();
        }
        return super.getIsWindows();
    }

    protected char getDefaultFileSeparator() {
        if (this.associatedTool != null) {
            return this.associatedTool.getWorkspaceData().getFileSeparator();
        }
        return super.getDefaultFileSeparator();
    }

    protected TextRegion getContentRange(AssistInvocationContext context, int mode) throws BadLocationException {
        int end;
        IDocument document = context.getSourceViewer().getDocument();
        int offset = context.getInvocationOffset();
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.getEditor().getDocumentContentInfo().getPartitioning(), (int)offset, (boolean)true);
        int start = partition.getOffset();
        if (start == (end = partition.getOffset() + partition.getLength())) {
            return null;
        }
        char bound = document.getChar(start);
        if (bound != '\"' && bound != '\'') {
            return null;
        }
        if (++start > offset) {
            return null;
        }
        if (end > start && document.getChar(end - 1) == bound) {
            if (end == offset) {
                return null;
            }
            --end;
        }
        return new BasicTextRegion(start, end);
    }

    protected IPath getRelativeBasePath() {
        if (this.associatedTool != null) {
            IFileStore wd = this.associatedTool.getWorkspaceData().getWorkspaceDir();
            if (wd != null) {
                return URIUtil.toPath((URI)wd.toURI());
            }
            return null;
        }
        if (this.baseResource != null) {
            return this.baseResource.getLocation();
        }
        return null;
    }

    protected IFileStore getRelativeBaseStore() {
        if (this.associatedTool != null) {
            return this.associatedTool.getWorkspaceData().getWorkspaceDir();
        }
        if (this.baseFileStore != null) {
            return this.baseFileStore;
        }
        return null;
    }

    protected IFileStore resolveStore(IPath path) throws CoreException {
        if (this.associatedTool != null) {
            return this.associatedTool.getWorkspaceData().toFileStore(path);
        }
        return super.resolveStore(path);
    }

    protected IStatus tryAlternative(AssistInvocationContext context, IPath path, int startOffset, String segmentPrefix, String completionPrefix, AssistProposalCollector proposals) throws CoreException {
        IResourceMappingManager rmManager;
        String address;
        if (this.associatedTool != null && (address = this.associatedTool.getWorkspaceData().getRemoteAddress()) != null && (rmManager = ResourceMappingUtils.getManager()) != null) {
            List mappings = rmManager.getResourceMappingsFor(address, ResourceMappingOrder.REMOTE);
            for (IResourceMapping mapping : mappings) {
                IPath remotePath = mapping.getRemotePath();
                if (!path.isEmpty()) {
                    if (!path.isPrefixOf(remotePath)) continue;
                    remotePath = remotePath.setDevice(null).makeRelative().removeFirstSegments(path.segmentCount());
                }
                String name = remotePath.segment(0);
                if (!segmentPrefix.isEmpty() && (name == null || !name.regionMatches(true, 0, segmentPrefix, 0, segmentPrefix.length()))) continue;
                proposals.add((IAssistCompletionProposal)new PathCompletionComputor.ResourceProposal((PathCompletionComputor)this, context, startOffset, mapping.getFileStore(), remotePath.toString(), completionPrefix, null));
            }
            return Status.OK_STATUS;
        }
        return super.tryAlternative(context, path, startOffset, segmentPrefix, completionPrefix, proposals);
    }

    protected String checkPrefix(String prefix) {
        String unescaped = RUtil.unescapeCompletely((String)prefix);
        if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) == '\\' && (unescaped.isEmpty() || unescaped.charAt(unescaped.length() - 1) != '\\')) {
            unescaped = String.valueOf(unescaped) + '\\';
        }
        return super.checkPrefix(unescaped);
    }

    protected String checkPathCompletion(IDocument document, int completionOffset, String completion) throws BadLocationException {
        boolean startsWithBackslash;
        completion = RUtil.escapeCompletely((String)completion);
        int existingBackslashCount = 0;
        if (completionOffset >= 1 && document.getChar(completionOffset - 1) == '\\') {
            ++existingBackslashCount;
            if (completionOffset >= 2 && document.getChar(completionOffset - 2) == '\\') {
                ++existingBackslashCount;
            }
        }
        boolean bl = startsWithBackslash = completion.length() >= 2 && completion.charAt(0) == '\\' && completion.charAt(1) == '\\';
        if (existingBackslashCount % 2 == 1) {
            completion = startsWithBackslash ? completion.substring(1) : String.valueOf('\\') + completion;
        } else if (existingBackslashCount > 0 && startsWithBackslash) {
            completion = completion.substring(2);
        }
        return completion;
    }
}

