/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.ui.IWorkbenchPart;

public class SourceEditorOperationHandler
extends AbstractHandler {
    private final int viewerOperation;

    public SourceEditorOperationHandler(int viewerOperation) {
        this.viewerOperation = viewerOperation;
    }

    protected ISourceEditor getSourceEditor(Object context) {
        IWorkbenchPart part = WorkbenchUIUtils.getActivePart((Object)context);
        if (part == null) {
            return null;
        }
        return (ISourceEditor)part.getAdapter(ISourceEditor.class);
    }

    public void setEnabled(Object evaluationContext) {
        ISourceEditor editor = this.getSourceEditor(evaluationContext);
        if (editor == null) {
            this.setBaseEnabled(false);
            return;
        }
        SourceViewer viewer = editor.getViewer();
        this.setBaseEnabled(UIAccess.isOkToUse((Viewer)viewer) && viewer.canDoOperation(this.viewerOperation));
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISourceEditor editor = this.getSourceEditor(event.getApplicationContext());
        if (editor == null) {
            return null;
        }
        SourceViewer viewer = editor.getViewer();
        if (UIAccess.isOkToUse((Viewer)viewer)) {
            viewer.doOperation(this.viewerOperation);
        }
        return null;
    }
}

