/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.internal.r.core.FilteredFrame;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.RProjectNature;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.elements.ISourceElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.elements.IWorkspaceSourceUnit;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.RProjects;
import org.eclipse.statet.r.core.model.IPackageReferences;
import org.eclipse.statet.r.core.model.IRElement;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRFrameInSource;
import org.eclipse.statet.r.core.model.IRLangElement;
import org.eclipse.statet.r.core.model.IRModelInfo;
import org.eclipse.statet.r.core.model.IRModelManager;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;

public final class RModel {
    public static final String R_TYPE_ID = "R";
    public static final RElementName GLOBAL_ENV_NAME = RElementName.create(37, ".GlobalEnv");
    public static final String BUILDPATH_PROBLEM_MARKER = "org.eclipse.statet.r.resourceMarkers.BuildpathProblem";
    public static final String R_MODEL_PROBLEM_MARKER = "org.eclipse.statet.r.resourceMarkers.RModelProblem";

    public static IRModelManager getRModelManager() {
        return RCorePlugin.getInstance().getRModelManager();
    }

    public static IRModelInfo getRModelInfo(ISourceUnitModelInfo modelInfo) {
        if (modelInfo != null) {
            if (modelInfo instanceof IRModelInfo) {
                return (IRModelInfo)modelInfo;
            }
            for (Object aAttachment : modelInfo.getAttachments()) {
                if (!(aAttachment instanceof IRModelInfo)) continue;
                return (IRModelInfo)aAttachment;
            }
        }
        return null;
    }

    public static IRFrameInSource searchFrame(RAstNode node) {
        while (node != null) {
            ImList attachments = node.getAttachments();
            for (Object attachment : attachments) {
                if (!(attachment instanceof IRFrameInSource)) continue;
                return (IRFrameInSource)attachment;
            }
            node = node.getRParent();
        }
        return null;
    }

    private static boolean isValidPkgFrame(IRFrame frame) {
        return frame.getFrameType() == 2 && frame.getElementName().getSegmentName() != null;
    }

    private static boolean isValidFrame(IRFrame frame, String pkgName) {
        return pkgName == null || RModel.isValidPkgFrame(frame) && frame.getElementName().getSegmentName().equals(pkgName);
    }

    private static boolean isValidFrame(IRFrame frame, Set<String> pkgNames) {
        return pkgNames == null || RModel.isValidPkgFrame(frame) && pkgNames.contains(frame.getElementName().getSegmentName());
    }

    public static List<IRFrame> createDirectFrameList(IRFrame frame, RElementName expliciteScope) {
        ArrayList<IRFrame> list = new ArrayList<IRFrame>();
        String pkgName = expliciteScope != null && RElementName.isPackageFacetScopeType(expliciteScope.getType()) ? expliciteScope.getSegmentName() : null;
        int idx = 0;
        if (RModel.isValidFrame(frame, pkgName)) {
            list.add(frame);
        }
        while (idx < list.size()) {
            List<? extends IRFrame> ps = list.get(idx++).getPotentialParents();
            for (IRFrame iRFrame : ps) {
                if (!RModel.isValidFrame(iRFrame, pkgName) || list.contains(iRFrame)) continue;
                list.add(iRFrame);
            }
        }
        return list;
    }

    public static List<IRFrame> createDirectFrameList(IRFrame frame) {
        return RModel.createDirectFrameList(frame, null);
    }

    public static Set<String> createImportedPackageList(IRModelInfo modelInfo) {
        HashSet<String> importedPackages = new HashSet<String>();
        importedPackages.add("base");
        if (modelInfo != null) {
            IPackageReferences packages = modelInfo.getReferencedPackages();
            for (String name : packages.getAllPackageNames()) {
                if (!packages.isImported(name)) continue;
                importedPackages.add(name);
            }
        }
        return importedPackages;
    }

    public static List<IRFrame> createProjectFrameList(RProject project1, IRSourceUnit scope, boolean pkgImports, boolean projectDependencies, Set<String> importedPackages, Set<String> pkgNames) throws CoreException {
        ArrayList<IRFrame> list = new ArrayList<IRFrame>();
        IRModelManager manager = RModel.getRModelManager();
        if (project1 == null && scope instanceof IWorkspaceSourceUnit) {
            if (pkgImports && importedPackages == null) {
                importedPackages = RModel.createImportedPackageList((IRModelInfo)scope.getModelInfo(R_TYPE_ID, 2, null));
            }
            project1 = RProjects.getRProject(((IWorkspaceSourceUnit)scope).getResource().getProject());
        }
        if (pkgImports && importedPackages == null) {
            importedPackages = ImCollections.emptySet();
        }
        if (pkgNames == null) {
            pkgNames = new HashSet<String>();
        }
        if (project1 != null) {
            IRFrame frame = manager.getProjectFrame(project1);
            if (frame != null && (projectDependencies || pkgImports && RModel.isValidFrame(frame, (Set<String>)importedPackages))) {
                if (RModel.isValidPkgFrame(frame)) {
                    pkgNames.add(frame.getElementName().getSegmentName());
                }
                list.add(new FilteredFrame(frame, scope));
            }
            ArrayList<RProjectNature> projects = new ArrayList<RProjectNature>();
            try {
                IProject[] referencedProjects;
                IProject[] iProjectArray = referencedProjects = project1.getProject().getReferencedProjects();
                int n = referencedProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject referencedProject = iProjectArray[n2];
                    RProjectNature rProject = RProjectNature.getRProject(referencedProject);
                    if (rProject != null) {
                        projects.add(rProject);
                    }
                    ++n2;
                }
            }
            catch (CoreException referencedProjects) {
                // empty catch block
            }
            int i = 0;
            while (i < projects.size()) {
                RProject project = (RProject)projects.get(i);
                IRFrame frame2 = manager.getProjectFrame(project);
                if (frame2 != null && (projectDependencies || pkgImports && RModel.isValidFrame(frame2, (Set<String>)importedPackages))) {
                    if (RModel.isValidPkgFrame(frame2)) {
                        pkgNames.add(frame2.getElementName().getSegmentName());
                    }
                    list.add(frame2);
                }
                try {
                    IProject[] referencedProjects;
                    IProject[] iProjectArray = referencedProjects = project.getProject().getReferencedProjects();
                    int n = referencedProjects.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IProject referencedProject = iProjectArray[n3];
                        RProjectNature rProject = RProjectNature.getRProject(referencedProject);
                        if (rProject != null && !projects.contains(rProject)) {
                            projects.add(rProject);
                        }
                        ++n3;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++i;
            }
        }
        if (pkgImports && importedPackages != null) {
            for (String pkgName : importedPackages) {
                IRFrame frame;
                if (pkgNames.contains(pkgName) || (frame = manager.getPkgProjectFrame(pkgName)) == null) continue;
                list.add(frame);
            }
        }
        return list;
    }

    public static List<IRFrame> createProjectFrameList(RProject project1, IRSourceUnit scope) throws CoreException {
        return RModel.createProjectFrameList(project1, scope, true, true, null, null);
    }

    public static List<ISourceElement> searchDeclaration(RElementAccess access, IRSourceUnit su) throws CoreException {
        assert (access != null);
        ArrayList<ISourceElement> list = new ArrayList<ISourceElement>();
        IRFrame suFrame = access.getFrame();
        List<IRFrame> directFrames = RModel.createDirectFrameList(suFrame);
        for (IRFrame frame : directFrames) {
            if (!RModel.checkFrame(frame, access, list)) continue;
            return list;
        }
        List<IRFrame> projectFrames = RModel.createProjectFrameList(null, su);
        for (IRFrame frame : projectFrames) {
            if (!RModel.checkFrame(frame, access, list)) continue;
            return list;
        }
        return list;
    }

    private static boolean checkFrame(IRFrame frame, RElementAccess access, List<ISourceElement> list) {
        List<? extends IRLangElement> elements = frame.getModelChildren(null);
        for (IRElement iRElement : elements) {
            RElementName name = iRElement.getElementName();
            if (name == null || !name.equals(access) || !(iRElement instanceof ISourceElement)) continue;
            list.add((ISourceElement)iRElement);
        }
        if (!list.isEmpty()) {
            ISourceElement iSourceElement = list.get(0);
            switch (iSourceElement.getElementType() & 0xFF0) {
                case 1408: 
                case 1552: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static @Nullable RElementName getFQElementName(@Nullable IRElement var) {
        List<RElementName> segments = RModel.getFQFullName(var, 0);
        return segments != null ? RElementName.create(segments) : null;
    }

    private static @Nullable List<RElementName> getFQFullName(@Nullable IRElement var, int count) {
        RElementName elementName;
        if (var != null && (elementName = var.getElementName()) != null) {
            List<RElementName> segments;
            RElementName segment = elementName;
            do {
                ++count;
            } while ((segment = segment.getNextSegment()) != null);
            RElementName scope = elementName.getScope();
            if (scope != null) {
                if (RElementName.isScopeType(scope.getType())) {
                    segments = new ArrayList<RElementName>(count + 1);
                    segments.add(scope);
                } else {
                    segments = RModel.getFQFullName(var.getModelParent(), count);
                }
            } else {
                segments = RElementName.isScopeType(elementName.getType()) ? new ArrayList<RElementName>(count) : RModel.getFQFullName(var.getModelParent(), count);
            }
            if (segments != null) {
                RElementName segment2 = elementName;
                do {
                    segments.add(segment2);
                } while ((segment2 = segment2.getNextSegment()) != null);
                return segments;
            }
        }
        return null;
    }

    private RModel() {
    }
}

