/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.docmlet.tex.core.commands.Argument;
import org.eclipse.statet.docmlet.tex.core.commands.IEnvDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.docmlet.tex.core.source.LtxHeuristicTokenScanner;
import org.eclipse.statet.docmlet.tex.ui.TexUIResources;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.TexBracketLevel;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.CompletionProposalWithOverwrite;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class LtxCommandCompletionProposal
extends CompletionProposalWithOverwrite
implements ICompletionProposalExtension6 {
    protected final TexCommand command;
    protected int relevance;
    protected StyledString displayString;
    private Point selection = null;
    private ApplyData applyData;

    private static final boolean isFollowedByOpeningBracket(ApplyData util, int forwardOffset, boolean allowSquare) {
        LtxHeuristicTokenScanner scanner = util.getScanner();
        scanner.configure(util.getDocument());
        int idx = scanner.findAnyNonBlankForward(forwardOffset, -2, false);
        return idx >= 0 && (scanner.getChar() == '{' || allowSquare && scanner.getChar() == '[');
    }

    private static final boolean isClosedBracket(ApplyData data, int backwardOffset, int forwardOffset) {
        boolean searchType = false;
        int[] balance = new int[3];
        balance[0] = balance[0] + 1;
        LtxHeuristicTokenScanner scanner = data.getScanner();
        scanner.configureDefaultParitions(data.getDocument());
        balance = scanner.computeBracketBalance(backwardOffset, forwardOffset, balance, 0);
        return balance[0] <= 0;
    }

    protected LtxCommandCompletionProposal(AssistInvocationContext context, int startOffset, TexCommand command) {
        super(context, startOffset);
        this.command = command;
        this.relevance = 95;
    }

    protected String getPluginId() {
        return "org.eclipse.statet.docmlet.tex.ui";
    }

    public int getRelevance() {
        return this.relevance;
    }

    public String getSortingString() {
        return this.command.getControlWord();
    }

    public String getDisplayString() {
        return this.getStyledDisplayString().getString();
    }

    public Image getImage() {
        String key = TexUIResources.INSTANCE.getCommandImageId(this.command);
        return key != null ? TexUIResources.INSTANCE.getImage(key) : null;
    }

    public StyledString getStyledDisplayString() {
        if (this.displayString == null) {
            StyledString s = new StyledString((this.command.getType() & 0xF) == 2 ? this.command.getControlWord() : "\\" + this.command.getControlWord());
            for (Argument arg : this.command.getArguments()) {
                if ((arg.getType() & 2) != 0) {
                    s.append("[]");
                    continue;
                }
                s.append("{}");
            }
            s.append(" \u2013 " + this.command.getDescription(), StyledString.QUALIFIER_STYLER);
            this.displayString = s;
        }
        return this.displayString;
    }

    protected final ApplyData getApplyData() {
        if (this.applyData == null) {
            this.applyData = new ApplyData(this.getInvocationContext());
        }
        return this.applyData;
    }

    protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadLocationException {
        int end = Math.max(caretOffset, selection.x + selection.y);
        if (overwrite) {
            ApplyData data = this.getApplyData();
            IDocument document = data.getDocument();
            --end;
            block3: while (++end < document.getLength()) {
                switch (document.getChar(end)) {
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        break;
                    }
                    default: {
                        break block3;
                    }
                }
            }
        }
        return end - replacementOffset;
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int start = this.getReplacementOffset();
            String prefix = document.get(start, offset - start);
            return prefix.regionMatches(true, 0, this.command.getControlWord(), 0, prefix.length());
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
        List args;
        ApplyData data = this.getApplyData();
        IDocument document = data.getDocument();
        StringBuilder replacement = new StringBuilder(this.command.getControlWord());
        if ((stateMask & 1) == 1) {
            replacement.insert(0, '\\');
        }
        int cursor = replacement.length();
        int mode = 0;
        IntArrayList positions = null;
        if (this.command == IEnvDefinitions.VERBATIM_verb_COMMAND) {
            mode = 201;
        } else if ((this.command.getType() & 0xF) != 2 && (args = this.command.getArguments()) != null && !args.isEmpty()) {
            boolean isFirstOptional = ((Argument)args.get(0)).isOptional();
            int idxFirstRequired = -1;
            int i = isFirstOptional ? 1 : 0;
            while (i < args.size()) {
                Argument arg = (Argument)args.get(i);
                if (arg.isRequired()) {
                    idxFirstRequired = i;
                    break;
                }
                ++i;
            }
            if (idxFirstRequired >= 0) {
                if (replacementOffset + replacementLength < document.getLength() - 1 && (document.getChar(replacementOffset + replacementLength) == '{' || isFirstOptional && document.getChar(replacementOffset + replacementLength) == '[')) {
                    ++cursor;
                    mode = 10;
                } else if (!LtxCommandCompletionProposal.isFollowedByOpeningBracket(data, replacementOffset + replacementLength, isFirstOptional)) {
                    replacement.append('{');
                    ++cursor;
                    mode = 11;
                }
                if (mode >= 10 && mode == 11 && !LtxCommandCompletionProposal.isClosedBracket(data, replacementOffset, replacementOffset + replacementLength)) {
                    replacement.append('}');
                    positions = new IntArrayList();
                    mode = 0;
                    if (isFirstOptional) {
                        positions.add(mode);
                    }
                    int n = ++mode;
                    ++mode;
                    positions.add(n);
                    i = idxFirstRequired + 1;
                    while (i < args.size()) {
                        if (((Argument)args.get(i)).isRequired()) {
                            replacement.append("{}");
                            int n2 = ++mode;
                            ++mode;
                            positions.add(n2);
                        } else if (positions.getAt(positions.size() - 1) != mode) {
                            positions.add(mode);
                        }
                        ++i;
                    }
                    if (positions.getAt(positions.size() - 1) != mode) {
                        positions.add(mode);
                    }
                    mode = 111;
                }
            }
        }
        document.replace(replacementOffset, replacementLength, replacement.toString());
        this.setCursorPosition(replacementOffset + cursor);
        if (mode > 100 && mode < 200) {
            this.createLinkedMode(data, replacementOffset + cursor - (mode - 110), (IntList)positions).enter();
        } else if (mode > 200 && mode < 300) {
            this.createLinkedVerbMode(data, replacementOffset + cursor);
        }
        if ((this.command.getType() & 0xF) == 1) {
            this.reinvokeAssist((ITextViewer)data.getViewer());
        }
    }

    private LinkedModeUI createLinkedMode(ApplyData data, int offset, IntList positions) throws BadLocationException {
        AssistInvocationContext context = this.getInvocationContext();
        LinkedModeModel model = new LinkedModeModel();
        int pos = 0;
        ArrayList<LinkedPosition> linked = new ArrayList<LinkedPosition>(positions.size());
        int i = 0;
        while (i < positions.size() - 1) {
            LinkedPosition linkedPosition;
            LinkedPositionGroup group = new LinkedPositionGroup();
            if (positions.getAt(i) % 2 == 1) {
                linkedPosition = TexBracketLevel.createPosition('{', data.getDocument(), offset + positions.getAt(i), 0, pos++);
            } else {
                ++pos;
                linkedPosition = new LinkedPosition(data.getDocument(), offset + positions.getAt(i), 0, pos);
            }
            LinkedPosition position = linkedPosition;
            group.addPosition(position);
            linked.add(position);
            model.addGroup(group);
            ++i;
        }
        model.forceInstall();
        TexBracketLevel level = new TexBracketLevel(model, data.getDocument(), context.getEditor().getDocumentContentInfo(), linked, 0x1000000);
        LinkedModeUI ui = new LinkedModeUI(model, (ITextViewer)data.getViewer());
        ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
        ui.setExitPosition((ITextViewer)data.getViewer(), offset + positions.getAt(positions.size() - 1), 0, pos);
        ui.setSimpleMode(true);
        ui.setExitPolicy((LinkedModeUI.IExitPolicy)level);
        return ui;
    }

    private void createLinkedVerbMode(ApplyData data, int offset) throws BadLocationException {
        final LinkedSepMode mode = new LinkedSepMode(data.getViewer(), data.getDocument(), offset);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                mode.install();
            }
        });
    }

    protected void setCursorPosition(int offset) {
        this.selection = new Point(offset, 0);
    }

    public Point getSelection(IDocument document) {
        return this.selection;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    static final class ApplyData {
        private final AssistInvocationContext context;
        private final SourceViewer viewer;
        private final IDocument document;
        private LtxHeuristicTokenScanner scanner;

        ApplyData(AssistInvocationContext context) {
            this.context = context;
            this.viewer = context.getSourceViewer();
            this.document = this.viewer.getDocument();
        }

        public SourceViewer getViewer() {
            return this.viewer;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public LtxHeuristicTokenScanner getScanner() {
            if (this.scanner == null) {
                this.scanner = LtxHeuristicTokenScanner.create((IDocContentSections)this.context.getEditor().getDocumentContentInfo());
            }
            return this.scanner;
        }
    }

    public static class Env
    extends LtxCommandCompletionProposal {
        protected Env(AssistInvocationContext context, int startOffset, TexCommand command, int relevance) {
            super(context, startOffset, command);
            this.relevance += relevance;
        }

        @Override
        public StyledString getStyledDisplayString() {
            if (this.displayString == null) {
                StyledString s = new StyledString(this.command.getControlWord());
                s.append("\u2002\u2013\u2002", StyledString.QUALIFIER_STYLER);
                s.append(this.command.getDescription(), StyledString.QUALIFIER_STYLER);
                this.displayString = s;
            }
            return this.displayString;
        }
    }

    private static class LinkedSepMode
    implements IDocumentListener,
    VerifyKeyListener {
        private final SourceViewer viewer;
        private final IDocument document;
        private final int offset;
        private boolean inserted;
        private boolean intern;

        public LinkedSepMode(SourceViewer viewer, IDocument document, int offset) {
            this.viewer = viewer;
            this.document = document;
            this.offset = offset;
        }

        public void install() {
            if (UIAccess.isOkToUse((Viewer)this.viewer)) {
                this.viewer.getTextWidget().addVerifyKeyListener((VerifyKeyListener)this);
                this.document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void verifyKey(VerifyEvent event) {
            if (this.viewer.getDocument() == this.document) {
                Point selection = this.viewer.getSelectedRange();
                if (!this.inserted && selection.x == this.offset && selection.y == 0 && event.character != '\u0000') {
                    try {
                        char currentChar = this.offset < this.document.getLength() ? (char)this.document.getChar(this.offset) : (char)'\n';
                        char c = event.character;
                        if (currentChar <= ' ' && currentChar != c && c >= ' ' && !Character.isLetterOrDigit(c)) {
                            this.intern = true;
                            this.document.replace(this.offset, 0, "" + c + c);
                            this.inserted = true;
                            event.doit = false;
                            this.viewer.setSelection((ISelection)new TextSelection(this.offset + 1, 0), true);
                            return;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    finally {
                        this.intern = false;
                    }
                }
                if (this.inserted && event.character == '\b' && selection.x == this.offset + 1 && selection.y == 0) {
                    try {
                        this.intern = true;
                        this.document.replace(this.offset, 2, "");
                        this.inserted = false;
                        event.doit = false;
                        return;
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    finally {
                        this.intern = false;
                    }
                }
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (!this.intern) {
                this.dispose();
            }
        }

        private void dispose() {
            this.viewer.getTextWidget().removeVerifyKeyListener((VerifyKeyListener)this);
            this.document.removeDocumentListener((IDocumentListener)this);
        }
    }
}

