/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultEvictionPolicy;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.statet.internal.rj.servi.APool2NodeFactory;
import org.eclipse.statet.internal.rj.servi.APool2NodeHandler;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.servi.pool.PoolConfig;

@NonNullByDefault
public class APool2
extends GenericObjectPool<APool2NodeHandler> {
    private static final EvictionPolicy<APool2NodeHandler> EVICTION_POLICY = new DefaultEvictionPolicy<APool2NodeHandler>(){

        public boolean evict(EvictionConfig config, PooledObject<APool2NodeHandler> underTest, int idleCount) {
            return super.evict(config, underTest, idleCount) || ((APool2NodeHandler)underTest.getObject()).isEvictRequested(0L);
        }
    };
    private final APool2NodeFactory factory;
    private volatile boolean closing;

    private static GenericObjectPoolConfig<APool2NodeHandler> createAConfig(PoolConfig config) {
        GenericObjectPoolConfig aConfig = new GenericObjectPoolConfig();
        aConfig.setLifo(true);
        aConfig.setTestOnReturn(true);
        aConfig.setTestWhileIdle(false);
        aConfig.setTestOnBorrow(false);
        aConfig.setBlockWhenExhausted(true);
        aConfig.setMaxTotal(config.getMaxTotalCount());
        aConfig.setMaxWaitMillis(config.getMaxWaitTime());
        aConfig.setMinIdle(config.getMinIdleCount());
        aConfig.setMaxIdle(config.getMaxIdleCount());
        aConfig.setMinEvictableIdleTimeMillis(0L);
        aConfig.setSoftMinEvictableIdleTimeMillis(config.getMinIdleTime());
        aConfig.setTimeBetweenEvictionRunsMillis(7500L);
        aConfig.setNumTestsPerEvictionRun(-3);
        return aConfig;
    }

    public APool2(APool2NodeFactory factory, PoolConfig config) {
        super((PooledObjectFactory)factory, APool2.createAConfig(config));
        factory.setPool(this);
        this.factory = factory;
    }

    public void setConfig(PoolConfig config) {
        this.setConfig(APool2.createAConfig(config));
    }

    public APool2NodeHandler borrowObject(String client) throws Exception {
        if (this.closing) {
            throw new IllegalStateException("Pool not open");
        }
        this.factory.registerArgs(client);
        try {
            APool2NodeHandler aPool2NodeHandler = (APool2NodeHandler)super.borrowObject();
            return aPool2NodeHandler;
        }
        finally {
            this.factory.clearArgs();
        }
    }

    public int getMinIdle() {
        if (this.closing) {
            return 0;
        }
        return super.getMinIdle();
    }

    public void close(long evictionTimeout) {
        this.closing = true;
        this.clear();
        long evictNanos = APool2NodeHandler.evictNanos(evictionTimeout);
        boolean evictDirect = evictionTimeout == 0L;
        ImList<APool2NodeHandler> objects = this.factory.getAllObjects();
        for (APool2NodeHandler poolObj : objects) {
            poolObj.doEvict(evictNanos, evictDirect);
        }
    }

    public void evict() throws Exception {
        int evicted;
        do {
            evicted = 0;
            long nanos = APool2NodeHandler.safeNanos(System.nanoTime());
            ImList<APool2NodeHandler> objects = this.factory.getAllObjects();
            for (APool2NodeHandler poolObj : objects) {
                if (!poolObj.isEvictRequested(nanos)) continue;
                try {
                    ++evicted;
                    this.invalidateObject(poolObj);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } while (evicted > 0);
        super.evict();
        if (this.closing && this.factory.getNumAll() == 0) {
            super.close();
            this.factory.dispose();
        }
    }

    public EvictionPolicy<APool2NodeHandler> getEvictionPolicy() {
        return EVICTION_POLICY;
    }
}

