/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core.workspace;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.databinding.core.validation.ValidationUtils;
import org.eclipse.statet.ecommons.io.internal.Messages;

public class RelativePathValidator
implements IValidator {
    private final int resourceType;
    private IContainer baseContainer;
    private final String resourceLabel;
    private int onEmpty;

    public RelativePathValidator(int resourceType, IContainer container, String resourceLabel) {
        this.resourceType = resourceType;
        this.baseContainer = container;
        this.resourceLabel = resourceLabel;
    }

    public void setBaseContainer(IContainer container) {
        this.baseContainer = container;
    }

    public IContainer getBaseContainer() {
        return this.baseContainer;
    }

    public IStatus validate(Object value) {
        if (value instanceof String) {
            String s = ((String)value).trim();
            if (s.isEmpty()) {
                return this.onEmtpy();
            }
            return this.validatePath((IPath)new Path(s));
        }
        if (value instanceof IPath) {
            return this.validatePath((IPath)value);
        }
        throw new IllegalArgumentException();
    }

    protected IStatus validatePath(IPath path) {
        if (path.isAbsolute() || path.getDevice() != null) {
            return this.onAbsolute();
        }
        if (path.isEmpty()) {
            return this.onEmtpy();
        }
        IContainer baseContainer = this.getBaseContainer();
        if (baseContainer == null) {
            throw new IllegalStateException("baseContainer is missing.");
        }
        IWorkspace workspace = baseContainer.getWorkspace();
        int i = 0;
        while (i < path.segmentCount()) {
            IStatus status = workspace.validateName(path.segment(i), 2);
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        return ValidationStatus.ok();
    }

    protected IStatus onEmtpy() {
        if (this.onEmpty == 0) {
            return ValidationStatus.ok();
        }
        return ValidationUtils.newStatus((int)this.onEmpty, (String)(this.resourceLabel != null ? NLS.bind((String)Messages.Resource_error_NoInput_message, (Object)this.resourceLabel) : Messages.Resource_error_NoInput_message_0));
    }

    protected IStatus onAbsolute() {
        return ValidationStatus.error((String)(this.resourceLabel != null ? NLS.bind((String)Messages.Resource_error_NotRelative_message, (Object)this.resourceLabel) : Messages.Resource_error_NotRelative_message_0));
    }
}

