/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui.presentation;

import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.ui.ColorSelectorObservableValue;
import org.eclipse.statet.ecommons.preferences.ui.OverlayStoreConfigurationBlock;
import org.eclipse.statet.ecommons.preferences.ui.OverlayStorePreference;
import org.eclipse.statet.ecommons.preferences.ui.PreferenceStoreBeanWrapper;
import org.eclipse.statet.ecommons.preferences.ui.RGBPref;
import org.eclipse.statet.ecommons.text.ui.TextViewerEditorColorUpdater;
import org.eclipse.statet.ecommons.text.ui.TextViewerJFaceUpdater;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;
import org.eclipse.statet.ecommons.ui.ColorManager;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.ecommons.ui.util.PixelConverter;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.ecommons.text.ui.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public abstract class AbstractTextStylesConfigurationBlock
extends OverlayStoreConfigurationBlock {
    private SyntaxNode[] rootNodes;
    private DataBindingContext dbc;
    private TreeViewer selectionViewer;
    private Set<String> groupIds;
    private ComboViewer useViewer;
    private Label colorLabel;
    private ColorSelector colorEditor;
    private Button boldCheckbox;
    private Button italicCheckbox;
    private Button strikethroughCheckbox;
    private Button underlineCheckbox;
    private ColorManager colorManager;
    private TextStyleManager textStyles;
    protected SourceViewer previewViewer;
    private SourceEditorViewerConfiguration configuration;

    private static void collectKeys(List<OverlayStorePreference> keys, ViewerUtils.Node[] nodes) {
        ViewerUtils.Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerUtils.Node[] children;
            ViewerUtils.Node node = nodeArray[n2];
            if (node instanceof SyntaxNode) {
                ((SyntaxNode)node).gatherPreferenceKeys(keys);
            }
            if ((children = node.getChildren()) != null) {
                AbstractTextStylesConfigurationBlock.collectKeys(keys, children);
            }
            ++n2;
        }
    }

    private static void connectStore(ViewerUtils.Node[] nodes, IPreferenceStore store) {
        ViewerUtils.Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerUtils.Node[] children;
            ViewerUtils.Node node = nodeArray[n2];
            if (node instanceof SyntaxNode) {
                ((SyntaxNode)node).connectPreferenceStore(store);
            }
            if ((children = node.getChildren()) != null) {
                AbstractTextStylesConfigurationBlock.connectStore(children, store);
            }
            ++n2;
        }
    }

    protected abstract SyntaxNode[] createItems();

    protected abstract String getSettingsGroup();

    protected Set<String> getChangedGroups() {
        return this.groupIds;
    }

    protected String getLinkMessage() {
        return Messages.SyntaxColoring_link;
    }

    protected boolean isTextAttributesSupported() {
        return true;
    }

    protected void createBlockArea(Composite pageComposite) {
        this.rootNodes = this.createItems();
        this.groupIds = new HashSet<String>();
        this.groupIds.add(this.getSettingsGroup());
        ArrayList<OverlayStorePreference> keys = new ArrayList<OverlayStorePreference>();
        AbstractTextStylesConfigurationBlock.collectKeys(keys, this.rootNodes);
        this.setupOverlayStore(keys.toArray(new OverlayStorePreference[keys.size()]));
        AbstractTextStylesConfigurationBlock.connectStore(this.rootNodes, (IPreferenceStore)this.fOverlayStore);
        String message = this.getLinkMessage();
        if (message != null) {
            this.addLinkHeader(pageComposite, Messages.SyntaxColoring_link);
        }
        Composite composite = new Composite(pageComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label.setText(Messages.SyntaxColoring_List_label);
        Composite configComposite = new Composite(composite, 0);
        configComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        configComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Control selectionControl = this.createTreeViewer(configComposite);
        GridData gd = new GridData(4, 4, false, true);
        Point size = ViewerUtils.calculateTreeSizeHint((Control)this.selectionViewer.getControl(), (ViewerUtils.Node[])this.rootNodes, (int)9);
        gd.widthHint = size.x;
        gd.heightHint = size.y;
        selectionControl.setLayoutData((Object)gd);
        Control optionControl = this.createOptionsControl(configComposite);
        gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 5;
        optionControl.setLayoutData((Object)gd);
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData(4, 4, true, false));
        label2.setText(Messages.SyntaxColoring_Preview);
        Control previewerControl = this.createPreviewer(composite);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        PixelConverter conv = new PixelConverter(previewerControl);
        gd.widthHint = conv.convertWidthInCharsToPixels(20);
        gd.heightHint = conv.convertHeightInCharsToPixels(5);
        previewerControl.setLayoutData((Object)gd);
        this.initFields();
        this.initBindings();
        UIAccess.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (UIAccess.isOkToUse((Viewer)AbstractTextStylesConfigurationBlock.this.selectionViewer)) {
                    AbstractTextStylesConfigurationBlock.this.selectionViewer.setSelection((ISelection)new StructuredSelection((Object)AbstractTextStylesConfigurationBlock.this.rootNodes[0]));
                }
            }
        });
    }

    public Control createTreeViewer(Composite parent) {
        this.selectionViewer = new TreeViewer(parent, 2818);
        this.selectionViewer.setContentProvider((IContentProvider)new ViewerUtils.NodeContentProvider());
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)new SyntaxNodeLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.selectionViewer);
        ViewerUtils.addDoubleClickExpansion((TreeViewer)this.selectionViewer);
        return this.selectionViewer.getControl();
    }

    private Control createOptionsControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        this.useViewer = new ComboViewer(composite, 12);
        this.useViewer.setLabelProvider((IBaseLabelProvider)new UseStyleLabelProvider());
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.widthHint = LayoutUtils.hintWidth((Combo)this.useViewer.getCombo(), (String[])new String[]{"XXXXXXXXXXXXXXX", Messages.SyntaxColoring_Use_CustomStyle_label, Messages.SyntaxColoring_Use_NoExtraStyle_label});
        this.useViewer.getControl().setLayoutData((Object)gd);
        int indent = LayoutUtils.defaultSmallIndent();
        Label label = new Label(composite, 0);
        GridData gd2 = new GridData(4, 0x1000000, false, false);
        gd2.horizontalIndent = indent;
        label.setLayoutData((Object)gd2);
        label.setText(Messages.SyntaxColoring_Color);
        this.colorLabel = label;
        this.colorEditor = new ColorSelector(composite);
        Button foregroundColorButton = this.colorEditor.getButton();
        foregroundColorButton.setLayoutData((Object)new GridData(32));
        this.boldCheckbox = new Button(composite, 32);
        GridData gd3 = new GridData(4, 0x1000000, false, false);
        gd3.horizontalIndent = indent;
        this.boldCheckbox.setLayoutData((Object)gd3);
        this.boldCheckbox.setText(Messages.SyntaxColoring_Bold);
        this.italicCheckbox = new Button(composite, 32);
        gd3 = new GridData(4, 0x1000000, false, false);
        gd3.horizontalIndent = indent;
        this.italicCheckbox.setLayoutData((Object)gd3);
        this.italicCheckbox.setText(Messages.SyntaxColoring_Italic);
        this.underlineCheckbox = new Button(composite, 32);
        gd3 = new GridData(4, 0x1000000, false, false);
        gd3.horizontalIndent = indent;
        this.underlineCheckbox.setLayoutData((Object)gd3);
        this.underlineCheckbox.setText(Messages.SyntaxColoring_Underline);
        this.strikethroughCheckbox = new Button(composite, 32);
        gd3 = new GridData(4, 0x1000000, false, false);
        gd3.horizontalIndent = indent;
        this.strikethroughCheckbox.setLayoutData((Object)gd3);
        this.strikethroughCheckbox.setText(Messages.SyntaxColoring_Strikethrough);
        return composite;
    }

    private Control createPreviewer(Composite parent) {
        this.colorManager = new ColorManager();
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.fOverlayStore, EditorsUI.getPreferenceStore()});
        this.previewViewer = new SourceViewer(parent, null, null, false, 2816);
        this.previewViewer.setEditable(false);
        this.configuration = this.getSourceViewerConfiguration(this.colorManager, (IPreferenceStore)store);
        this.previewViewer.configure((SourceViewerConfiguration)this.configuration);
        new TextViewerJFaceUpdater((ISourceViewer)this.previewViewer, (IPreferenceStore)store);
        new TextViewerEditorColorUpdater(this.previewViewer, (IPreferenceStore)store);
        String content = this.loadPreviewContentFromFile(this.getPreviewFileName());
        Document document = new Document(content);
        this.getDocumentSetupParticipant().setup((IDocument)document);
        this.previewViewer.setDocument((IDocument)document);
        return this.previewViewer.getControl();
    }

    protected abstract String getPreviewFileName();

    protected SourceEditorViewerConfiguration getSourceViewerConfiguration(ColorManager colorManager, IPreferenceStore preferenceStore) {
        this.textStyles = new TextStyleManager(colorManager, preferenceStore, this.getSettingsGroup());
        return this.getSourceEditorViewerConfiguration(preferenceStore, this.textStyles);
    }

    protected abstract SourceEditorViewerConfiguration getSourceEditorViewerConfiguration(IPreferenceStore var1, TextStyleManager var2);

    protected abstract IDocumentSetupParticipant getDocumentSetupParticipant();

    private String loadPreviewContentFromFile(String filename) {
        StringBuffer buffer;
        block15: {
            String separator = "\n";
            buffer = new StringBuffer(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append("\n");
                    }
                }
                catch (IOException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, NLS.bind((String)"An error occurred when loading the preview code from ''{0}''.", (Object)filename), (Throwable)e));
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return buffer.toString();
    }

    public void initFields() {
        this.selectionViewer.setInput((Object)this.rootNodes);
    }

    private void initBindings() {
        final Realm realm = Realm.getDefault();
        this.dbc = new DataBindingContext(realm);
        IViewerObservableValue selectionValue = ViewersObservables.observeSingleSelection((Viewer)this.selectionViewer);
        selectionValue.addValueChangeListener(event -> {
            SyntaxNode newNode = (SyntaxNode)((Object)((Object)event.diff.getNewValue()));
            if (newNode != null) {
                this.updateEnablement(newNode, newNode.getUseStyle());
            }
        });
        IObservableList list = MasterDetailObservables.detailList((IObservableValue)BeanProperties.value((String)"availableUseStyles", List.class).observeDetail((IObservableValue)selectionValue), (IObservableFactory)new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return Observables.staticObservableList((Realm)realm, (List)((List)target));
            }
        }, null);
        this.useViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.useViewer.setInput((Object)list);
        IObservableValue useStyle = BeanProperties.value((String)"useStyle", SyntaxNode.UseStyle.class).observeDetail((IObservableValue)selectionValue);
        useStyle.addValueChangeListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)this.selectionViewer.getSelection();
            SyntaxNode.UseStyle newUse = (SyntaxNode.UseStyle)event.diff.getNewValue();
            this.updateEnablement((SyntaxNode)((Object)((Object)selection.getFirstElement())), newUse);
        });
        this.dbc.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.useViewer), useStyle);
        this.dbc.bindValue((IObservableValue)new ColorSelectorObservableValue(this.colorEditor), BeanProperties.value((String)"color", RGB.class).observeDetail((IObservableValue)selectionValue));
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.boldCheckbox), BeanProperties.value((String)"bold", Boolean.class).observeDetail((IObservableValue)selectionValue));
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.italicCheckbox), BeanProperties.value((String)"italic", Boolean.class).observeDetail((IObservableValue)selectionValue));
        if (this.isTextAttributesSupported()) {
            this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.strikethroughCheckbox), BeanProperties.value((String)"strikethrough", Boolean.class).observeDetail((IObservableValue)selectionValue));
            this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.underlineCheckbox), BeanProperties.value((String)"underline", Boolean.class).observeDetail((IObservableValue)selectionValue));
        } else {
            this.strikethroughCheckbox.setVisible(false);
            this.underlineCheckbox.setVisible(false);
        }
    }

    private void updateEnablement(SyntaxNode node, SyntaxNode.UseStyle useStyle) {
        boolean enableOptions;
        int showOptions;
        if (node instanceof StyleNode) {
            this.useViewer.getControl().setEnabled(node.getAvailableUseStyles().size() > 1);
            showOptions = 2;
            enableOptions = useStyle != null && useStyle.getRefRootKey().equals("");
        } else if (node instanceof BackgroundNode) {
            this.useViewer.getControl().setEnabled(false);
            showOptions = 1;
            enableOptions = true;
        } else {
            this.useViewer.getControl().setEnabled(false);
            showOptions = 0;
            enableOptions = false;
        }
        this.colorLabel.setVisible(showOptions >= 1);
        this.colorEditor.getButton().setVisible(showOptions >= 1);
        this.colorLabel.setEnabled(enableOptions);
        this.colorEditor.setEnabled(enableOptions);
        this.boldCheckbox.setVisible(showOptions >= 2);
        this.boldCheckbox.setEnabled(enableOptions);
        this.italicCheckbox.setVisible(showOptions >= 2);
        this.italicCheckbox.setEnabled(enableOptions);
        if (this.isTextAttributesSupported()) {
            this.strikethroughCheckbox.setVisible(showOptions >= 2);
            this.strikethroughCheckbox.setEnabled(enableOptions);
            this.underlineCheckbox.setVisible(showOptions >= 2);
            this.underlineCheckbox.setEnabled(enableOptions);
        }
    }

    protected void handlePropertyChange() {
        if (UIAccess.isOkToUse((Viewer)this.previewViewer)) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (this.textStyles != null) {
                this.textStyles.handleSettingsChanged(this.groupIds, options);
            }
            this.configuration.handleSettingsChanged(this.groupIds, options);
            this.previewViewer.invalidateTextPresentation();
        }
    }

    public void dispose() {
        if (this.dbc != null) {
            this.dbc.dispose();
            this.dbc = null;
        }
        if (this.colorManager != null) {
            this.colorManager.dispose();
            this.colorManager = null;
        }
        super.dispose();
    }

    protected String addListToTooltip(String tooltip, String[] listItems) {
        StringBuilder description = new StringBuilder(tooltip);
        int end = Math.min(20, listItems.length);
        int i = 0;
        while (i < end) {
            description.append("\n    ");
            description.append(listItems[i]);
            ++i;
        }
        if (end < listItems.length) {
            description.append("\n    ... (" + listItems.length + ')');
        }
        return MessageUtils.escapeForTooltip((CharSequence)description);
    }

    protected String addExtraStyleNoteToTooltip(String tooltip) {
        return NLS.bind((String)tooltip, (Object)Messages.SyntaxColoring_MindExtraStyle_tooltip);
    }

    protected static class BackgroundNode
    extends SyntaxNode {
        private final String rootKey;

        public BackgroundNode(String name, String description, String rootKey) {
            super(name, description, null, ImCollections.newList((Object)BackgroundNode.createUseCustomStyle()));
            this.rootKey = rootKey;
            ArrayList<SyntaxNode.PrefProperty> prefs = new ArrayList<SyntaxNode.PrefProperty>();
            prefs.add(new SyntaxNode.PrefProperty((Preference<?>)new RGBPref(null, this.getColorKey()), "color"));
            this.setPreferences(prefs);
        }

        private String getColorKey() {
            return String.valueOf(this.rootKey) + ".color";
        }

        @Override
        public RGB getColor() {
            return PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorKey());
        }

        @Override
        public void setColor(RGB color) {
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorKey(), (RGB)color);
        }
    }

    protected static class CategoryNode
    extends SyntaxNode {
        public CategoryNode(String name, SyntaxNode[] children) {
            super(name, null, children, ImCollections.emptyList());
        }
    }

    protected static class StyleNode
    extends SyntaxNode {
        private final String rootKey;

        public StyleNode(String name, String description, String rootKey, SyntaxNode.UseStyle[] availableStyles, SyntaxNode[] children) {
            super(name, description, children, ImCollections.newList((Object[])availableStyles));
            this.rootKey = rootKey;
            ArrayList<SyntaxNode.PrefProperty> prefs = new ArrayList<SyntaxNode.PrefProperty>();
            if (this.getAvailableUseStyles().size() > 1) {
                prefs.add(new SyntaxNode.PrefProperty(new UseStylePref(null, this.getUseKey()), "useStyle"));
            }
            prefs.add(new SyntaxNode.PrefProperty((Preference<?>)new RGBPref(null, this.getColorKey()), "color"));
            prefs.add(new SyntaxNode.PrefProperty((Preference<?>)new Preference.BooleanPref(null, this.getBoldKey()), "bold"));
            prefs.add(new SyntaxNode.PrefProperty((Preference<?>)new Preference.BooleanPref(null, this.getItalicKey()), "italic"));
            prefs.add(new SyntaxNode.PrefProperty((Preference<?>)new Preference.BooleanPref(null, this.getUnderlineKey()), "underline"));
            prefs.add(new SyntaxNode.PrefProperty((Preference<?>)new Preference.BooleanPref(null, this.getStrikethroughKey()), "strikethrough"));
            this.setPreferences(prefs);
        }

        private String getUseKey() {
            return String.valueOf(this.rootKey) + ".use";
        }

        private String getColorKey() {
            return String.valueOf(this.rootKey) + ".color";
        }

        private String getBoldKey() {
            return String.valueOf(this.rootKey) + ".bold";
        }

        private String getItalicKey() {
            return String.valueOf(this.rootKey) + ".italic";
        }

        private String getUnderlineKey() {
            return String.valueOf(this.rootKey) + ".underline";
        }

        private String getStrikethroughKey() {
            return String.valueOf(this.rootKey) + ".strikethrough";
        }

        @Override
        public void setUseStyle(SyntaxNode.UseStyle useStyle) {
            if (useStyle != null) {
                this.getPreferenceStore().setValue(this.getUseKey(), useStyle.getRefRootKey());
            }
        }

        @Override
        public SyntaxNode.UseStyle getUseStyle() {
            return this.getUseStyle(this.getPreferenceStore().getString(this.getUseKey()));
        }

        @Override
        public RGB getColor() {
            return PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorKey());
        }

        @Override
        public void setColor(RGB color) {
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorKey(), (RGB)color);
        }

        @Override
        public boolean isBold() {
            return this.getPreferenceStore().getBoolean(this.getBoldKey());
        }

        @Override
        public void setBold(boolean enabled) {
            this.getPreferenceStore().setValue(this.getBoldKey(), enabled);
        }

        @Override
        public boolean isItalic() {
            return this.getPreferenceStore().getBoolean(this.getItalicKey());
        }

        @Override
        public void setItalic(boolean enabled) {
            this.getPreferenceStore().setValue(this.getItalicKey(), enabled);
        }

        @Override
        public boolean isStrikethrough() {
            return this.getPreferenceStore().getBoolean(this.getStrikethroughKey());
        }

        @Override
        public void setStrikethrough(boolean enabled) {
            this.getPreferenceStore().setValue(this.getStrikethroughKey(), enabled);
        }

        @Override
        public boolean isUnderline() {
            return this.getPreferenceStore().getBoolean(this.getUnderlineKey());
        }

        @Override
        public void setUnderline(boolean enabled) {
            this.getPreferenceStore().setValue(this.getUnderlineKey(), enabled);
        }

        public class UseStylePref
        extends Preference<SyntaxNode.UseStyle> {
            UseStylePref(String qualifier, String key) {
                super(qualifier, key);
            }

            public Class<SyntaxNode.UseStyle> getUsageType() {
                return SyntaxNode.UseStyle.class;
            }

            public SyntaxNode.UseStyle store2Usage(String storeValue) {
                return StyleNode.this.getUseStyle(storeValue);
            }

            public String usage2Store(SyntaxNode.UseStyle usageValue) {
                return usageValue.getRefRootKey();
            }
        }
    }

    protected static abstract class SyntaxNode
    extends ViewerUtils.Node {
        public static final String PROP_USE = "useStyle";
        public static final String PROP_COLOR = "color";
        public static final String PROP_BOLD = "bold";
        public static final String PROP_ITALIC = "italic";
        public static final String PROP_STRIKETHROUGH = "strikethrough";
        public static final String PROP_UNDERLINE = "underline";
        private final String description;
        private final ImList<UseStyle> availableStyles;
        private IPreferenceStore preferenceStore;
        private ImList<PrefProperty> preferences = ImCollections.emptyList();
        private PreferenceStoreBeanWrapper beanSupport;

        public static UseStyle createUseCustomStyle() {
            return new UseStyle("", Messages.SyntaxColoring_Use_CustomStyle_label);
        }

        public static UseStyle createUseNoExtraStyle(String parentKey) {
            return new UseStyle(parentKey, Messages.SyntaxColoring_Use_NoExtraStyle_label);
        }

        public static UseStyle createUseOtherStyle(String otherKey, String otherLabel) {
            return new UseStyle(otherKey, NLS.bind((String)Messages.SyntaxColoring_Use_OtherStyle_label, (Object)otherLabel));
        }

        public static UseStyle createUseOtherStyle(String otherKey, String cat, String otherLabel) {
            return new UseStyle(otherKey, NLS.bind((String)Messages.SyntaxColoring_Use_OtherStyleOf_label, (Object)otherLabel, (Object)cat));
        }

        private SyntaxNode(String name, String description, SyntaxNode[] children, ImList<UseStyle> availableStyles) {
            super(name, (ViewerUtils.Node[])children);
            assert (availableStyles != null);
            this.description = description;
            this.availableStyles = availableStyles;
        }

        protected void setPreferences(List<PrefProperty> prefs) {
            this.preferences = ImCollections.toList(prefs);
        }

        public String getDescription() {
            return this.description;
        }

        protected void gatherPreferenceKeys(List<OverlayStorePreference> keys) {
            for (PrefProperty pref : this.preferences) {
                keys.add(OverlayStorePreference.create(pref.pref));
            }
        }

        protected void connectPreferenceStore(IPreferenceStore store) {
            this.preferenceStore = store;
            this.beanSupport = new PreferenceStoreBeanWrapper(store, (Object)this);
            for (PrefProperty pref : this.preferences) {
                this.beanSupport.addPreference(pref.prop, pref.pref);
            }
        }

        protected IPreferenceStore getPreferenceStore() {
            return this.preferenceStore;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.beanSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.beanSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.beanSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.beanSupport.removePropertyChangeListener(propertyName, listener);
        }

        public ImList<UseStyle> getAvailableUseStyles() {
            return this.availableStyles;
        }

        public UseStyle getUseStyle() {
            return !this.availableStyles.isEmpty() ? (UseStyle)this.availableStyles.get(0) : null;
        }

        protected UseStyle getUseStyle(String value) {
            for (UseStyle style : this.availableStyles) {
                if (!style.getRefRootKey().equals(value)) continue;
                return style;
            }
            return (UseStyle)this.availableStyles.get(0);
        }

        public void setUseStyle(UseStyle useStyle) {
        }

        public RGB getColor() {
            return null;
        }

        public void setColor(RGB color) {
        }

        public boolean isBold() {
            return false;
        }

        public void setBold(boolean enabled) {
        }

        public boolean isItalic() {
            return false;
        }

        public void setItalic(boolean enabled) {
        }

        public boolean isStrikethrough() {
            return false;
        }

        public void setStrikethrough(boolean enabled) {
        }

        public boolean isUnderline() {
            return false;
        }

        public void setUnderline(boolean enabled) {
        }

        protected static class PrefProperty {
            public final Preference<?> pref;
            public final String prop;

            public PrefProperty(Preference<?> pref, String prop) {
                this.pref = pref;
                this.prop = prop;
            }
        }

        public static class UseStyle {
            private final String label;
            private final String refRootKey;

            public UseStyle(String refRootKey, String label) {
                this.refRootKey = refRootKey;
                this.label = label;
            }

            public String getLabel() {
                return this.label;
            }

            public String getRefRootKey() {
                return this.refRootKey;
            }
        }
    }

    private static class SyntaxNodeLabelProvider
    extends CellLabelProvider {
        private SyntaxNodeLabelProvider() {
        }

        public boolean useNativeToolTip(Object object) {
            return true;
        }

        public String getToolTipText(Object element) {
            return ((SyntaxNode)((Object)element)).getDescription();
        }

        public void update(ViewerCell cell) {
            cell.setText(((ViewerUtils.Node)cell.getElement()).getName());
        }
    }

    private static class UseStyleLabelProvider
    extends LabelProvider {
        private UseStyleLabelProvider() {
        }

        public String getText(Object element) {
            SyntaxNode.UseStyle style = (SyntaxNode.UseStyle)element;
            return style.getLabel();
        }
    }
}

