/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.launching;

import org.eclipse.statet.ecommons.ts.ui.ToolRunnableDecorator;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.nico.core.runtime.ConsoleRunnable;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.r.console.core.AbstractRController;
import org.eclipse.swt.graphics.Image;

public class SubmitFileViaCommandRunnable
implements ConsoleRunnable,
ToolRunnableDecorator {
    private final String fCommand;
    private final ISourceUnit fSourceUnit;
    private final Image fImage;
    private final String fLabel;

    public SubmitFileViaCommandRunnable(Image image, String label, String command, ISourceUnit su) {
        this.fImage = image;
        this.fLabel = label;
        this.fCommand = command;
        this.fSourceUnit = su;
    }

    public String getTypeId() {
        return "r/console/runFileCommand";
    }

    public SubmitType getSubmitType() {
        return SubmitType.EDITOR;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public boolean canRunIn(Tool tool) {
        return tool.isProvidingFeatureSet("org.eclipse.statet.r.basic");
    }

    public boolean changed(int event, Tool tool) {
        return true;
    }

    public void run(ToolService service, ProgressMonitor m) throws StatusException {
        AbstractRController r = (AbstractRController)service;
        r.briefAboutToChange();
        try {
            r.submitFileCommandToConsole(new String[]{this.fCommand}, this.fSourceUnit, m);
        }
        finally {
            r.briefChanged(1);
        }
    }
}

