/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core;

import org.eclipse.statet.internal.rhelp.core.RHelpCoreInternals;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RPkgHelp;

@NonNullByDefault
public final class RHelpPageImpl
implements RHelpPage {
    private final RPkgHelp pkg;
    private final String name;
    private final ImList<String> topics;
    private final String title;

    public RHelpPageImpl(RPkgHelp pkgHelp, String name, ImList<String> topics, String title) {
        this.pkg = pkgHelp;
        this.name = name;
        this.topics = topics;
        this.title = title;
    }

    @Override
    public RPkgHelp getPackage() {
        return this.pkg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImList<String> getTopics() {
        return this.topics;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public int hashCode() {
        return this.pkg.hashCode() + this.name.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RHelpPage) {
            RHelpPage other = (RHelpPage)obj;
            return this.name.equals(other.getName()) && this.pkg.equals(other.getPackage());
        }
        return false;
    }

    @Override
    public int compareTo(RHelpPage o) {
        return RHelpCoreInternals.R_NAMES_COLLATOR.compare(this.name, o.getName());
    }

    public String toString() {
        return String.valueOf(this.pkg.getName()) + "::" + this.name;
    }
}

