/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rhelp;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.rhelp.JettyServer;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.http.RHelpHttpService;

@NonNullByDefault
public class WorkbenchRHelpHttpService
extends RHelpHttpService
implements Disposable {
    private boolean running;
    private boolean httpdStarted;
    private @Nullable JettyServer httpd;

    public WorkbenchRHelpHttpService(RHelpManager rHelpManager) {
        super(rHelpManager);
    }

    public boolean ensureIsRunning() {
        if (!this.httpdStarted) {
            this.startServer();
        }
        return this.running;
    }

    public void dispose() {
        this.stopServer();
    }

    protected String getHost() {
        return this.httpd.getHost();
    }

    protected int getPort() {
        return this.httpd.getPort();
    }

    private synchronized void startServer() {
        if (this.httpdStarted) {
            return;
        }
        JettyServer httpd = new JettyServer();
        try {
            httpd.startServer();
            this.httpd = httpd;
            this.running = true;
        }
        catch (Exception e) {
            RCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.core", -1, "An error occured when starting webserver for R help.", (Throwable)e));
            try {
                httpd.stopServer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.httpdStarted = true;
    }

    private synchronized void stopServer() {
        if (this.httpd == null) {
            return;
        }
        this.running = false;
        try {
            this.httpd.stopServer();
            this.httpd = null;
        }
        catch (Exception e) {
            RCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.core", -1, "An error occured when stopping webserver for R help.", (Throwable)e));
        }
    }
}

