/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.debug.ui.launcher.LaunchShortcutUtil;
import org.eclipse.statet.internal.r.debug.ui.launcher.SubmitEntireCommandHandler;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.r.core.rsource.ast.RAst;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.launching.RCodeLaunching;

public class SubmitFunctionDefHandler
extends SubmitEntireCommandHandler {
    public SubmitFunctionDefHandler() {
        super(false);
    }

    protected SubmitFunctionDefHandler(boolean gotoConsole) {
        super(gotoConsole);
    }

    @Override
    protected String getErrorMessage() {
        return RLaunchingMessages.RFunctionLaunch_error_message;
    }

    @Override
    protected IStatus getRegions(SubmitEntireCommandHandler.Data data) throws CoreException {
        RAstNode node = RAst.findLowestFDefAssignment((AstNode)data.ast.getRoot(), (int)data.selection.getOffset());
        if (node == null) {
            return LaunchShortcutUtil.createUnsupported();
        }
        try {
            if (RAst.hasErrors((RAstNode)node)) {
                return new Status(4, "org.eclipse.statet.r.ui", RLaunchingMessages.SubmitCode_info_SyntaxError_message);
            }
            data.nodes = new RAstNode[]{node};
            ArrayList<RCodeLaunching.SourceRegion> list = new ArrayList<RCodeLaunching.SourceRegion>(1);
            RCodeLaunching.SourceRegion region = new RCodeLaunching.SourceRegion(data.su, data.document);
            region.setBegin(this.checkStart((IDocument)data.document, node.getStartOffset()));
            region.setEnd(node.getEndOffset());
            region.setCode(data.document.get(region.getOffset(), region.getLength()));
            region.setNode(node);
            list.add(region);
            data.regions = list;
            return Status.OK_STATUS;
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, RLaunchingMessages.SubmitCode_error_WhenAnalyzingAndCollecting_message, (Throwable)e));
        }
    }

    public static class AndGotoConsole
    extends SubmitFunctionDefHandler {
        public AndGotoConsole() {
            super(true);
        }
    }
}

