/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.statet.ecommons.ui.workbench.DecoratingStyledLabelProvider;
import org.eclipse.statet.ecommons.workbench.search.ui.ExtTextSearchResultPage;
import org.eclipse.statet.ecommons.workbench.search.ui.LineElement;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchResultContentProvider;
import org.eclipse.statet.internal.r.ui.search.RElementMatch;
import org.eclipse.statet.internal.r.ui.search.RElementSearchLabelProvider;
import org.eclipse.statet.internal.r.ui.search.RElementSearchResult;
import org.eclipse.statet.internal.r.ui.search.RElementSearchResultTreeContentProvider;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.r.core.model.IRSourceUnit;

public class RElementSearchResultPage
extends ExtTextSearchResultPage<IRSourceUnit, RElementMatch> {
    public RElementSearchResultPage() {
        super(RElementSearchResult.COMPARATOR);
    }

    protected TextSearchResultContentProvider<IRSourceUnit, RElementMatch, TreeViewer> createTreeContentProvider(TreeViewer viewer) {
        return new RElementSearchResultTreeContentProvider(this, viewer);
    }

    protected void configureTableViewer(TableViewer viewer) {
        super.configureTableViewer(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new LTKDecoratingLabelProvider(new RElementSearchLabelProvider(this, 256)));
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        super.configureTreeViewer(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new LTKDecoratingLabelProvider(new RElementSearchLabelProvider(this, 256)));
    }

    public RElementMatch[] getDisplayedMatches(Object element) {
        if (element instanceof LineElement) {
            List<RElementMatch> matches = this.getDisplayedMatches((LineElement)element);
            return matches.toArray(new RElementMatch[matches.size()]);
        }
        return (RElementMatch[])super.getDisplayedMatches(element);
    }

    public List<RElementMatch> getDisplayedMatches(LineElement<?> group) {
        RElementMatch[] allMatches = (RElementMatch[])this.getInput().getPickedMatches(group.getElement());
        ArrayList<RElementMatch> groupMatches = new ArrayList<RElementMatch>();
        RElementMatch[] rElementMatchArray = allMatches;
        int n = allMatches.length;
        int n2 = 0;
        while (n2 < n) {
            RElementMatch match = rElementMatchArray[n2];
            if (match.getMatchGroup() == group) {
                groupMatches.add(match);
            }
            ++n2;
        }
        return groupMatches;
    }

    public int getDisplayedMatchCount(Object element) {
        if (element instanceof LineElement) {
            return this.getDisplayedMatchCount((LineElement)element);
        }
        return super.getDisplayedMatchCount(element);
    }

    public int getDisplayedMatchCount(LineElement<?> group) {
        RElementMatch[] allMatches = (RElementMatch[])this.getInput().getPickedMatches(group.getElement());
        int count = 0;
        RElementMatch[] rElementMatchArray = allMatches;
        int n = allMatches.length;
        int n2 = 0;
        while (n2 < n) {
            RElementMatch match = rElementMatchArray[n2];
            if (match.getMatchGroup() == group) {
                ++count;
            }
            ++n2;
        }
        return count++;
    }

    private static class LTKDecoratingLabelProvider
    extends DecoratingStyledLabelProvider {
        public LTKDecoratingLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider provider) {
            super(provider);
        }

        protected Object getElementToDecorate(Object element) {
            if (element instanceof ISourceUnit) {
                return ((ISourceUnit)element).getResource();
            }
            return element;
        }
    }
}

