/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.server;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.statet.internal.rhelp.server.RHelpServerInternals;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.AppEnvironment;
import org.eclipse.statet.jcommons.runtime.BasicAppEnvironment;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusPrinter;
import org.eclipse.statet.jcommons.status.Statuses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication
@ComponentScan(basePackageClasses={RHelpServerInternals.class})
@ServletComponentScan(basePackageClasses={RHelpServerInternals.class})
@NonNullByDefault
public class Application
extends BasicAppEnvironment {
    public static final String BUNDLE_ID = "org.eclipse.statet.rhelp.server";
    private final ConcurrentHashMap<String, Log> logs = new ConcurrentHashMap();
    private final StatusPrinter logStatusPrinter = new StatusPrinter();
    @Autowired
    private ApplicationContext appContext;

    public static void main(String[] args) {
        ImList argList;
        SpringApplication app = new SpringApplication(new Class[]{Application.class});
        if (args != null && (argList = ImCollections.newList((Object[])args)).contains((Object)"-index-and-exit")) {
            app.setWebApplicationType(WebApplicationType.NONE);
            app.setAdditionalProfiles(new String[]{"index-and-exit"});
        }
        app.run(args);
    }

    public Application() {
        CommonsRuntime.init((AppEnvironment)this);
        this.log((Status)new InfoStatus(BUNDLE_ID, "Application started."));
    }

    @PreDestroy
    protected void dispose() {
        this.onAppStopping();
        this.log((Status)new InfoStatus(BUNDLE_ID, "Application stopped."));
    }

    public String getBundleId() {
        return BUNDLE_ID;
    }

    public void log(Status status) {
        Log log = this.logs.computeIfAbsent(status.getBundleId(), s -> LogFactory.getLog((String)s));
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder();
        sb.append(Statuses.getSeverityString((byte)status.getSeverity()));
        sb.append(" [");
        sb.append(status.getCode());
        sb.append(']');
        if (status.getMessage().length() <= 80 && status.getMessage().indexOf(10) == -1) {
            sb.append(' ');
            sb.append(status.getMessage());
        } else {
            sb.addProp("message", status.getMessage());
        }
        if (status.isMultiStatus()) {
            ImList children = status.getChildren();
            if (children != null && !children.isEmpty()) {
                StringBuilder sb0 = new StringBuilder();
                sb0.append("Status:\n");
                this.logStatusPrinter.print((List)children, sb0);
                sb.addProp("children", sb0.toString());
            } else {
                sb.addProp("children", "<none>");
            }
        }
        switch (status.getSeverity()) {
            case 4: {
                log.error((Object)sb.toString(), status.getException());
                break;
            }
            case 2: {
                log.warn((Object)sb.toString(), status.getException());
                break;
            }
            default: {
                log.info((Object)sb.toString(), status.getException());
            }
        }
    }
}

